/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.cassandra.mail.FlagsExtractor;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIds;
import org.apache.james.mailbox.cassandra.table.CassandraMessageV3Table;
import org.apache.james.mailbox.cassandra.table.MessageIdToImapUid;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.streams.Limit;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CassandraMessageIdDAO {
    private static final String IMAP_UID_GTE = "uid_GTE";
    private static final String IMAP_UID_LTE = "uid_LTE";
    public static final String LIMIT = "LIMIT_BIND_MARKER";
    private static final String ADDED_USERS_FLAGS = "added_user_flags";
    private static final String REMOVED_USERS_FLAGS = "removed_user_flags";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final BlobId.Factory blobIdFactory;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement select;
    private final PreparedStatement selectAll;
    private final PreparedStatement selectAllUids;
    private final PreparedStatement selectAllLimited;
    private final PreparedStatement selectUidGte;
    private final PreparedStatement selectUidGteLimited;
    private final PreparedStatement selectUidRange;
    private final PreparedStatement selectUidRangeLimited;
    private final PreparedStatement update;
    private final PreparedStatement listStatement;

    @Inject
    public CassandraMessageIdDAO(Session session, BlobId.Factory blobIdFactory) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.blobIdFactory = blobIdFactory;
        this.delete = this.prepareDelete(session);
        this.insert = this.prepareInsert(session);
        this.update = this.prepareUpdate(session);
        this.select = this.prepareSelect(session);
        this.selectAll = this.prepareSelectAll(session);
        this.selectAllUids = this.prepareSelectAllUids(session);
        this.selectAllLimited = this.prepareSelectAllLimited(session);
        this.selectUidGte = this.prepareSelectUidGte(session);
        this.selectUidGteLimited = this.prepareSelectUidGteLimited(session);
        this.selectUidRange = this.prepareSelectUidRange(session);
        this.selectUidRangeLimited = this.prepareSelectUidRangeLimited(session);
        this.listStatement = this.prepareList(session);
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"messageIdTable").with(QueryBuilder.set((String)"threadId", (Object)QueryBuilder.bindMarker((String)"threadId"))).and(QueryBuilder.set((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))).and(QueryBuilder.set((String)"modSeq", (Object)QueryBuilder.bindMarker((String)"modSeq"))).and(QueryBuilder.set((String)"flagAnswered", (Object)QueryBuilder.bindMarker((String)"flagAnswered"))).and(QueryBuilder.set((String)"flagDeleted", (Object)QueryBuilder.bindMarker((String)"flagDeleted"))).and(QueryBuilder.set((String)"flagDraft", (Object)QueryBuilder.bindMarker((String)"flagDraft"))).and(QueryBuilder.set((String)"flagFlagged", (Object)QueryBuilder.bindMarker((String)"flagFlagged"))).and(QueryBuilder.set((String)"flagRecent", (Object)QueryBuilder.bindMarker((String)"flagRecent"))).and(QueryBuilder.set((String)"flagSeen", (Object)QueryBuilder.bindMarker((String)"flagSeen"))).and(QueryBuilder.set((String)"flagUser", (Object)QueryBuilder.bindMarker((String)"flagUser"))).and(QueryBuilder.addAll((String)"userFlags", (BindMarker)QueryBuilder.bindMarker((String)"userFlags"))).and(QueryBuilder.set((String)"internalDate", (Object)QueryBuilder.bindMarker((String)"internalDate"))).and(QueryBuilder.set((String)"bodyStartOctet", (Object)QueryBuilder.bindMarker((String)"bodyStartOctet"))).and(QueryBuilder.set((String)"fullContentOctets", (Object)QueryBuilder.bindMarker((String)"fullContentOctets"))).and(QueryBuilder.set((String)"headerContent", (Object)QueryBuilder.bindMarker((String)"headerContent"))).where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareUpdate(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"messageIdTable").with(QueryBuilder.set((String)"modSeq", (Object)QueryBuilder.bindMarker((String)"modSeq"))).and(QueryBuilder.set((String)"flagAnswered", (Object)QueryBuilder.bindMarker((String)"flagAnswered"))).and(QueryBuilder.set((String)"flagDeleted", (Object)QueryBuilder.bindMarker((String)"flagDeleted"))).and(QueryBuilder.set((String)"flagDraft", (Object)QueryBuilder.bindMarker((String)"flagDraft"))).and(QueryBuilder.set((String)"flagFlagged", (Object)QueryBuilder.bindMarker((String)"flagFlagged"))).and(QueryBuilder.set((String)"flagRecent", (Object)QueryBuilder.bindMarker((String)"flagRecent"))).and(QueryBuilder.set((String)"flagSeen", (Object)QueryBuilder.bindMarker((String)"flagSeen"))).and(QueryBuilder.set((String)"flagUser", (Object)QueryBuilder.bindMarker((String)"flagUser"))).and(QueryBuilder.addAll((String)"userFlags", (BindMarker)QueryBuilder.bindMarker((String)ADDED_USERS_FLAGS))).and(QueryBuilder.removeAll((String)"userFlags", (BindMarker)QueryBuilder.bindMarker((String)REMOVED_USERS_FLAGS))).where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareSelectAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareSelectAllUids(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"uid"}).from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareSelectAllLimited(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).limit(QueryBuilder.bindMarker((String)LIMIT)));
    }

    private PreparedStatement prepareList(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("messageIdTable"));
    }

    private PreparedStatement prepareSelectUidGte(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareSelectUidGteLimited(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))).limit(QueryBuilder.bindMarker((String)LIMIT)));
    }

    private PreparedStatement prepareSelectUidRange(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"uid", (Object)QueryBuilder.bindMarker((String)IMAP_UID_GTE))).and(QueryBuilder.lte((String)"uid", (Object)QueryBuilder.bindMarker((String)IMAP_UID_LTE))));
    }

    private PreparedStatement prepareSelectUidRangeLimited(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"uid", (Object)QueryBuilder.bindMarker((String)IMAP_UID_GTE))).and(QueryBuilder.lte((String)"uid", (Object)QueryBuilder.bindMarker((String)IMAP_UID_LTE))).limit(QueryBuilder.bindMarker((String)LIMIT)));
    }

    public Mono<Void> delete(CassandraId mailboxId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("uid", uid.asLong()));
    }

    public Mono<Void> insert(CassandraMessageMetadata metadata) {
        Preconditions.checkState((boolean)metadata.isComplete(), (Object)"Attempt to write incomplete metadata");
        ComposedMessageId composedMessageId = metadata.getComposedMessageId().getComposedMessageId();
        Flags flags = metadata.getComposedMessageId().getFlags();
        ThreadId threadId = metadata.getComposedMessageId().getThreadId();
        BoundStatement boundStatement = this.insert.bind();
        if (flags.getUserFlags().length == 0) {
            boundStatement.unset("userFlags");
        } else {
            boundStatement.setSet("userFlags", (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags()));
        }
        return this.cassandraAsyncExecutor.executeVoid((Statement)boundStatement.setUUID("mailboxId", ((CassandraId)composedMessageId.getMailboxId()).asUuid()).setLong("uid", composedMessageId.getUid().asLong()).setUUID("messageId", ((CassandraMessageId)composedMessageId.getMessageId()).get()).setUUID("threadId", ((CassandraMessageId)threadId.getBaseMessageId()).get()).setLong("modSeq", metadata.getComposedMessageId().getModSeq().asLong()).setBool("flagAnswered", flags.contains(Flags.Flag.ANSWERED)).setBool("flagDeleted", flags.contains(Flags.Flag.DELETED)).setBool("flagDraft", flags.contains(Flags.Flag.DRAFT)).setBool("flagFlagged", flags.contains(Flags.Flag.FLAGGED)).setBool("flagRecent", flags.contains(Flags.Flag.RECENT)).setBool("flagSeen", flags.contains(Flags.Flag.SEEN)).setBool("flagUser", flags.contains(Flags.Flag.USER)).setTimestamp("internalDate", metadata.getInternalDate().get()).setInt("bodyStartOctet", Math.toIntExact(metadata.getBodyStartOctet().get())).setLong("fullContentOctets", metadata.getSize().get().longValue()).setString("headerContent", metadata.getHeaderContent().get().asString()));
    }

    public Mono<Void> updateMetadata(ComposedMessageId composedMessageId, UpdatedFlags updatedFlags) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.updateBoundStatement(composedMessageId, updatedFlags));
    }

    private BoundStatement updateBoundStatement(ComposedMessageId id, UpdatedFlags updatedFlags) {
        BoundStatement boundStatement = this.update.bind().setLong("modSeq", updatedFlags.getModSeq().asLong()).setUUID("mailboxId", ((CassandraId)id.getMailboxId()).asUuid()).setLong("uid", id.getUid().asLong());
        if (updatedFlags.isChanged(Flags.Flag.ANSWERED)) {
            boundStatement.setBool("flagAnswered", updatedFlags.isModifiedToSet(Flags.Flag.ANSWERED));
        } else {
            boundStatement.unset("flagAnswered");
        }
        if (updatedFlags.isChanged(Flags.Flag.DRAFT)) {
            boundStatement.setBool("flagDraft", updatedFlags.isModifiedToSet(Flags.Flag.DRAFT));
        } else {
            boundStatement.unset("flagDraft");
        }
        if (updatedFlags.isChanged(Flags.Flag.FLAGGED)) {
            boundStatement.setBool("flagFlagged", updatedFlags.isModifiedToSet(Flags.Flag.FLAGGED));
        } else {
            boundStatement.unset("flagFlagged");
        }
        if (updatedFlags.isChanged(Flags.Flag.DELETED)) {
            boundStatement.setBool("flagDeleted", updatedFlags.isModifiedToSet(Flags.Flag.DELETED));
        } else {
            boundStatement.unset("flagDeleted");
        }
        if (updatedFlags.isChanged(Flags.Flag.RECENT)) {
            boundStatement.setBool("flagRecent", updatedFlags.getNewFlags().contains(Flags.Flag.RECENT));
        } else {
            boundStatement.unset("flagRecent");
        }
        if (updatedFlags.isChanged(Flags.Flag.SEEN)) {
            boundStatement.setBool("flagSeen", updatedFlags.isModifiedToSet(Flags.Flag.SEEN));
        } else {
            boundStatement.unset("flagSeen");
        }
        if (updatedFlags.isChanged(Flags.Flag.USER)) {
            boundStatement.setBool("flagUser", updatedFlags.isModifiedToSet(Flags.Flag.USER));
        } else {
            boundStatement.unset("flagUser");
        }
        Sets.SetView removedFlags = Sets.difference((Set)ImmutableSet.copyOf((Object[])updatedFlags.getOldFlags().getUserFlags()), (Set)ImmutableSet.copyOf((Object[])updatedFlags.getNewFlags().getUserFlags()));
        Sets.SetView addedFlags = Sets.difference((Set)ImmutableSet.copyOf((Object[])updatedFlags.getNewFlags().getUserFlags()), (Set)ImmutableSet.copyOf((Object[])updatedFlags.getOldFlags().getUserFlags()));
        if (addedFlags.isEmpty()) {
            boundStatement.unset(ADDED_USERS_FLAGS);
        } else {
            boundStatement.setSet(ADDED_USERS_FLAGS, (Set)addedFlags);
        }
        if (removedFlags.isEmpty()) {
            boundStatement.unset(REMOVED_USERS_FLAGS);
        } else {
            boundStatement.setSet(REMOVED_USERS_FLAGS, (Set)removedFlags);
        }
        return boundStatement;
    }

    public Mono<Optional<CassandraMessageMetadata>> retrieve(CassandraId mailboxId, MessageUid uid) {
        return this.asOptionalOfCassandraMessageId(this.selectOneRow(mailboxId, uid));
    }

    private Mono<Optional<CassandraMessageMetadata>> asOptionalOfCassandraMessageId(Mono<Row> row) {
        return row.map(this::fromRowToComposedMessageIdWithFlags).defaultIfEmpty(Optional.empty());
    }

    private Mono<Row> selectOneRow(CassandraId mailboxId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.select.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("uid", uid.asLong()));
    }

    public Flux<CassandraMessageMetadata> retrieveMessages(CassandraId mailboxId, MessageRange set, Limit limit) {
        return this.retrieveRows(mailboxId, set, limit).map(this::fromRowToComposedMessageIdWithFlags).handle(ReactorUtils.publishIfPresent());
    }

    public Flux<MessageUid> listUids(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectAllUids.bind().setUUID("mailboxId", mailboxId.asUuid())).map(row -> MessageUid.of((long)row.getLong("uid")));
    }

    public Flux<CassandraMessageMetadata> retrieveAllMessages() {
        return this.cassandraAsyncExecutor.executeRows(this.listStatement.bind().setReadTimeoutMillis(Duration.ofDays(1L).toMillisPart())).map(this::fromRowToComposedMessageIdWithFlags).handle(ReactorUtils.publishIfPresent());
    }

    private Flux<Row> retrieveRows(CassandraId mailboxId, MessageRange set, Limit limit) {
        switch (set.getType()) {
            case ALL: {
                return this.selectAll(mailboxId, limit);
            }
            case FROM: {
                return this.selectFrom(mailboxId, set.getUidFrom(), limit);
            }
            case RANGE: {
                return this.selectRange(mailboxId, set.getUidFrom(), set.getUidTo(), limit);
            }
            case ONE: {
                return Flux.concat((Publisher[])new Publisher[]{this.selectOneRow(mailboxId, set.getUidFrom())});
            }
        }
        throw new UnsupportedOperationException();
    }

    private Flux<Row> selectAll(CassandraId mailboxId, Limit limit) {
        return this.cassandraAsyncExecutor.executeRows((Statement)limit.getLimit().map(limitAsInt -> this.selectAllLimited.bind().setUUID("mailboxId", mailboxId.asUuid()).setInt(LIMIT, limitAsInt.intValue())).orElseGet(() -> this.selectAll.bind().setUUID("mailboxId", mailboxId.asUuid())));
    }

    private Flux<Row> selectFrom(CassandraId mailboxId, MessageUid uid, Limit limit) {
        return this.cassandraAsyncExecutor.executeRows((Statement)limit.getLimit().map(limitAsInt -> this.selectUidGteLimited.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("uid", uid.asLong()).setInt(LIMIT, limitAsInt.intValue())).orElseGet(() -> this.selectUidGte.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("uid", uid.asLong())));
    }

    private Flux<Row> selectRange(CassandraId mailboxId, MessageUid from, MessageUid to, Limit limit) {
        return this.cassandraAsyncExecutor.executeRows((Statement)limit.getLimit().map(limitAsInt -> this.selectUidRangeLimited.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong(IMAP_UID_GTE, from.asLong()).setLong(IMAP_UID_LTE, to.asLong()).setInt(LIMIT, limitAsInt.intValue())).orElseGet(() -> this.selectUidRange.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong(IMAP_UID_GTE, from.asLong()).setLong(IMAP_UID_LTE, to.asLong())));
    }

    private Optional<CassandraMessageMetadata> fromRowToComposedMessageIdWithFlags(Row row) {
        if (row.getUUID("messageId") == null) {
            this.delete(CassandraId.of(row.getUUID("mailboxId")), MessageUid.of((long)row.getLong("uid"))).subscribeOn(Schedulers.elastic()).subscribe();
            return Optional.empty();
        }
        CassandraMessageId messageId = CassandraMessageId.Factory.of(row.getUUID(CassandraMessageIds.MESSAGE_ID_LOWERCASE));
        return Optional.of(CassandraMessageMetadata.builder().ids(ComposedMessageIdWithMetaData.builder().composedMessageId(new ComposedMessageId((MailboxId)CassandraId.of(row.getUUID(CassandraMessageIds.MAILBOX_ID_LOWERCASE)), (MessageId)messageId, MessageUid.of((long)row.getLong("uid")))).flags(FlagsExtractor.getFlags(row)).modSeq(ModSeq.of((long)row.getLong(MessageIdToImapUid.MOD_SEQ_LOWERCASE))).threadId(this.getThreadIdFromRow(row, messageId)).build()).bodyStartOctet(row.getInt(CassandraMessageV3Table.BODY_START_OCTET_LOWERCASE)).internalDate(row.getTimestamp(CassandraMessageV3Table.INTERNAL_DATE_LOWERCASE)).size(row.getLong(CassandraMessageV3Table.FULL_CONTENT_OCTETS_LOWERCASE)).headerContent(Optional.ofNullable(row.getString(CassandraMessageV3Table.HEADER_CONTENT_LOWERCASE)).map(arg_0 -> ((BlobId.Factory)this.blobIdFactory).from(arg_0))).build());
    }

    private ThreadId getThreadIdFromRow(Row row, MessageId messageId) {
        UUID threadIdUUID = row.getUUID(MessageIdToImapUid.THREAD_ID_LOWERCASE);
        if (threadIdUUID == null) {
            return ThreadId.fromBaseMessageId((MessageId)messageId);
        }
        return ThreadId.fromBaseMessageId((MessageId)CassandraMessageId.Factory.of(threadIdUUID));
    }
}

