/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.transport.InitJCE;
import org.apache.james.transport.KeyHolder;
import org.apache.james.util.io.UnsynchronizedBufferedInputStream;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Store;

public class SMIMEKeyHolder
implements KeyHolder {
    private final JcaCertStore jcaCertStore;
    private final PrivateKey privateKey;
    private final X509Certificate certificate;
    private final CertStore certStore;

    public static String getDefaultType() {
        return KeyStore.getDefaultType();
    }

    public SMIMEKeyHolder(String keyStoreFileName, String keyStorePassword, String keyAlias, String keyAliasPassword, String keyStoreType) throws KeyStoreException, IOException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, CertificateException, UnrecoverableKeyException, NoSuchProviderException {
        try {
            InitJCE.init();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            NoSuchProviderException ex = new NoSuchProviderException("Error during cryptography provider initialization. Has bcprov-jdkxx-yyy.jar been copied in the lib directory or installed in the system?");
            ex.initCause(e);
            throw ex;
        }
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load((InputStream)new UnsynchronizedBufferedInputStream((InputStream)new FileInputStream(keyStoreFileName)), keyStorePassword.toCharArray());
        Enumeration<String> aliases = keyStore.aliases();
        if (keyAlias == null) {
            if (!aliases.hasMoreElements()) {
                throw new KeyStoreException("No alias was found in keystore.");
            }
            keyAlias = aliases.nextElement();
            if (aliases.hasMoreElements()) {
                throw new KeyStoreException("No <keyAlias> was given and more than one alias was found in keystore.");
            }
        }
        if (keyAliasPassword == null) {
            keyAliasPassword = keyStorePassword;
        }
        this.privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyAliasPassword.toCharArray());
        if (this.privateKey == null) {
            throw new KeyStoreException("The \"" + keyAlias + "\" PrivateKey alias was not found in keystore.");
        }
        this.certificate = (X509Certificate)keyStore.getCertificate(keyAlias);
        if (this.certificate == null) {
            throw new KeyStoreException("The \"" + keyAlias + "\" X509Certificate alias was not found in keystore.");
        }
        Certificate[] certificateChain = keyStore.getCertificateChain(keyAlias);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        if (certificateChain == null) {
            certList.add(this.certificate);
        } else {
            Collections.addAll(certList, certificateChain);
        }
        this.certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
        this.jcaCertStore = new JcaCertStore(certList);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public CertStore getCertStore() {
        return this.certStore;
    }

    public SMIMESignedGenerator createGenerator() throws CertStoreException, SMIMEException, OperatorCreationException, CertificateEncodingException {
        SMIMESignedGenerator generator = new SMIMESignedGenerator();
        SignerInfoGenerator signerInfoGenerator = new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").build("SHA1withRSA", this.privateKey, this.certificate);
        generator.addSignerInfoGenerator(signerInfoGenerator);
        generator.addCertificates((Store)this.jcaCertStore);
        return generator;
    }

    @Override
    public MimeMultipart generate(MimeMessage message) throws CertStoreException, NoSuchAlgorithmException, NoSuchProviderException, SMIMEException, OperatorCreationException, CertificateEncodingException {
        SMIMESignedGenerator generator = this.createGenerator();
        return generator.generate(message);
    }

    @Override
    public MimeMultipart generate(MimeBodyPart content) throws CertStoreException, NoSuchAlgorithmException, NoSuchProviderException, SMIMEException, OperatorCreationException, CertificateEncodingException {
        SMIMESignedGenerator generator = this.createGenerator();
        return generator.generate(content);
    }

    public static String getSignerDistinguishedName(X509Certificate certificate) {
        return certificate.getSubjectDN().toString();
    }

    public static String getSignerCN(X509Certificate certificate) {
        return SMIMEKeyHolder.extractAttribute(certificate.getSubjectDN().toString(), "CN=");
    }

    public static String getSignerAddress(X509Certificate certificate) {
        return SMIMEKeyHolder.extractAttribute(certificate.getSubjectDN().toString(), "EMAILADDRESS=");
    }

    @Override
    public String getSignerDistinguishedName() {
        return SMIMEKeyHolder.getSignerDistinguishedName(this.getCertificate());
    }

    @Override
    public String getSignerCN() {
        return SMIMEKeyHolder.getSignerCN(this.getCertificate());
    }

    @Override
    public String getSignerAddress() {
        return SMIMEKeyHolder.getSignerAddress(this.getCertificate());
    }

    private static String extractAttribute(String DistinguishedName, String attributeName) {
        int i = DistinguishedName.indexOf(attributeName);
        if (i < 0) {
            return null;
        }
        int j = DistinguishedName.indexOf(",", i += attributeName.length());
        if (j - 1 <= 0) {
            return null;
        }
        return DistinguishedName.substring(i, j).trim();
    }
}

