/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.parser;

import java.util.Arrays;

public class DKIMQuotedPrintable {
    public static String dkimQuotedPrintableDecode(CharSequence input) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder(input.length());
        int state = 0;
        int start = 0;
        int d = 0;
        boolean lastWasNL = false;
        block8: for (int i = 0; i < input.length(); ++i) {
            if (lastWasNL && input.charAt(i) != ' ' && input.charAt(i) != '\t') {
                throw new IllegalArgumentException("Unexpected LF not part of an FWS");
            }
            lastWasNL = false;
            switch (state) {
                case 0: {
                    switch (input.charAt(i)) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if ('\n' == input.charAt(i)) {
                                lastWasNL = true;
                            }
                            sb.append(input.subSequence(start, i));
                            start = i + 1;
                            break;
                        }
                        case '=': {
                            sb.append(input.subSequence(start, i));
                            state = 1;
                        }
                    }
                    continue block8;
                }
                case 1: 
                case 2: {
                    if (input.charAt(i) >= '0' && input.charAt(i) <= '9' || input.charAt(i) >= 'A' && input.charAt(i) <= 'F') {
                        int v = Arrays.binarySearch("0123456789ABCDEF".getBytes(), (byte)input.charAt(i));
                        if (state == 1) {
                            state = 2;
                            d = v;
                            continue block8;
                        }
                        d = d * 16 + v;
                        sb.append((char)d);
                        state = 0;
                        start = i + 1;
                        continue block8;
                    }
                    throw new IllegalArgumentException("Invalid input sequence at " + i);
                }
            }
        }
        if (state != 0) {
            throw new IllegalArgumentException("Invalid quoted printable termination");
        }
        sb.append(input.subSequence(start, input.length()));
        return sb.toString();
    }
}

