/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net.tcp;

import zmq.Options;
import zmq.io.IOThread;
import zmq.io.SessionBase;
import zmq.io.net.Address;
import zmq.io.net.NetProtocol;
import zmq.io.net.tcp.TcpConnecter;

public class SocksConnecter
extends TcpConnecter {
    private static final int SOCKS_NO_AUTH_REQUIRED = 0;
    private Address proxyAddress;
    Status status;
    String endpoint;

    public SocksConnecter(IOThread ioThread, SessionBase session, Options options2, Address addr, Address proxyAddr, boolean delayedStart) {
        super(ioThread, session, options2, addr, delayedStart);
        assert (NetProtocol.tcp.equals((Object)addr.protocol()));
        this.proxyAddress = proxyAddr;
        this.endpoint = this.proxyAddress.toString();
        this.status = Status.UNPLUGGED;
        throw new UnsupportedOperationException("Socks connecter is not implemented");
    }

    @Override
    protected void processPlug() {
        if (this.delayedStart) {
            this.startTimer();
        } else {
            this.initiateConnect();
        }
    }

    @Override
    protected void processTerm(int linger) {
        switch (this.status) {
            case UNPLUGGED: {
                break;
            }
            case WAITING_FOR_RECONNECT_TIME: {
                this.ioObject.cancelTimer(1);
                break;
            }
            case WAITING_FOR_PROXY_CONNECTION: 
            case SENDING_GREETING: 
            case WAITING_FOR_CHOICE: 
            case SENDING_REQUEST: 
            case WAITING_FOR_RESPONSE: {
                this.close();
                break;
            }
        }
        super.processTerm(linger);
    }

    @Override
    public void inEvent() {
        assert (this.status != Status.UNPLUGGED && this.status != Status.WAITING_FOR_RECONNECT_TIME);
        super.inEvent();
    }

    @Override
    public void outEvent() {
        super.outEvent();
    }

    @Override
    public void timerEvent(int id2) {
        super.timerEvent(id2);
    }

    void initiateConnect() {
    }

    int processServerResponse() {
        return -1;
    }

    void parseAddress(String address, String hostname, int port) {
    }

    void connectToProxy() {
    }

    void error() {
    }

    void startTimer() {
    }

    int getNewReconnectIvl() {
        return -1;
    }

    int open() {
        return -1;
    }

    void checkProxyConnection() {
    }

    private static enum Status {
        UNPLUGGED,
        WAITING_FOR_RECONNECT_TIME,
        WAITING_FOR_PROXY_CONNECTION,
        SENDING_GREETING,
        WAITING_FOR_CHOICE,
        SENDING_REQUEST,
        WAITING_FOR_RESPONSE;

    }
}

