/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.calcite.util.Static;

public class UrlFunctions {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    private UrlFunctions() {
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw Static.RESOURCE.charsetEncoding(value, UTF_8.name()).ex();
        }
        catch (RuntimeException e) {
            return value;
        }
    }

    public static String urlEncode(String url) {
        String value;
        try {
            value = URLEncoder.encode(url, UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw Static.RESOURCE.charsetEncoding(url, UTF_8.name()).ex();
        }
        return value;
    }
}

