/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;

public abstract class DocIdSet
implements Accountable {
    public static final DocIdSet EMPTY = new DocIdSet(){

        @Override
        public DocIdSetIterator iterator() {
            return DocIdSetIterator.empty();
        }

        @Override
        public Bits bits() {
            return null;
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }
    };

    public static DocIdSet all(final int maxDoc) {
        return new DocIdSet(){

            @Override
            public DocIdSetIterator iterator() throws IOException {
                return DocIdSetIterator.all(maxDoc);
            }

            @Override
            public Bits bits() throws IOException {
                return new Bits.MatchAllBits(maxDoc);
            }

            @Override
            public long ramBytesUsed() {
                return 4L;
            }
        };
    }

    public abstract DocIdSetIterator iterator() throws IOException;

    public Bits bits() throws IOException {
        return null;
    }
}

