/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.projected;

import java.util.List;
import mil.nga.crs.CRSType;
import mil.nga.crs.SimpleCoordinateReferenceSystem;
import mil.nga.crs.common.CoordinateSystem;
import mil.nga.crs.common.Dynamic;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.common.Unit;
import mil.nga.crs.geo.GeoCoordinateReferenceSystem;
import mil.nga.crs.geo.GeoDatum;
import mil.nga.crs.geo.GeoDatumEnsemble;
import mil.nga.crs.geo.GeoReferenceFrame;
import mil.nga.crs.projected.MapProjection;

public class ProjectedCoordinateReferenceSystem
extends SimpleCoordinateReferenceSystem {
    private GeoCoordinateReferenceSystem base = new GeoCoordinateReferenceSystem();
    private MapProjection mapProjection = null;

    public ProjectedCoordinateReferenceSystem() {
        super(CRSType.PROJECTED);
    }

    public ProjectedCoordinateReferenceSystem(String name, String baseName, CRSType baseType, GeoReferenceFrame referenceFrame, MapProjection mapProjection, CoordinateSystem coordinateSystem) {
        super(name, CRSType.PROJECTED, coordinateSystem);
        this.setBaseName(baseName);
        this.setBaseType(baseType);
        this.setReferenceFrame(referenceFrame);
        this.setMapProjection(mapProjection);
    }

    public ProjectedCoordinateReferenceSystem(String name, String baseName, CRSType baseType, GeoDatumEnsemble datumEnsemble, MapProjection mapProjection, CoordinateSystem coordinateSystem) {
        super(name, CRSType.PROJECTED, coordinateSystem);
        this.setBaseName(baseName);
        this.setBaseType(baseType);
        this.setDatumEnsemble(datumEnsemble);
        this.setMapProjection(mapProjection);
    }

    public ProjectedCoordinateReferenceSystem(String name, String baseName, CRSType baseType, Dynamic dynamic, GeoReferenceFrame referenceFrame, MapProjection mapProjection, CoordinateSystem coordinateSystem) {
        super(name, CRSType.PROJECTED, coordinateSystem);
        this.setBaseName(baseName);
        this.setBaseType(baseType);
        this.setDynamic(dynamic);
        this.setReferenceFrame(referenceFrame);
        this.setMapProjection(mapProjection);
    }

    public GeoCoordinateReferenceSystem getBase() {
        return this.base;
    }

    public void setBase(GeoCoordinateReferenceSystem base) {
        this.base = base;
    }

    public String getBaseName() {
        return this.getBase().getName();
    }

    public void setBaseName(String baseName) {
        this.getBase().setName(baseName);
    }

    public CRSType getBaseType() {
        return this.getBase().getType();
    }

    public void setBaseType(CRSType baseType) {
        this.getBase().setType(baseType);
    }

    public GeoReferenceFrame getReferenceFrame() {
        return this.getBase().getReferenceFrame();
    }

    public boolean hasReferenceFrame() {
        return this.getBase().hasReferenceFrame();
    }

    public void setReferenceFrame(GeoReferenceFrame referenceFrame) {
        this.getBase().setReferenceFrame(referenceFrame);
    }

    public GeoDatumEnsemble getDatumEnsemble() {
        return this.getBase().getDatumEnsemble();
    }

    public boolean hasDatumEnsemble() {
        return this.getBase().hasDatumEnsemble();
    }

    public void setDatumEnsemble(GeoDatumEnsemble datumEnsemble) {
        this.getBase().setDatumEnsemble(datumEnsemble);
    }

    public Dynamic getDynamic() {
        return this.getBase().getDynamic();
    }

    public boolean hasDynamic() {
        return this.getBase().hasDynamic();
    }

    public void setDynamic(Dynamic dynamic) {
        this.getBase().setDynamic(dynamic);
    }

    public GeoDatum getGeoDatum() {
        return this.getBase().getGeoDatum();
    }

    public List<Identifier> getBaseIdentifiers() {
        return this.getBase().getIdentifiers();
    }

    public boolean hasBaseIdentifiers() {
        return this.getBase().hasIdentifiers();
    }

    public int numBaseIdentifiers() {
        return this.getBase().numIdentifiers();
    }

    public Identifier getBaseIdentifier(int index) {
        return this.getBase().getIdentifier(index);
    }

    public void setBaseIdentifiers(List<Identifier> baseIdentifiers) {
        this.getBase().setIdentifiers(baseIdentifiers);
    }

    public void addBaseIdentifier(Identifier baseIdentifier) {
        this.getBase().addIdentifier(baseIdentifier);
    }

    public void addBaseIdentifiers(List<Identifier> baseIdentifiers) {
        this.getBase().addIdentifiers(baseIdentifiers);
    }

    public Unit getUnit() {
        Unit unit = null;
        CoordinateSystem cs = this.getBase().getCoordinateSystem();
        if (cs != null) {
            unit = cs.getUnit();
        }
        return unit;
    }

    public boolean hasUnit() {
        CoordinateSystem cs = this.getBase().getCoordinateSystem();
        return cs != null && cs.hasUnit();
    }

    public void setUnit(Unit unit) {
        CoordinateSystem cs = this.getBase().getCoordinateSystem();
        if (cs == null) {
            cs = new CoordinateSystem();
            this.getBase().setCoordinateSystem(cs);
        }
        cs.setUnit(unit);
    }

    public MapProjection getMapProjection() {
        return this.mapProjection;
    }

    public void setMapProjection(MapProjection mapProjection) {
        this.mapProjection = mapProjection;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + (this.mapProjection == null ? 0 : this.mapProjection.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectedCoordinateReferenceSystem other = (ProjectedCoordinateReferenceSystem)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        return !(this.mapProjection == null ? other.mapProjection != null : !this.mapProjection.equals(other.mapProjection));
    }
}

