/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.geo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mil.nga.crs.CRSException;

public enum Ellipsoids {
    INTERNATIONAL("intl", 6378388.0, 0.0, 297.0, "International 1909 (Hayford)", "International 1924 (Hayford)"),
    BESSEL("bessel", 6377397.155, 0.0, 299.1528128, "Bessel 1841"),
    CLARKE_1866("clrk66", 6378206.4, 6356583.8, 0.0, "Clarke 1866"),
    CLARKE_1880("clrk80", 6378249.145, 0.0, 293.4663, "Clarke 1880 mod.", "Clarke 1880 (RGS)"),
    AIRY("airy", 6377563.396, 6356256.91, 0.0, "Airy 1830"),
    WGS60("WGS60", 6378165.0, 0.0, 298.3, "WGS 60"),
    WGS66("WGS66", 6378145.0, 0.0, 298.25, "WGS 66", "NWL 9D"),
    WGS72("WGS72", 6378135.0, 0.0, 298.26, "WGS 72"),
    WGS84("WGS84", 6378137.0, 0.0, 298.257223563, "WGS 84"),
    KRASSOVSKY("krass", 6378245.0, 0.0, 298.3, "Krassovsky, 1942", "Krassovsky 1942", "Krassowsky 1940"),
    EVEREST("evrst30", 6377276.345, 0.0, 300.8017, "Everest 1830"),
    INTERNATIONAL_1967("new_intl", 6378157.5, 6356772.2, 0.0, "New International 1967"),
    GRS80("GRS80", 6378137.0, 0.0, 298.257222101, "GRS 1980 (IUGG, 1980)"),
    AUSTRALIAN("australian", 6378160.0, 6356774.7, 298.25, "Australian"),
    MERIT("MERIT", 6378137.0, 0.0, 298.257, "MERIT 1983"),
    SGS85("SGS85", 6378136.0, 0.0, 298.257, "Soviet Geodetic System 85"),
    IAU76("IAU76", 6378140.0, 0.0, 298.257, "IAU 1976"),
    APL4_9("APL4.9", 6378137.0, 0.0, 298.25, "Appl. Physics. 1965"),
    NWL9D("NWL9D", 6378145.0, 0.0, 298.25, "Naval Weapons Lab., 1965"),
    MOD_AIRY("mod_airy", 6377340.189, 6356034.446, 0.0, "Modified Airy", "Airy Modified 1849"),
    ANDRAE("andrae", 6377104.43, 0.0, 300.0, "Andrae 1876 (Den., Iclnd.)"),
    AUST_SA("aust_SA", 6378160.0, 0.0, 298.25, "Australian Natl & S. Amer. 1969", "GRS 1967 Modified"),
    GRS67("GRS67", 6378160.0, 0.0, 298.247167427, "GRS 67 (IUGG 1967)", "GRS 1967"),
    BESS_NAM("bess_nam", 6377483.865, 0.0, 299.1528128, "Bessel 1841 (Namibia)", "Bessel Namibia (GLM)"),
    CPM("CPM", 6375738.7, 0.0, 334.29, "Comm. des Poids et Mesures 1799"),
    DELMBR("delmbr", 6376428.0, 0.0, 311.5, "Delambre 1810 (Belgium)"),
    ENGELIS("engelis", 6378136.05, 0.0, 298.2566, "Engelis 1985"),
    EVRST48("evrst48", 6377304.063, 0.0, 300.8017, "Everest 1948"),
    EVRST56("evrst56", 6377301.243, 0.0, 300.8017, "Everest 1956"),
    EVRTS69("evrst69", 6377295.664, 0.0, 300.8017, "Everest 1969"),
    EVRTSTSS("evrstSS", 6377298.556, 0.0, 300.8017, "Everest (Sabah & Sarawak)", "Everest 1830 (1967 Definition)"),
    FRSCH60("fschr60", 6378166.0, 0.0, 298.3, "Fischer (Mercury Datum) 1960"),
    FSRCH60M("fschr60m", 6378155.0, 0.0, 298.3, "Modified Fischer 1960"),
    FSCHR68("fschr68", 6378150.0, 0.0, 298.3, "Fischer 1968"),
    HELMERT("helmert", 6378200.0, 0.0, 298.3, "Helmert 1906"),
    HOUGH("hough", 6378270.0, 0.0, 297.0, "Hough"),
    KAULA("kaula", 6378163.0, 0.0, 298.24, "Kaula 1961"),
    LERCH("lerch", 6378139.0, 0.0, 298.257, "Lerch 1979"),
    MPRTS("mprts", 6397300.0, 0.0, 191.0, "Maupertius 1738"),
    PLESSIS("plessis", 6376523.0, 6355863.0, 0.0, "Plessis 1817 (France)"),
    SEASIA("SEasia", 6378155.0, 6356773.3205, 0.0, "Southeast Asia"),
    WALBECK("walbeck", 6376896.0, 6355834.8467, 0.0, "Walbeck"),
    NAD27("NAD27", 6378249.145, 0.0, 293.4663, "NAD27: Clarke 1880 mod."),
    NAD83("NAD83", 6378137.0, 0.0, 298.257222101, "NAD83: GRS 1980 (IUGG, 1980)"),
    SPHERE("sphere", 6371008.7714, 6371008.7714, 0.0, "Sphere");

    private static final Map<String, Ellipsoids> nameTypes;
    private final List<String> names = new ArrayList<String>();
    private final String shortName;
    private final double equatorRadius;
    private final double poleRadius;
    private final double reciprocalFlattening;
    private final double eccentricity;
    private final double eccentricity2;

    private Ellipsoids(String shortName, double equatorRadius, double poleRadius, double reciprocalFlattening, String ... names) {
        this.shortName = shortName;
        this.equatorRadius = equatorRadius;
        this.reciprocalFlattening = reciprocalFlattening;
        for (String name : names) {
            int index = name.indexOf("(");
            if (index > -1) {
                this.names.add(name.substring(0, index).trim());
            }
            this.names.add(name);
        }
        if (poleRadius == 0.0 && reciprocalFlattening == 0.0) {
            throw new CRSException("One of poleRadius or reciprocalFlattening must be specified");
        }
        if (reciprocalFlattening != 0.0) {
            double flattening;
            double f = flattening = 1.0 / reciprocalFlattening;
            this.eccentricity2 = 2.0 * f - f * f;
            poleRadius = equatorRadius * Math.sqrt(1.0 - this.eccentricity2);
        } else {
            this.eccentricity2 = 1.0 - poleRadius * poleRadius / (equatorRadius * equatorRadius);
        }
        this.poleRadius = poleRadius;
        this.eccentricity = Math.sqrt(this.eccentricity2);
    }

    public String getName() {
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getShortName() {
        return this.shortName;
    }

    public double getEquatorRadius() {
        return this.equatorRadius;
    }

    public double getReciprocalFlattening() {
        return this.reciprocalFlattening;
    }

    public double getA() {
        return this.equatorRadius;
    }

    public double getPoleRadius() {
        return this.poleRadius;
    }

    public double getB() {
        return this.poleRadius;
    }

    public double getEccentricity() {
        return this.eccentricity;
    }

    public double getEccentricitySquared() {
        return this.eccentricity2;
    }

    public static Ellipsoids fromName(String name) {
        return nameTypes.get(name.toLowerCase());
    }

    static {
        nameTypes = new HashMap<String, Ellipsoids>();
        for (Ellipsoids type : Ellipsoids.values()) {
            nameTypes.put(type.getShortName().toLowerCase(), type);
            for (String name : type.getNames()) {
                String lowercaseName = name.toLowerCase();
                if (nameTypes.containsKey(lowercaseName)) continue;
                nameTypes.put(lowercaseName, type);
            }
        }
    }
}

