/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.flatgeobuf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.baremaps.flatgeobuf.FlatGeoBuf;
import org.apache.baremaps.flatgeobuf.GeometryConversions;
import org.apache.baremaps.flatgeobuf.PackedRTree;
import org.apache.baremaps.flatgeobuf.generated.Column;
import org.apache.baremaps.flatgeobuf.generated.Feature;
import org.apache.baremaps.flatgeobuf.generated.Header;
import org.locationtech.jts.geom.Geometry;

public class FlatGeoBufReader
implements AutoCloseable {
    private final ByteBuffer featureBuffer = ByteBuffer.allocate(65536).order(ByteOrder.LITTLE_ENDIAN);
    private final ReadableByteChannel channel;
    private Header header;

    public FlatGeoBufReader(ReadableByteChannel channel) {
        this.channel = channel;
    }

    public Header readHeaderBuffer() throws IOException {
        this.header = FlatGeoBufReader.readHeaderBuffer(this.channel);
        return this.header;
    }

    public FlatGeoBuf.Header readHeader() throws IOException {
        return FlatGeoBufReader.asFlatGeoBuf(this.readHeaderBuffer());
    }

    public Feature readFeatureBuffer() throws IOException {
        return FlatGeoBufReader.readFeatureBuffer(this.channel, this.featureBuffer);
    }

    public FlatGeoBuf.Feature readFeature() throws IOException {
        return FlatGeoBufReader.readFeature(this.channel, this.header, this.featureBuffer);
    }

    public void skipIndex() throws IOException {
        FlatGeoBufReader.skipIndex(this.channel, this.header);
    }

    public ByteBuffer readIndexBuffer() throws IOException {
        return FlatGeoBufReader.readIndexBuffer(this.channel, this.header);
    }

    public InputStream readIndexStream() {
        return FlatGeoBufReader.readIndexStream(this.channel, this.header);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public static Header readHeaderBuffer(ReadableByteChannel channel) throws IOException {
        ByteBuffer prefixBuffer = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        while (prefixBuffer.hasRemaining() && channel.read(prefixBuffer) != -1) {
        }
        prefixBuffer.flip();
        if (!FlatGeoBuf.isFlatGeoBuf(prefixBuffer)) {
            throw new IOException("This is not a flatgeobuf!");
        }
        int headerSize = prefixBuffer.getInt();
        ByteBuffer headerBuffer = ByteBuffer.allocate(headerSize).order(ByteOrder.LITTLE_ENDIAN);
        while (headerBuffer.hasRemaining() && channel.read(headerBuffer) != -1) {
        }
        headerBuffer.flip();
        return Header.getRootAsHeader(headerBuffer);
    }

    public static FlatGeoBuf.Header readHeader(ReadableByteChannel channel) throws IOException {
        Header header = FlatGeoBufReader.readHeaderBuffer(channel);
        return FlatGeoBufReader.asFlatGeoBuf(header);
    }

    public static FlatGeoBuf.Header asFlatGeoBuf(Header header) {
        return new FlatGeoBuf.Header(header.name(), List.of(Double.valueOf(header.envelope(0)), Double.valueOf(header.envelope(1)), Double.valueOf(header.envelope(2)), Double.valueOf(header.envelope(3))), FlatGeoBuf.GeometryType.values()[header.geometryType()], header.hasZ(), header.hasM(), header.hasT(), header.hasTm(), IntStream.range(0, header.columnsLength()).mapToObj(header::columns).map(column -> new FlatGeoBuf.Column(column.name(), FlatGeoBuf.ColumnType.values()[column.type()], column.title(), column.description(), column.width(), column.precision(), column.scale(), column.nullable(), column.unique(), column.primaryKey(), column.metadata())).toList(), header.featuresCount(), header.indexNodeSize(), new FlatGeoBuf.Crs(header.crs().org(), header.crs().code(), header.crs().name(), header.crs().description(), header.crs().wkt(), header.crs().codeString()), header.title(), header.description(), header.metadata());
    }

    public static Feature readFeatureBuffer(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        try {
            if (buffer.position() > 0) {
                buffer.compact();
            }
            while (buffer.hasRemaining() && channel.read(buffer) != -1) {
            }
            buffer.flip();
            int featureSize = buffer.getInt();
            if (featureSize > buffer.remaining()) {
                ByteBuffer newBuffer = ByteBuffer.allocate(featureSize).order(ByteOrder.LITTLE_ENDIAN);
                newBuffer.put(buffer);
                while (newBuffer.hasRemaining() && channel.read(newBuffer) != -1) {
                }
                newBuffer.flip();
                Feature feature = Feature.getRootAsFeature(newBuffer.duplicate());
                buffer.clear();
                return feature;
            }
            Feature feature = Feature.getRootAsFeature(buffer.slice(buffer.position(), featureSize));
            buffer.position(buffer.position() + featureSize);
            return feature;
        }
        catch (BufferUnderflowException e) {
            throw new IOException("Failed to read feature", e);
        }
    }

    public static FlatGeoBuf.Feature readFeature(ReadableByteChannel channel, Header header, ByteBuffer buffer) throws IOException {
        Feature feature = FlatGeoBufReader.readFeatureBuffer(channel, buffer);
        return FlatGeoBufReader.asFlatGeoBuf(header, feature);
    }

    public static FlatGeoBuf.Feature asFlatGeoBuf(Header header, Feature feature) {
        ArrayList<Object> properties = new ArrayList<Object>();
        if (feature.propertiesLength() > 0) {
            ByteBuffer propertiesBuffer = feature.propertiesAsByteBuffer();
            while (propertiesBuffer.hasRemaining()) {
                short columnPosition = propertiesBuffer.getShort();
                Column columnType = header.columns(columnPosition);
                Object columnValue = FlatGeoBufReader.readValue(propertiesBuffer, columnType);
                properties.add(columnValue);
            }
        }
        Geometry geometry = GeometryConversions.readGeometry(feature.geometry(), header.geometryType());
        return new FlatGeoBuf.Feature(properties, geometry);
    }

    private static Object readValue(ByteBuffer buffer, Column column) {
        return switch (FlatGeoBuf.ColumnType.values()[column.type()]) {
            default -> throw new IncompatibleClassChangeError();
            case FlatGeoBuf.ColumnType.BYTE -> buffer.get();
            case FlatGeoBuf.ColumnType.UBYTE -> buffer.get();
            case FlatGeoBuf.ColumnType.BOOL -> buffer.get() == 1;
            case FlatGeoBuf.ColumnType.SHORT -> buffer.getShort();
            case FlatGeoBuf.ColumnType.USHORT -> buffer.getShort();
            case FlatGeoBuf.ColumnType.INT -> buffer.getInt();
            case FlatGeoBuf.ColumnType.UINT -> buffer.getInt();
            case FlatGeoBuf.ColumnType.LONG -> buffer.getLong();
            case FlatGeoBuf.ColumnType.ULONG -> buffer.getLong();
            case FlatGeoBuf.ColumnType.FLOAT -> Float.valueOf(buffer.getFloat());
            case FlatGeoBuf.ColumnType.DOUBLE -> buffer.getDouble();
            case FlatGeoBuf.ColumnType.STRING -> FlatGeoBufReader.readString(buffer);
            case FlatGeoBuf.ColumnType.JSON -> FlatGeoBufReader.readJson(buffer);
            case FlatGeoBuf.ColumnType.DATETIME -> FlatGeoBufReader.readDateTime(buffer);
            case FlatGeoBuf.ColumnType.BINARY -> FlatGeoBufReader.readBinary(buffer);
        };
    }

    private static Object readString(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static Object readJson(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    private static Object readDateTime(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    private static Object readBinary(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public static void skipIndex(ReadableByteChannel channel, Header header) throws IOException {
        int bytesRead;
        long n = PackedRTree.calcSize(header.featuresCount(), header.indexNodeSize());
        int bufferSize = 1024;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        for (long remaining = n; remaining > 0L; remaining -= (long)bytesRead) {
            int bytesToRead = (int)Math.min((long)bufferSize, remaining);
            buffer.limit(bytesToRead);
            bytesRead = channel.read(buffer);
            if (bytesRead == -1) {
                throw new IOException("End of stream reached before skipping the required number of bytes");
            }
            buffer.clear();
        }
    }

    public static ByteBuffer readIndexBuffer(ReadableByteChannel channel, Header header) throws IOException {
        long indexSize = PackedRTree.calcSize(header.featuresCount(), header.indexNodeSize());
        if (indexSize > 0x80000000L) {
            throw new IOException("Index size is greater than 2GB!");
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)indexSize).order(ByteOrder.LITTLE_ENDIAN);
        while (buffer.hasRemaining() && channel.read(buffer) != -1) {
        }
        buffer.flip();
        return buffer;
    }

    public static InputStream readIndexStream(ReadableByteChannel channel, Header header) {
        long indexSize = PackedRTree.calcSize(header.featuresCount(), header.indexNodeSize());
        return new BoundedInputStream(Channels.newInputStream(channel), indexSize);
    }

    private static class BoundedInputStream
    extends InputStream {
        private final InputStream in;
        private long remaining;

        private BoundedInputStream(InputStream in, long size) {
            this.in = in;
            this.remaining = size;
        }

        @Override
        public int read() throws IOException {
            if (this.remaining == 0L) {
                return -1;
            }
            int result = this.in.read();
            if (result != -1) {
                --this.remaining;
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.remaining == 0L) {
                return -1;
            }
            int toRead = (int)Math.min((long)len, this.remaining);
            int result = this.in.read(b, off, toRead);
            if (result != -1) {
                this.remaining -= (long)result;
            }
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            long toSkip = Math.min(n, this.remaining);
            long skipped = this.in.skip(toSkip);
            this.remaining -= skipped;
            return skipped;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min((long)this.in.available(), this.remaining);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }
}

