/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.nga.index;

import com.j256.ormlite.misc.TransactionManager;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.nga.index.FeatureTableCoreIndex;
import mil.nga.geopackage.extension.nga.index.GeometryIndex;
import mil.nga.geopackage.extension.nga.index.TableIndex;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.FeatureRowSync;
import mil.nga.proj.Projection;
import mil.nga.sf.GeometryEnvelope;

public class FeatureTableIndex
extends FeatureTableCoreIndex {
    private static final Logger log = Logger.getLogger(FeatureTableIndex.class.getName());
    private final FeatureDao featureDao;
    private final FeatureRowSync featureRowSync = new FeatureRowSync();

    public FeatureTableIndex(GeoPackage geoPackage, FeatureDao featureDao) {
        this(geoPackage, featureDao, false);
    }

    public FeatureTableIndex(GeoPackage geoPackage, FeatureDao featureDao, boolean geodesic) {
        super((GeoPackageCore)geoPackage, featureDao.getTableName(), featureDao.getGeometryColumnName(), geodesic);
        this.featureDao = featureDao;
    }

    public Projection getProjection() {
        return this.featureDao.getProjection();
    }

    public String getPkColumnName() {
        return this.featureDao.getPkColumnName();
    }

    public void close() {
    }

    public boolean index(FeatureRow row) {
        TableIndex tableIndex = this.getTableIndex();
        if (tableIndex == null) {
            throw new GeoPackageException("GeoPackage table is not indexed. GeoPackage: " + this.getGeoPackage().getName() + ", Table: " + this.getTableName());
        }
        boolean indexed = this.index(tableIndex, row.getId(), row.getGeometry());
        this.updateLastIndexed();
        return indexed;
    }

    protected int indexTable(final TableIndex tableIndex) {
        int count = 0;
        long offset = 0L;
        int chunkCount = 0;
        final String[] columns = this.featureDao.getIdAndGeometryColumnNames();
        while (chunkCount >= 0) {
            final long chunkOffset = offset;
            try {
                ConnectionSource connectionSource = this.getGeoPackage().getDatabase().getConnectionSource();
                chunkCount = (Integer)TransactionManager.callInTransaction((ConnectionSource)connectionSource, (Callable)new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        FeatureResultSet resultSet = (FeatureResultSet)FeatureTableIndex.this.featureDao.queryForChunk(columns, FeatureTableIndex.this.chunkLimit, chunkOffset);
                        int count = FeatureTableIndex.this.indexRows(tableIndex, resultSet);
                        return count;
                    }
                });
                if (chunkCount > 0) {
                    count += chunkCount;
                }
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to Index Table. GeoPackage: " + this.getGeoPackage().getName() + ", Table: " + this.getTableName(), (Throwable)e);
            }
            offset += (long)this.chunkLimit;
        }
        if (this.progress == null || this.progress.isActive()) {
            this.updateLastIndexed();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int indexRows(TableIndex tableIndex, FeatureResultSet resultSet) {
        int count = -1;
        try {
            while ((this.progress == null || this.progress.isActive()) && resultSet.moveToNext()) {
                if (count < 0) {
                    ++count;
                }
                try {
                    FeatureRow row = (FeatureRow)resultSet.getRow();
                    boolean indexed = this.index(tableIndex, row.getId(), row.getGeometry());
                    if (indexed) {
                        ++count;
                    }
                    if (this.progress == null) continue;
                    this.progress.addProgress(1);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to index feature. Table: " + tableIndex.getTableName() + ", Position: " + resultSet.getPosition(), e);
                }
            }
            return count;
        }
        finally {
            resultSet.close();
        }
    }

    public int deleteIndex(FeatureRow row) {
        return this.deleteIndex(row.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureRow getFeatureRow(GeometryIndex geometryIndex) {
        long geomId = geometryIndex.getGeomId();
        FeatureRow row = (FeatureRow)this.featureRowSync.getRowOrLock(geomId);
        if (row == null) {
            try {
                row = (FeatureRow)this.featureDao.queryForIdRow(geomId);
            }
            finally {
                this.featureRowSync.setRow(geomId, row);
            }
        }
        return row;
    }

    public FeatureResultSet queryFeatures() {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(boolean distinct) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(String[] columns) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL());
    }

    public int countFeatures() {
        return this.featureDao.countIn(this.queryIdsSQL());
    }

    public int countColumnFeatures(String column) {
        return this.featureDao.countIn(column, this.queryIdsSQL());
    }

    public int countFeatures(boolean distinct, String column) {
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL(), fieldValues);
    }

    public int countFeatures(Map<String, Object> fieldValues) {
        return this.featureDao.countIn(this.queryIdsSQL(), fieldValues);
    }

    public int countFeatures(String column, Map<String, Object> fieldValues) {
        return this.featureDao.countIn(column, this.queryIdsSQL(), fieldValues);
    }

    public int countFeatures(boolean distinct, String column, Map<String, Object> fieldValues) {
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String where) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(), where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String where) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL(), where);
    }

    public FeatureResultSet queryFeatures(String[] columns, String where) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(), where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, String where) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL(), where);
    }

    public int countFeatures(String where) {
        return this.featureDao.countIn(this.queryIdsSQL(), where);
    }

    public int countFeatures(String column, String where) {
        return this.featureDao.countIn(column, this.queryIdsSQL(), where);
    }

    public int countFeatures(boolean distinct, String column, String where) {
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL(), where);
    }

    public FeatureResultSet queryFeatures(String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL(), where, whereArgs);
    }

    public int countFeatures(String where, String[] whereArgs) {
        return this.featureDao.countIn(this.queryIdsSQL(), where, whereArgs);
    }

    public int countFeatures(String column, String where, String[] whereArgs) {
        return this.featureDao.countIn(column, this.queryIdsSQL(), where, whereArgs);
    }

    public int countFeatures(boolean distinct, String column, String where, String[] whereArgs) {
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox) {
        return this.queryFeatures(false, boundingBox);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox) {
        return this.queryFeatures(distinct, boundingBox.buildEnvelope());
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox) {
        return this.queryFeatures(false, columns, boundingBox);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox) {
        return this.queryFeatures(distinct, columns, boundingBox.buildEnvelope());
    }

    public int countFeatures(BoundingBox boundingBox) {
        return this.countFeatures(false, null, boundingBox);
    }

    public int countFeatures(String column, BoundingBox boundingBox) {
        return this.countFeatures(false, column, boundingBox);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox) {
        return this.countFeatures(distinct, column, boundingBox.buildEnvelope());
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, boundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(distinct, boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, columns, boundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(distinct, columns, boundingBox.buildEnvelope(), fieldValues);
    }

    public int countFeatures(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.countFeatures(false, null, boundingBox, fieldValues);
    }

    public int countFeatures(String column, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.countFeatures(false, column, boundingBox, fieldValues);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.countFeatures(distinct, column, boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, String where) {
        return this.queryFeatures(false, boundingBox, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, String where) {
        return this.queryFeatures(distinct, boundingBox, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, String where) {
        return this.queryFeatures(false, columns, boundingBox, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, String where) {
        return this.queryFeatures(distinct, columns, boundingBox, where, null);
    }

    public int countFeatures(BoundingBox boundingBox, String where) {
        return this.countFeatures(false, null, boundingBox, where);
    }

    public int countFeatures(String column, BoundingBox boundingBox, String where) {
        return this.countFeatures(false, column, boundingBox, where);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, String where) {
        return this.countFeatures(distinct, column, boundingBox, where, null);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(false, boundingBox, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(distinct, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(false, columns, boundingBox, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(distinct, columns, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public int countFeatures(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.countFeatures(false, null, boundingBox, where, whereArgs);
    }

    public int countFeatures(String column, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.countFeatures(false, column, boundingBox, where, whereArgs);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.countFeatures(distinct, column, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection) {
        return this.queryFeatures(false, boundingBox, projection);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, featureBoundingBox);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection) {
        return this.queryFeatures(false, columns, boundingBox, projection);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, columns, featureBoundingBox);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection) {
        return this.countFeatures(false, null, boundingBox, projection);
    }

    public int countFeatures(String column, BoundingBox boundingBox, Projection projection) {
        return this.countFeatures(false, column, boundingBox, projection);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.countFeatures(distinct, column, featureBoundingBox);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, boundingBox, projection, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, featureBoundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, columns, boundingBox, projection, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, columns, featureBoundingBox, fieldValues);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.countFeatures(false, null, boundingBox, projection, fieldValues);
    }

    public int countFeatures(String column, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.countFeatures(false, column, boundingBox, projection, fieldValues);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.countFeatures(distinct, column, featureBoundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(false, boundingBox, projection, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(distinct, boundingBox, projection, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(false, columns, boundingBox, projection, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(distinct, columns, boundingBox, projection, where, null);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, String where) {
        return this.countFeatures(false, null, boundingBox, projection, where);
    }

    public int countFeatures(String column, BoundingBox boundingBox, Projection projection, String where) {
        return this.countFeatures(false, column, boundingBox, projection, where);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, Projection projection, String where) {
        return this.countFeatures(distinct, column, boundingBox, projection, where, null);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.queryFeatures(false, boundingBox, projection, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, featureBoundingBox, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.queryFeatures(false, columns, boundingBox, projection, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, columns, featureBoundingBox, where, whereArgs);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.countFeatures(false, null, boundingBox, projection, where, whereArgs);
    }

    public int countFeatures(String column, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.countFeatures(false, column, boundingBox, projection, where, whereArgs);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.countFeatures(distinct, column, featureBoundingBox, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(envelope));
    }

    public FeatureResultSet queryFeatures(boolean distinct, GeometryEnvelope envelope) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL(envelope));
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(envelope));
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, GeometryEnvelope envelope) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL(envelope));
    }

    public int countFeatures(GeometryEnvelope envelope) {
        return this.featureDao.countIn(this.queryIdsSQL(envelope));
    }

    public int countFeatures(String column, GeometryEnvelope envelope) {
        return this.featureDao.countIn(column, this.queryIdsSQL(envelope));
    }

    public int countFeatures(boolean distinct, String column, GeometryEnvelope envelope) {
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL(envelope));
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(envelope), fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL(envelope), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(envelope), fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL(envelope), fieldValues);
    }

    public int countFeatures(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.featureDao.countIn(this.queryIdsSQL(envelope), fieldValues);
    }

    public int countFeatures(String column, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.featureDao.countIn(column, this.queryIdsSQL(envelope), fieldValues);
    }

    public int countFeatures(boolean distinct, String column, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL(envelope), fieldValues);
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, String where) {
        return this.queryFeatures(false, envelope, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, GeometryEnvelope envelope, String where) {
        return this.queryFeatures(distinct, envelope, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, String where) {
        return this.queryFeatures(false, columns, envelope, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, GeometryEnvelope envelope, String where) {
        return this.queryFeatures(distinct, columns, envelope, where, null);
    }

    public int countFeatures(GeometryEnvelope envelope, String where) {
        return this.countFeatures(false, null, envelope, where);
    }

    public int countFeatures(String column, GeometryEnvelope envelope, String where) {
        return this.countFeatures(false, column, envelope, where);
    }

    public int countFeatures(boolean distinct, String column, GeometryEnvelope envelope, String where) {
        return this.countFeatures(distinct, column, envelope, where, null);
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(envelope), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL(envelope), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(envelope), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL(envelope), where, whereArgs);
    }

    public int countFeatures(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.featureDao.countIn(this.queryIdsSQL(envelope), where, whereArgs);
    }

    public int countFeatures(String column, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.featureDao.countIn(column, this.queryIdsSQL(envelope), where, whereArgs);
    }

    public int countFeatures(boolean distinct, String column, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL(envelope), where, whereArgs);
    }

    public FeatureResultSet queryFeaturesForChunk(int limit) {
        return this.queryFeaturesForChunk(this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(int limit, long offset) {
        return this.queryFeaturesForChunk(this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, int limit) {
        return this.queryFeaturesForChunk(distinct, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, int limit) {
        return this.queryFeaturesForChunk(columns, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(Map<String, Object> fieldValues, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, Map<String, Object> fieldValues, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(columns, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, Map<String, Object> fieldValues, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String where, int limit) {
        return this.queryFeaturesForChunk(where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String where, int limit, long offset) {
        return this.queryFeaturesForChunk(where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, String where, int limit) {
        return this.queryFeaturesForChunk(columns, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String[] whereArgs, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String[] whereArgs, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(columns, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String[] whereArgs, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, int limit) {
        return this.queryFeaturesForChunk(boundingBox, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(boundingBox, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(BoundingBox boundingBox, String where, int limit) {
        return this.queryFeaturesForChunk(boundingBox, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, BoundingBox boundingBox, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, BoundingBox boundingBox, String where, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(boundingBox, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryFeaturesForChunk(boundingBox, projection, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(boundingBox, projection, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, projection, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryFeaturesForChunk(boundingBox, projection, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, projection, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, int limit) {
        return this.queryFeaturesForChunk(envelope, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, int limit, long offset) {
        return this.queryFeaturesForChunk(envelope, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, envelope, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, envelope, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, null, envelope, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, null, envelope, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, int limit) {
        return this.queryFeaturesForChunk(columns, envelope, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, envelope, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, envelope, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, envelope, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, null, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, null, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(envelope, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(envelope, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, envelope, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, envelope, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, null, envelope, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, null, envelope, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(columns, envelope, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, envelope, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, envelope, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, envelope, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(envelope), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(envelope), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(GeometryEnvelope envelope, String where, int limit) {
        return this.queryFeaturesForChunk(envelope, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(envelope, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, envelope, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, envelope, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, GeometryEnvelope envelope, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, GeometryEnvelope envelope, String where, int limit) {
        return this.queryFeaturesForChunk(columns, envelope, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, envelope, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, envelope, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, envelope, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(envelope, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(envelope, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, envelope, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, envelope, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, null, envelope, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, null, envelope, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(columns, envelope, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, envelope, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, envelope, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, envelope, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(envelope), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(envelope), where, whereArgs, orderBy, limit, offset);
    }
}

