/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.io.TableAppender;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.util.NilReferencingObject;
import org.apache.sis.referencing.util.ReferencingFactoryContainer;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.storage.geotiff.GeoKeys;
import org.apache.sis.storage.geotiff.GeoKeysLoader;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;

final class CRSBuilder
extends ReferencingFactoryContainer {
    static final int PRIMEM = 0;
    static final int ELLIPSOID = 1;
    static final int DATUM = 2;
    static final int GCRS = 3;
    private static final String[] NAME_KEYS = new String[]{"PrimeM", "PrimeMeridian", "Spheroid", "Ellipsoid", "Datum", "GeodeticDatum"};
    private static final int MIN_KEY_LENGTH = 5;
    private final Reader reader;
    private short majorRevision;
    private short minorRevision;
    private final Map<Short, Object> geoKeys;
    private final Set<String> missingGeoKeys;
    private Identifier lastName;
    public String description;
    public CellGeometry cellGeometry;
    boolean alreadyReported;
    private static final short[][] PARAMETER_ALIASES = new short[][]{{3080, 3084, 3088}, {3081, 3085, 3089}, {3082, 3086, 3090}, {3083, 3087, 3091}, {3092, 3093}};

    CRSBuilder(Reader reader) {
        this.reader = reader;
        this.geoKeys = new HashMap<Short, Object>(32);
        this.missingGeoKeys = new HashSet<String>();
    }

    final void warning(short key, Object ... args) {
        LogRecord r = this.reader.resources().getLogRecord(Level.WARNING, key, args);
        this.reader.store.warning(r);
    }

    private Map<String, ?> properties(Object name) {
        if (name == null) {
            name = NilReferencingObject.UNNAMED;
        } else if (this.lastName != null && this.lastName.getCode().equals(name)) {
            name = this.lastName;
        }
        return Map.of("name", name);
    }

    private Object getSingleton(short key) {
        Object value = this.geoKeys.remove(key);
        if (value != null && value.getClass().isArray()) {
            this.warning((short)16, GeoKeys.name(key), Array.getLength(value));
            value = Array.get(value, 0);
        }
        return value;
    }

    private String getAsString(short key) {
        Object value = this.geoKeys.remove(key);
        if (value != null) {
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                StringJoiner buffer = new StringJoiner(", ");
                for (int i = 0; i < length; ++i) {
                    buffer.add(String.valueOf(Array.get(value, i)));
                }
                value = buffer;
            }
            return value.toString();
        }
        return null;
    }

    private int getAsInteger(short key) {
        Object value = this.getSingleton(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            this.invalidValue(key, value);
            this.alreadyReported = true;
            throw e;
        }
    }

    private double getAsDouble(short key) {
        Object value = this.getSingleton(key);
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException e) {
            this.invalidValue(key, value);
            this.alreadyReported = true;
            throw e;
        }
    }

    private String getMandatoryString(short key) {
        String value = this.getAsString(key);
        if (value != null) {
            return value;
        }
        this.alreadyReported = true;
        throw new NoSuchElementException(this.missingValue(key));
    }

    private double getMandatoryDouble(short key) {
        double value = this.getAsDouble(key);
        if (Double.isFinite(value)) {
            return value;
        }
        this.alreadyReported = true;
        throw new NoSuchElementException(this.missingValue(key));
    }

    final String missingValue(short key) {
        String name = GeoKeys.name(key);
        if (this.missingGeoKeys.add(name)) {
            this.warning((short)12, name);
        }
        return name;
    }

    private void invalidValue(short key, Object value) {
        this.warning((short)9, GeoKeys.name(key), value);
    }

    private void moveParameter(String projection, short oldKey, short newKey) {
        Object value = this.geoKeys.remove(oldKey);
        if (value != null) {
            Object name;
            if (newKey != 0) {
                this.geoKeys.put(newKey, value);
                name = GeoKeys.name(newKey);
            } else {
                name = Vocabulary.formatInternational((short)141);
            }
            this.warning((short)32, GeoKeys.name(oldKey), name, projection);
        }
    }

    private void verify(IdentifiedObject epsg, double expected, short key, Unit<?> unit) {
        double actual = this.getAsDouble(key);
        if (Math.abs(expected - actual) > expected * 1.0E-13) {
            Object symbol = "";
            if (unit != null && !((String)(symbol = unit.toString())).isEmpty() && Character.isLetterOrDigit(((String)symbol).codePointAt(0))) {
                symbol = " " + (String)symbol;
            }
            this.warning((short)14, IdentifiedObjects.getIdentifierOrName((IdentifiedObject)epsg), String.valueOf(expected), GeoKeys.name(key), String.valueOf(actual), symbol);
        }
    }

    private void verifyIdentifier(IdentifiedObject parent, IdentifiedObject epsg, short key) {
        Identifier id;
        int code = this.getAsInteger(key);
        if (code > 0 && code < Short.MAX_VALUE && (id = IdentifiedObjects.getIdentifier((IdentifiedObject)epsg, (Citation)Citations.EPSG)) != null) {
            int expected;
            try {
                expected = Integer.parseInt(id.getCode());
            }
            catch (NumberFormatException e) {
                this.reader.store.listeners().warning((Exception)e);
                return;
            }
            if (code != expected) {
                this.warning((short)14, IdentifiedObjects.getIdentifierOrName((IdentifiedObject)parent), "EPSG:" + expected, GeoKeys.name(key), "EPSG:" + code, "");
            }
        }
    }

    public CoordinateReferenceSystem build(GeoKeysLoader source) throws FactoryException {
        VerticalCRS vertical;
        try {
            source.logger = this;
            if (!source.load(this.geoKeys)) {
                CoordinateReferenceSystem coordinateReferenceSystem = null;
                return coordinateReferenceSystem;
            }
        }
        finally {
            source.logger = null;
            this.majorRevision = source.majorRevision;
            this.minorRevision = source.minorRevision;
        }
        this.description = this.getAsString((short)1026);
        int code = this.getAsInteger((short)1025);
        switch (code) {
            case 0: {
                break;
            }
            case 1: {
                this.cellGeometry = CellGeometry.AREA;
                break;
            }
            case 2: {
                this.cellGeometry = CellGeometry.POINT;
                break;
            }
            default: {
                this.invalidValue((short)1025, code);
            }
        }
        ProjectedCRS crs = null;
        int crsType = this.getAsInteger((short)1024);
        switch (crsType) {
            case 0: {
                break;
            }
            case 1: {
                crs = this.createProjectedCRS();
                break;
            }
            case 3: {
                crs = this.createGeocentricCRS();
                break;
            }
            case 2: {
                crs = this.createGeographicCRS();
                break;
            }
            default: {
                this.warning((short)19, crsType);
            }
        }
        if (crsType != 3 && (vertical = this.createVerticalCRS()) != null) {
            if (crs == null) {
                this.missingValue((short)2048);
            } else {
                crs = this.getCRSFactory().createCompoundCRS(Map.of("name", crs.getName()), new CoordinateReferenceSystem[]{crs, vertical});
            }
        }
        if (!this.geoKeys.isEmpty()) {
            StringJoiner joiner = new StringJoiner(", ");
            Short[] shortArray = this.remainingKeys();
            int n = shortArray.length;
            for (int i = 0; i < n; ++i) {
                short key = shortArray[i];
                joiner.add(GeoKeys.name(key));
            }
            this.warning((short)6, joiner.toString());
        }
        return crs;
    }

    private Short[] remainingKeys() {
        Object[] keys = (Short[])this.geoKeys.keySet().toArray(Short[]::new);
        Arrays.sort(keys);
        return keys;
    }

    private CartesianCS replaceLinearUnit(CartesianCS cs, Unit<Length> unit) throws FactoryException {
        Integer epsg = CoordinateSystems.getEpsgCode(unit, (AxisDirection[])CoordinateSystems.getAxisDirections((CoordinateSystem)cs));
        if (epsg != null) {
            try {
                return this.getCSAuthorityFactory().createCartesianCS(epsg.toString());
            }
            catch (NoSuchAuthorityCodeException e) {
                this.reader.store.listeners().warning((Exception)((Object)e));
            }
        }
        return (CartesianCS)CoordinateSystems.replaceLinearUnit((CoordinateSystem)cs, unit);
    }

    private EllipsoidalCS replaceAngularUnit(EllipsoidalCS cs, Unit<Angle> unit) throws FactoryException {
        Integer epsg = CoordinateSystems.getEpsgCode(unit, (AxisDirection[])CoordinateSystems.getAxisDirections((CoordinateSystem)cs));
        if (epsg != null) {
            try {
                return this.getCSAuthorityFactory().createEllipsoidalCS(epsg.toString());
            }
            catch (NoSuchAuthorityCodeException e) {
                this.reader.store.listeners().warning((Exception)((Object)e));
            }
        }
        return (EllipsoidalCS)CoordinateSystems.replaceAngularUnit((CoordinateSystem)cs, unit);
    }

    private <Q extends Quantity<Q>> Unit<Q> createUnit(short codeKey, short scaleKey, Class<Q> quantity, Unit<Q> defaultValue) throws FactoryException {
        double expected;
        double scale;
        int epsg = this.getAsInteger(codeKey);
        switch (epsg) {
            case 0: {
                return defaultValue;
            }
            case 32767: {
                if (scaleKey == 0) {
                    return defaultValue;
                }
                return defaultValue.getSystemUnit().multiply(this.getMandatoryDouble(scaleKey));
            }
            case 65535: {
                double scale2;
                if (scaleKey != 0 && Double.isFinite(scale2 = this.getAsDouble(scaleKey))) {
                    return defaultValue.getSystemUnit().multiply(scale2);
                }
                return defaultValue;
            }
        }
        Unit unit = this.getCSAuthorityFactory().createUnit(String.valueOf(epsg)).asType(quantity);
        if (scaleKey != 0 && !Double.isNaN(scale = this.getAsDouble(scaleKey)) && Math.abs((expected = unit.getConverterTo(defaultValue.getSystemUnit()).convert(1.0)) - scale) > expected * 1.0E-13) {
            this.warning((short)14, "EPSG:" + epsg, expected, GeoKeys.name(scaleKey), scale, "");
        }
        return unit;
    }

    private PrimeMeridian createPrimeMeridian(String[] names, Unit<Angle> unit) throws FactoryException {
        int epsg = this.getAsInteger((short)2051);
        switch (epsg) {
            case 0: 
            case 32767: {
                double longitude = this.getAsDouble((short)2061);
                if (Double.isNaN(longitude)) {
                    if (epsg == 0) break;
                    this.missingValue((short)2061);
                    break;
                }
                if (longitude == 0.0) break;
                return this.getDatumFactory().createPrimeMeridian(this.properties(names[0]), longitude, unit);
            }
            default: {
                PrimeMeridian pm = this.getDatumAuthorityFactory().createPrimeMeridian(String.valueOf(epsg));
                this.verify(pm, unit);
                return pm;
            }
        }
        return CommonCRS.WGS84.primeMeridian();
    }

    private void verify(PrimeMeridian pm, Unit<Angle> unit) {
        this.verify((IdentifiedObject)pm, ReferencingUtilities.getGreenwichLongitude((PrimeMeridian)pm, unit), (short)2061, unit);
    }

    private Ellipsoid createEllipsoid(String[] names, Unit<Length> unit) throws FactoryException {
        int epsg = this.getAsInteger((short)2056);
        switch (epsg) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)2050));
            }
            case 32767: {
                Ellipsoid ellipsoid;
                Map<String, ?> properties = this.properties(CRSBuilder.getOrDefault(names, 1));
                double semiMajor = this.getMandatoryDouble((short)2057);
                double inverseFlattening = this.getAsDouble((short)2059);
                if (!Double.isNaN(inverseFlattening)) {
                    ellipsoid = this.getDatumFactory().createFlattenedSphere(properties, semiMajor, inverseFlattening, unit);
                } else {
                    double semiMinor = this.getMandatoryDouble((short)2058);
                    ellipsoid = this.getDatumFactory().createEllipsoid(properties, semiMajor, semiMinor, unit);
                }
                this.lastName = ellipsoid.getName();
                return ellipsoid;
            }
        }
        Ellipsoid ellipsoid = this.getDatumAuthorityFactory().createEllipsoid(String.valueOf(epsg));
        this.verify(ellipsoid, unit);
        return ellipsoid;
    }

    private void verify(Ellipsoid ellipsoid, Unit<Length> unit) {
        UnitConverter uc = ellipsoid.getAxisUnit().getConverterTo(unit);
        this.verify((IdentifiedObject)ellipsoid, uc.convert(ellipsoid.getSemiMajorAxis()), (short)2057, unit);
        this.verify((IdentifiedObject)ellipsoid, uc.convert(ellipsoid.getSemiMinorAxis()), (short)2058, unit);
        this.verify((IdentifiedObject)ellipsoid, ellipsoid.getInverseFlattening(), (short)2059, null);
    }

    private GeodeticDatum createGeodeticDatum(String[] names, Unit<Angle> angularUnit, Unit<Length> linearUnit) throws FactoryException {
        int epsg = this.getAsInteger((short)2050);
        switch (epsg) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)2050));
            }
            case 32767: {
                String name = CRSBuilder.getOrDefault(names, 2);
                if (name == null) {
                    throw new NoSuchElementException(this.missingValue((short)2049));
                }
                Ellipsoid ellipsoid = this.createEllipsoid(names, linearUnit);
                PrimeMeridian meridian = this.createPrimeMeridian(names, angularUnit);
                GeodeticDatum datum = this.getDatumFactory().createGeodeticDatum(this.properties(name), ellipsoid, meridian);
                name = Strings.toUpperCase((String)name, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true);
                this.lastName = datum.getName();
                try {
                    GeodeticDatum predefined = CommonCRS.valueOf((String)name).datum();
                    if (Utilities.equalsIgnoreMetadata((Object)predefined.getEllipsoid(), (Object)ellipsoid) && Utilities.equalsIgnoreMetadata((Object)predefined.getPrimeMeridian(), (Object)meridian)) {
                        return predefined;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return datum;
            }
        }
        GeodeticDatum datum = this.getDatumAuthorityFactory().createGeodeticDatum(String.valueOf(epsg));
        this.verify(datum, angularUnit, linearUnit);
        return datum;
    }

    private void verify(GeodeticDatum datum, Unit<Angle> angularUnit, Unit<Length> linearUnit) {
        PrimeMeridian pm = datum.getPrimeMeridian();
        this.verifyIdentifier((IdentifiedObject)datum, (IdentifiedObject)pm, (short)2051);
        this.verify(pm, angularUnit);
        Ellipsoid ellipsoid = datum.getEllipsoid();
        this.verifyIdentifier((IdentifiedObject)datum, (IdentifiedObject)ellipsoid, (short)2056);
        this.verify(ellipsoid, linearUnit);
    }

    /*
     * WARNING - void declaration
     */
    static String[] splitName(String name) {
        String[] names = new String[4];
        String[] components = (String[])CharSequences.split((CharSequence)name, (char)'|');
        switch (components.length) {
            case 0: {
                break;
            }
            case 1: {
                names[3] = name;
                break;
            }
            default: {
                for (String string : components) {
                    void var6_6;
                    void var6_9;
                    int s = string.indexOf(61);
                    int type = 3;
                    if (s >= 0) {
                        int length = CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)0, (int)s);
                        if (length >= 5) {
                            for (int t = 0; t < NAME_KEYS.length; ++t) {
                                if (!string.regionMatches(true, 0, NAME_KEYS[t], 0, length)) continue;
                                type = t / 2;
                                break;
                            }
                        }
                        String string2 = string.substring(CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(s + 1), (int)string.length()));
                    }
                    if (var6_9.isEmpty()) continue;
                    if (names[type] != null) {
                        String string3 = names[type] + " " + (String)var6_9;
                    }
                    names[type] = var6_6;
                }
            }
        }
        return names;
    }

    private static String getOrDefault(String[] names, int component) {
        String c = names[component];
        if (c == null) {
            component = 0;
            while (++component < names.length && (c = names[component]) == null) {
                ++component;
            }
        }
        return c;
    }

    private GeographicCRS createGeographicCRS() throws FactoryException {
        return this.createGeographicCRS(true, this.createUnit((short)2054, (short)2055, Angle.class, Units.DEGREE));
    }

    private GeographicCRS createGeographicCRS(boolean isImageCRS, Unit<Angle> angularUnit) throws FactoryException {
        int epsg = this.getAsInteger((short)2048);
        switch (epsg) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)2048));
            }
            case 32767: {
                String[] names = CRSBuilder.splitName(this.getAsString((short)2049));
                Unit<Length> linearUnit = this.createUnit((short)2052, (short)2053, Length.class, Units.METRE);
                GeodeticDatum datum = this.createGeodeticDatum(names, angularUnit, linearUnit);
                EllipsoidalCS cs = CommonCRS.defaultGeographic().getCoordinateSystem();
                if (!Units.DEGREE.equals(angularUnit)) {
                    cs = this.replaceAngularUnit(cs, angularUnit);
                }
                GeographicCRS crs = this.getCRSFactory().createGeographicCRS(this.properties(CRSBuilder.getOrDefault(names, 3)), datum, cs);
                this.lastName = crs.getName();
                return crs;
            }
        }
        GeographicCRS crs = this.getCRSAuthorityFactory().createGeographicCRS(String.valueOf(epsg));
        if (isImageCRS) {
            crs = DefaultGeographicCRS.castOrCopy((GeographicCRS)crs).forConvention(AxesConvention.DISPLAY_ORIENTED);
        }
        this.verify(crs, angularUnit);
        return crs;
    }

    private void verify(GeographicCRS crs, Unit<Angle> angularUnit) throws FactoryException {
        Unit<Length> linearUnit = this.createUnit((short)2052, (short)2053, Length.class, Units.METRE);
        GeodeticDatum datum = crs.getDatum();
        this.verifyIdentifier((IdentifiedObject)crs, (IdentifiedObject)datum, (short)2050);
        this.verify(datum, angularUnit, linearUnit);
        this.geoKeys.remove((short)2049);
    }

    private GeocentricCRS createGeocentricCRS() throws FactoryException {
        int epsg = this.getAsInteger((short)2048);
        switch (epsg) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)2048));
            }
            case 32767: {
                String[] names = CRSBuilder.splitName(this.getAsString((short)2049));
                Unit<Length> linearUnit = this.createUnit((short)2052, (short)2053, Length.class, Units.METRE);
                Unit<Angle> angularUnit = this.createUnit((short)2054, (short)2055, Angle.class, Units.DEGREE);
                GeodeticDatum datum = this.createGeodeticDatum(names, angularUnit, linearUnit);
                CartesianCS cs = (CartesianCS)CommonCRS.WGS84.geocentric().getCoordinateSystem();
                if (!Units.METRE.equals(linearUnit)) {
                    cs = this.replaceLinearUnit(cs, linearUnit);
                }
                GeocentricCRS crs = this.getCRSFactory().createGeocentricCRS(this.properties(CRSBuilder.getOrDefault(names, 3)), datum, cs);
                this.lastName = crs.getName();
                return crs;
            }
        }
        GeocentricCRS crs = this.getCRSAuthorityFactory().createGeocentricCRS(String.valueOf(epsg));
        this.verify(crs);
        return crs;
    }

    private void verify(GeocentricCRS crs) throws FactoryException {
        Unit<Length> linearUnit = this.createUnit((short)2052, (short)2053, Length.class, Units.METRE);
        Unit<Angle> angularUnit = this.createUnit((short)2054, (short)2055, Angle.class, Units.DEGREE);
        GeodeticDatum datum = crs.getDatum();
        this.verifyIdentifier((IdentifiedObject)crs, (IdentifiedObject)datum, (short)2050);
        this.verify(datum, angularUnit, linearUnit);
    }

    private static void aliases(Map<Integer, String> mapping) {
        block0: for (short[] codes : PARAMETER_ALIASES) {
            for (int i = 0; i < codes.length; ++i) {
                String name = mapping.get(Short.toUnsignedInt(codes[i]));
                if (name == null) continue;
                for (int j = 0; j < codes.length; ++j) {
                    if (j == i) continue;
                    mapping.putIfAbsent(Short.toUnsignedInt(codes[j]), name);
                }
                continue block0;
            }
        }
    }

    private ProjectedCRS createProjectedCRS() throws FactoryException {
        int epsg = this.getAsInteger((short)3072);
        switch (epsg) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)3072));
            }
            case 32767: {
                String name = this.getAsString((short)3073);
                if (name == null) {
                    name = this.getAsString((short)1026);
                }
                Unit<Length> linearUnit = this.createUnit((short)3076, (short)3077, Length.class, Units.METRE);
                Unit<Angle> angularUnit = this.createUnit((short)2054, (short)2055, Angle.class, Units.DEGREE);
                GeographicCRS baseCRS = this.createGeographicCRS(false, angularUnit);
                Conversion projection = this.createConversion(name, angularUnit, linearUnit);
                CartesianCS cs = this.getStandardProjectedCS();
                if (!Units.METRE.equals(linearUnit)) {
                    cs = this.replaceLinearUnit(cs, linearUnit);
                }
                ProjectedCRS crs = this.getCRSFactory().createProjectedCRS(this.properties(name), baseCRS, projection, cs);
                this.lastName = crs.getName();
                return crs;
            }
        }
        ProjectedCRS crs = this.getCRSAuthorityFactory().createProjectedCRS(String.valueOf(epsg));
        crs = DefaultProjectedCRS.castOrCopy((ProjectedCRS)crs).forConvention(AxesConvention.DISPLAY_ORIENTED);
        this.verify(crs);
        return crs;
    }

    private void verify(ProjectedCRS crs) throws FactoryException {
        Unit<Length> linearUnit = this.createUnit((short)3076, (short)3077, Length.class, Units.METRE);
        Unit<Angle> angularUnit = this.createUnit((short)2054, (short)2055, Angle.class, Units.DEGREE);
        GeographicCRS baseCRS = crs.getBaseCRS();
        this.verifyIdentifier((IdentifiedObject)crs, (IdentifiedObject)baseCRS, (short)2048);
        this.verify(baseCRS, angularUnit);
        Projection projection = crs.getConversionFromBase();
        this.verifyIdentifier((IdentifiedObject)crs, (IdentifiedObject)projection, (short)3074);
        this.verify((Conversion)projection, angularUnit, linearUnit);
    }

    private String methodCode() {
        String code = this.getMandatoryString((short)3075);
        try {
            switch (Integer.parseInt(code)) {
                case 15: {
                    if (this.geoKeys.containsKey((short)3078)) break;
                    Object value = this.geoKeys.get((short)3092);
                    if (value instanceof Number && ((Number)value).doubleValue() != 1.0) {
                        return "EPSG:9810";
                    }
                    this.moveParameter("Polar Stereographic (variant B)", (short)3081, (short)3078);
                    this.moveParameter("Polar Stereographic (variant B)", (short)3092, (short)0);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            return code;
        }
        return "GeoTIFF:" + code;
    }

    private Conversion createConversion(String name, Unit<Angle> angularUnit, Unit<Length> linearUnit) throws FactoryException {
        int epsg = this.getAsInteger((short)3074);
        switch (epsg) {
            case 0: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)3074));
            }
            case 32767: {
                Short key;
                Unit<Angle> azimuthUnit = this.createUnit((short)2060, (short)0, Angle.class, Units.DEGREE);
                OperationMethod method = this.getCoordinateOperationFactory().getOperationMethod(this.methodCode());
                ParameterValueGroup parameters = method.getParameters().createValue();
                Map toNames = ReferencingUtilities.identifierToName((ParameterDescriptorGroup)parameters.getDescriptor(), (Citation)Citations.GEOTIFF);
                HashMap<Object, Number> paramValues = new HashMap<Object, Number>();
                HashMap<Short, Unit<Length>> deferred = new HashMap<Short, Unit<Length>>();
                Iterator<Map.Entry<Short, Object>> it = this.geoKeys.entrySet().iterator();
                block10: while (it.hasNext()) {
                    Unit<Length> unit;
                    Map.Entry<Short, Object> entry = it.next();
                    key = entry.getKey();
                    switch (GeoKeys.unitOf(key)) {
                        case 0: {
                            unit = Units.UNITY;
                            break;
                        }
                        case 1: {
                            unit = linearUnit;
                            break;
                        }
                        case 2: {
                            unit = angularUnit;
                            break;
                        }
                        case 3: {
                            unit = azimuthUnit;
                            break;
                        }
                        default: {
                            continue block10;
                        }
                    }
                    Number value = (Number)entry.getValue();
                    it.remove();
                    String paramName = (String)toNames.get(Short.toUnsignedInt(key));
                    if (paramName != null) {
                        paramValues.put(paramName, value);
                        parameters.parameter(paramName).setValue(value.doubleValue(), unit);
                        continue;
                    }
                    paramValues.put(key, value);
                    deferred.put(key, unit);
                }
                if (!deferred.isEmpty()) {
                    CRSBuilder.aliases(toNames);
                    for (Map.Entry entry : deferred.entrySet()) {
                        key = (Short)entry.getKey();
                        String paramName = (String)toNames.get(Short.toUnsignedInt(key));
                        if (paramName == null) {
                            paramName = GeoKeys.name(key);
                            throw new ParameterNotFoundException(this.reader.errors().getString((short)140, (Object)paramName), paramName);
                        }
                        Number value = (Number)paramValues.get(key);
                        Number actual = paramValues.putIfAbsent(paramName, value);
                        if (actual == null) {
                            parameters.parameter(paramName).setValue(value.doubleValue(), (Unit)entry.getValue());
                            continue;
                        }
                        if (actual.equals(value)) continue;
                        this.warning((short)24, paramName, actual, GeoKeys.name(key), value);
                    }
                }
                Conversion c = this.getCoordinateOperationFactory().createDefiningConversion(this.properties(name), method, parameters);
                this.lastName = c.getName();
                return c;
            }
        }
        Conversion projection = (Conversion)this.getCoordinateOperationAuthorityFactory().createCoordinateOperation(String.valueOf(epsg));
        this.verify(projection, angularUnit, linearUnit);
        return projection;
    }

    private void verify(Conversion projection, Unit<Angle> angularUnit, Unit<Length> linearUnit) throws FactoryException {
        Unit<Angle> azimuthUnit = this.createUnit((short)2060, (short)0, Angle.class, Units.DEGREE);
        String type = this.getAsString((short)3075);
        if (type != null) {
            OperationMethod method = projection.getMethod();
            if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)method, (String)type)) {
                Identifier expected = IdentifiedObjects.getIdentifier((IdentifiedObject)method, (Citation)Citations.GEOTIFF);
                if (expected == null) {
                    expected = IdentifiedObjects.getIdentifier((IdentifiedObject)method, null);
                }
                this.warning((short)14, IdentifiedObjects.getIdentifierOrName((IdentifiedObject)projection), expected.getCode(), GeoKeys.name((short)3075), type, "");
            }
            ParameterValueGroup parameters = projection.getParameterValues();
            Short[] shortArray = this.remainingKeys();
            int n = shortArray.length;
            block8: for (int i = 0; i < n; ++i) {
                Unit<Length> unit;
                short key = shortArray[i];
                switch (GeoKeys.unitOf(key)) {
                    case 0: {
                        unit = Units.UNITY;
                        break;
                    }
                    case 1: {
                        unit = linearUnit;
                        break;
                    }
                    case 2: {
                        unit = angularUnit;
                        break;
                    }
                    case 3: {
                        unit = azimuthUnit;
                        break;
                    }
                    default: {
                        continue block8;
                    }
                }
                try {
                    this.verify((IdentifiedObject)projection, parameters.parameter("GeoTIFF:" + key).doubleValue(unit), key, unit);
                    continue;
                }
                catch (ParameterNotFoundException e) {
                    this.warning((short)17, type, GeoKeys.name(key));
                }
            }
        }
    }

    private VerticalDatum createVerticalDatum() throws FactoryException {
        int epsg = this.getAsInteger((short)4098);
        switch (epsg) {
            case 0: 
            case 32767: {
                this.alreadyReported = true;
                throw new NoSuchElementException(this.missingValue((short)4098));
            }
        }
        return this.getDatumAuthorityFactory().createVerticalDatum(String.valueOf(epsg));
    }

    private VerticalCRS createVerticalCRS() throws FactoryException {
        int epsg = this.getAsInteger((short)4096);
        switch (epsg) {
            case 0: {
                return null;
            }
            case 32767: {
                String name = this.getAsString((short)4097);
                VerticalDatum datum = this.createVerticalDatum();
                Unit<Length> unit = this.createUnit((short)4099, (short)0, Length.class, Units.METRE);
                VerticalCS cs = CommonCRS.Vertical.MEAN_SEA_LEVEL.crs().getCoordinateSystem();
                if (!Units.METRE.equals(unit)) {
                    cs = (VerticalCS)CoordinateSystems.replaceLinearUnit((CoordinateSystem)cs, unit);
                }
                return this.getCRSFactory().createVerticalCRS(this.properties(name), datum, cs);
            }
        }
        return this.getCRSAuthorityFactory().createVerticalCRS(String.valueOf(epsg));
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder("GeoTIFF keys ").append(this.majorRevision).append('.').append(this.minorRevision).append(" in ").append(this.reader.input.filename).append(System.lineSeparator());
        TableAppender table = new TableAppender((Appendable)buffer, " ");
        for (Map.Entry<Short, Object> entry : this.geoKeys.entrySet()) {
            short key = entry.getKey();
            table.append((CharSequence)String.valueOf(key)).nextColumn();
            table.append((CharSequence)GeoKeys.name(key)).nextColumn();
            table.append((CharSequence)" = ").append((CharSequence)String.valueOf(entry.getValue())).nextLine();
        }
        try {
            table.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer.toString();
    }
}

