/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.map;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.annotation.JacksonResponseConverterFunction;
import com.linecorp.armeria.server.cors.CorsService;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.config.ConfigReader;
import org.apache.baremaps.maplibre.style.Style;
import org.apache.baremaps.maplibre.tilejson.TileJSON;
import org.apache.baremaps.server.StyleResource;
import org.apache.baremaps.server.TileJSONResource;
import org.apache.baremaps.server.VectorTileResource;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.mbtiles.MBTilesStore;
import org.apache.baremaps.tilestore.vector.VectorTileCache;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.apache.baremaps.utils.SqliteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="mbtiles", description={"Start a mbtiles server with caching capabilities."})
public class MBTiles
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(MBTiles.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--cache"}, paramLabel="CACHE", description={"The caffeine cache directive."})
    private String cache = "";
    @CommandLine.Option(names={"--mbtiles"}, paramLabel="MBTILES", description={"The mbtiles file."}, required=true)
    private Path mbtilesPath;
    @CommandLine.Option(names={"--tilejson"}, paramLabel="TILEJSON", description={"The tileJSON file."}, required=true)
    private Path tileJSONPath;
    @CommandLine.Option(names={"--style"}, paramLabel="STYLE", description={"The style file."}, required=true)
    private Path stylePath;
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
        ConfigReader configReader = new ConfigReader();
        CaffeineSpec caffeineSpec = CaffeineSpec.parse((String)this.cache);
        DataSource datasource = SqliteUtils.createDataSource((Path)this.mbtilesPath, (boolean)true);
        try (MBTilesStore tileStore = new MBTilesStore(datasource);
             VectorTileCache tileCache = new VectorTileCache((TileStore)tileStore, caffeineSpec);){
            Supplier<TileStore> tileStoreSupplier = () -> tileCache;
            Style style = (Style)objectMapper.readValue(configReader.read(this.stylePath), Style.class);
            Supplier<Style> styleSupplier = () -> style;
            TileJSON tileJSON = (TileJSON)objectMapper.readValue(configReader.read(this.tileJSONPath), TileJSON.class);
            Supplier<TileJSON> tileJSONSupplier = () -> tileJSON;
            ServerBuilder serverBuilder = Server.builder();
            serverBuilder.http(this.port);
            JacksonResponseConverterFunction jsonResponseConverter = new JacksonResponseConverterFunction(objectMapper);
            serverBuilder.annotatedService("/tiles", (Object)new VectorTileResource(tileStoreSupplier), new Object[]{jsonResponseConverter});
            serverBuilder.annotatedService((Object)new StyleResource(styleSupplier), new Object[]{jsonResponseConverter});
            serverBuilder.annotatedService((Object)new TileJSONResource(tileJSONSupplier), new Object[]{jsonResponseConverter});
            HttpFile index = HttpFile.of((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"/static/server.html");
            serverBuilder.service("/", index.asService());
            serverBuilder.serviceUnder("/", (HttpService)FileService.of((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"/static"));
            serverBuilder.decorator(CorsService.builderForAnyOrigin().allowRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.OPTIONS, HttpMethod.HEAD}).allowRequestHeaders(new CharSequence[]{HttpHeaderNames.ORIGIN, HttpHeaderNames.CONTENT_TYPE, HttpHeaderNames.ACCEPT, HttpHeaderNames.AUTHORIZATION}).allowCredentials().exposeHeaders(new CharSequence[]{HttpHeaderNames.LOCATION}).newDecorator());
            serverBuilder.serviceUnder("/docs", (HttpService)new DocService());
            serverBuilder.disableServerHeader();
            serverBuilder.disableDateHeader();
            Server server = serverBuilder.build();
            CompletableFuture startFuture = server.start();
            startFuture.join();
            CompletableFuture shutdownFuture = server.closeOnJvmShutdown();
            shutdownFuture.join();
        }
        return 0;
    }
}

