/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.Watcher;

public abstract class AbstractWatcher
implements Watcher {
    private final Reconfigurable reconfigurable;
    private final List<Consumer<Reconfigurable>> reconfigurableListeners;
    private final Executor executor;
    private final Configuration configuration;
    private Source source;

    public AbstractWatcher(Configuration configuration, Reconfigurable reconfigurable, List<Consumer<Reconfigurable>> reconfigurableListeners) {
        this.configuration = configuration;
        this.reconfigurable = reconfigurable;
        this.reconfigurableListeners = reconfigurableListeners;
        this.executor = reconfigurableListeners != null ? Executors.newCachedThreadPool(Log4jThreadFactory.createDaemonThreadFactory("ConfigurationFileWatcher")) : null;
    }

    @Override
    public List<Consumer<Reconfigurable>> getListeners() {
        return this.reconfigurableListeners;
    }

    @Override
    public void modified() {
        for (Consumer<Reconfigurable> reconfigurableListener : this.reconfigurableListeners) {
            this.executor.execute(() -> reconfigurableListener.accept(this.reconfigurable));
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public abstract long getLastModified();

    @Override
    public abstract boolean isModified();

    @Override
    public void watching(Source source) {
        this.source = source;
    }

    @Override
    public Source getSource() {
        return this.source;
    }
}

