/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.time.internal.format.FastDateFormat;
import org.apache.logging.log4j.core.time.internal.format.FixedDateFormat;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.spi.recycler.Recycler;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Namespace(value="Converter")
@Plugin(value="DatePatternConverter")
@ConverterKeys(value={"d", "date"})
@PerformanceSensitive(value={"allocation"})
public final class DatePatternConverter
extends LogEventPatternConverter
implements ArrayPatternConverter {
    private static final String UNIX_FORMAT = "UNIX";
    private static final String UNIX_MILLIS_FORMAT = "UNIX_MILLIS";
    private final String pattern;
    private final TimeZone timeZone;
    private final Recycler<MutableInstant> mutableInstantRecycler;
    private final Recycler<Formatter> formatterRecycler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatePatternConverter(Configuration configuration, String[] options) {
        super("Date", "date");
        String[] safeOptions = options == null ? null : Arrays.copyOf(options, options.length);
        this.mutableInstantRecycler = configuration.getRecyclerFactory().create(MutableInstant::new);
        this.formatterRecycler = configuration.getRecyclerFactory().create(() -> this.createFormatter(safeOptions));
        Formatter formatter = (Formatter)this.formatterRecycler.acquire();
        try {
            this.pattern = formatter.toPattern();
            this.timeZone = formatter.getTimeZone();
        }
        finally {
            this.formatterRecycler.release((Object)formatter);
        }
    }

    private Formatter createFormatter(String[] options) {
        FixedDateFormat fixedDateFormat = FixedDateFormat.createIfSupported(options);
        if (fixedDateFormat != null) {
            return DatePatternConverter.createFixedFormatter(fixedDateFormat);
        }
        return DatePatternConverter.createNonFixedFormatter(options);
    }

    public static DatePatternConverter newInstance(Configuration configuration, String[] options) {
        return new DatePatternConverter(configuration, options);
    }

    private static Formatter createFixedFormatter(FixedDateFormat fixedDateFormat) {
        return new FixedFormatter(fixedDateFormat);
    }

    private static Formatter createNonFixedFormatter(String[] options) {
        Objects.requireNonNull(options);
        if (options.length == 0) {
            throw new IllegalArgumentException("Options array must have at least one element");
        }
        Objects.requireNonNull(options[0]);
        String patternOption = options[0];
        if (UNIX_FORMAT.equals(patternOption)) {
            return new UnixFormatter();
        }
        if (UNIX_MILLIS_FORMAT.equals(patternOption)) {
            return new UnixMillisFormatter();
        }
        FixedDateFormat.FixedFormat fixedFormat = FixedDateFormat.FixedFormat.lookup(patternOption);
        String pattern = fixedFormat == null ? patternOption : fixedFormat.getPattern();
        TimeZone tz = null;
        if (options.length > 1 && options[1] != null) {
            tz = TimeZone.getTimeZone(options[1]);
        }
        Locale locale = null;
        if (options.length > 2 && options[2] != null) {
            locale = Locale.forLanguageTag(options[2]);
        }
        try {
            FastDateFormat tempFormat = FastDateFormat.getInstance(pattern, tz, locale);
            return new PatternFormatter(tempFormat);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Could not instantiate FastDateFormat with pattern " + pattern, (Throwable)e);
            return DatePatternConverter.createFixedFormatter(FixedDateFormat.create(FixedDateFormat.FixedFormat.DEFAULT, tz));
        }
    }

    void format(Date date, StringBuilder toAppendTo) {
        this.format(date.getTime(), toAppendTo);
    }

    @Override
    public void format(LogEvent event, StringBuilder output) {
        this.format(event.getInstant(), output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void format(long epochMilli, StringBuilder output) {
        MutableInstant instant = (MutableInstant)this.mutableInstantRecycler.acquire();
        try {
            instant.initFromEpochMilli(epochMilli, 0);
            this.format(instant, output);
        }
        finally {
            this.mutableInstantRecycler.release((Object)instant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void format(Instant instant, StringBuilder output) {
        Formatter formatter = (Formatter)this.formatterRecycler.acquire();
        try {
            formatter.formatToBuffer(instant, output);
        }
        finally {
            this.formatterRecycler.release((Object)formatter);
        }
    }

    @Override
    public void format(Object obj, StringBuilder output) {
        if (obj instanceof Date) {
            this.format((Date)obj, output);
        }
        super.format(obj, output);
    }

    @Override
    public void format(StringBuilder toAppendTo, Object ... objects) {
        for (Object obj : objects) {
            if (!(obj instanceof Date)) continue;
            this.format(obj, toAppendTo);
            break;
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    private static abstract class Formatter {
        long previousTime;
        int nanos;

        private Formatter() {
        }

        abstract void formatToBuffer(Instant var1, StringBuilder var2);

        public String toPattern() {
            return null;
        }

        public TimeZone getTimeZone() {
            return TimeZone.getDefault();
        }
    }

    private static final class FixedFormatter
    extends Formatter {
        private final FixedDateFormat fixedDateFormat;
        private final char[] cachedBuffer = new char[70];
        private int length = 0;

        FixedFormatter(FixedDateFormat fixedDateFormat) {
            this.fixedDateFormat = fixedDateFormat;
        }

        @Override
        void formatToBuffer(Instant instant, StringBuilder destination) {
            int nanoOfSecond;
            long epochSecond = instant.getEpochSecond();
            if (!this.fixedDateFormat.isEquivalent(this.previousTime, this.nanos, epochSecond, nanoOfSecond = instant.getNanoOfSecond())) {
                this.length = this.fixedDateFormat.formatInstant(instant, this.cachedBuffer, 0);
                this.previousTime = epochSecond;
                this.nanos = nanoOfSecond;
            }
            destination.append(this.cachedBuffer, 0, this.length);
        }

        @Override
        public String toPattern() {
            return this.fixedDateFormat.getFormat();
        }

        @Override
        public TimeZone getTimeZone() {
            return this.fixedDateFormat.getTimeZone();
        }
    }

    private static final class UnixFormatter
    extends Formatter {
        private UnixFormatter() {
        }

        @Override
        void formatToBuffer(Instant instant, StringBuilder destination) {
            destination.append(instant.getEpochSecond());
        }
    }

    private static final class UnixMillisFormatter
    extends Formatter {
        private UnixMillisFormatter() {
        }

        @Override
        void formatToBuffer(Instant instant, StringBuilder destination) {
            destination.append(instant.getEpochMillisecond());
        }
    }

    private static final class PatternFormatter
    extends Formatter {
        private final FastDateFormat fastDateFormat;
        private final StringBuilder cachedBuffer = new StringBuilder(64);

        PatternFormatter(FastDateFormat fastDateFormat) {
            this.fastDateFormat = fastDateFormat;
        }

        @Override
        void formatToBuffer(Instant instant, StringBuilder destination) {
            long timeMillis = instant.getEpochMillisecond();
            if (this.previousTime != timeMillis) {
                this.cachedBuffer.setLength(0);
                this.fastDateFormat.format(timeMillis, this.cachedBuffer);
            }
            destination.append((CharSequence)this.cachedBuffer);
        }

        @Override
        public String toPattern() {
            return this.fastDateFormat.getPattern();
        }

        @Override
        public TimeZone getTimeZone() {
            return this.fastDateFormat.getTimeZone();
        }
    }
}

