/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.StringBuilderEncoder;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.spi.recycler.Recycler;
import org.apache.logging.log4j.spi.recycler.RecyclerFactory;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyKey;
import org.apache.logging.log4j.util.StringBuilders;

public abstract class AbstractStringLayout
extends AbstractLayout
implements StringLayout {
    protected static final int DEFAULT_STRING_BUILDER_SIZE = 1024;
    protected static final int MAX_STRING_BUILDER_SIZE = Math.max(1024, PropertiesUtil.getProperties().getIntegerProperty((PropertyKey)Log4jPropertyKey.GC_LAYOUT_STRING_BUILDER_MAX_SIZE, Math.multiplyExact(2, 1024)));
    private final Serializer footerSerializer;
    private final Serializer headerSerializer;
    protected final Recycler<Encoder<StringBuilder>> stringBuilderEncoderRecycler;
    protected final Recycler<StringBuilder> stringBuilderRecycler;

    protected static Recycler<StringBuilder> createStringBuilderRecycler(RecyclerFactory recyclerFactory) {
        return recyclerFactory.create(() -> new StringBuilder(1024), stringBuilder -> {
            StringBuilders.trimToMaxSize((StringBuilder)stringBuilder, (int)MAX_STRING_BUILDER_SIZE);
            stringBuilder.setLength(0);
        });
    }

    protected AbstractStringLayout(Configuration configuration, Charset charset) {
        this(configuration, charset, null, (byte[])null);
    }

    protected AbstractStringLayout(Configuration configuration, Charset charset, byte[] header, byte[] footer) {
        super(configuration, charset, header, footer);
        this.headerSerializer = null;
        this.footerSerializer = null;
        RecyclerFactory recyclerFactory = configuration.getRecyclerFactory();
        this.stringBuilderEncoderRecycler = AbstractStringLayout.createStringBuilderEncoderRecycler(recyclerFactory, this.getCharset());
        this.stringBuilderRecycler = AbstractStringLayout.createStringBuilderRecycler(recyclerFactory);
    }

    protected AbstractStringLayout(Configuration configuration, Charset charset, Serializer headerSerializer, Serializer footerSerializer) {
        super(configuration, charset, null, null);
        this.headerSerializer = headerSerializer;
        this.footerSerializer = footerSerializer;
        this.stringBuilderEncoderRecycler = AbstractStringLayout.createStringBuilderEncoderRecycler(configuration.getRecyclerFactory(), this.getCharset());
        this.stringBuilderRecycler = AbstractStringLayout.createStringBuilderRecycler(configuration.getRecyclerFactory());
    }

    private static Recycler<Encoder<StringBuilder>> createStringBuilderEncoderRecycler(RecyclerFactory recyclerFactory, Charset charset) {
        return recyclerFactory.create(() -> new StringBuilderEncoder(charset));
    }

    protected byte[] getBytes(String s) {
        return s.getBytes(this.charset);
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public byte[] getFooter() {
        return this.serializeToBytes(this.footerSerializer, super.getFooter());
    }

    public Serializer getFooterSerializer() {
        return this.footerSerializer;
    }

    @Override
    public byte[] getHeader() {
        return this.serializeToBytes(this.headerSerializer, super.getHeader());
    }

    public Serializer getHeaderSerializer() {
        return this.headerSerializer;
    }

    protected byte[] serializeToBytes(Serializer serializer, byte[] defaultValue) {
        String serializable = this.serializeToString(serializer);
        if (serializable == null) {
            return defaultValue;
        }
        Charset charset = this.getCharset();
        return serializable.getBytes(charset != null ? charset : Charset.defaultCharset());
    }

    protected String serializeToString(Serializer serializer) {
        if (serializer == null) {
            return null;
        }
        Configuration config = this.getConfiguration();
        if (config == null) {
            return null;
        }
        LoggerConfig rootLogger = config.getRootLogger();
        LogEventFactory logEventFactory = config.getComponent(LogEventFactory.KEY);
        String fqcn = this.getClass().getName();
        LogEvent logEvent = logEventFactory.createEvent(rootLogger.getName(), null, fqcn, rootLogger.getLevel(), null, null, null);
        return serializer.toSerializable(logEvent);
    }

    @Override
    public byte[] toByteArray(LogEvent event) {
        return this.getBytes(this.toSerializable(event));
    }

    @Override
    public abstract String toSerializable(LogEvent var1);

    public static interface Serializer
    extends Serializer2 {
        public String toSerializable(LogEvent var1);

        default public boolean requiresLocation() {
            return false;
        }

        @Override
        default public StringBuilder toSerializable(LogEvent event, StringBuilder builder) {
            builder.append(this.toSerializable(event));
            return builder;
        }
    }

    public static interface Serializer2 {
        public StringBuilder toSerializable(LogEvent var1, StringBuilder var2);
    }

    public static abstract class Builder<B extends Builder<B>>
    extends AbstractLayout.Builder<B> {
        @PluginElement(value="footerSerializer")
        private @PluginElement(value="footerSerializer") Serializer footerSerializer;
        @PluginElement(value="headerSerializer")
        private @PluginElement(value="headerSerializer") Serializer headerSerializer;

        public Serializer getFooterSerializer() {
            return this.footerSerializer;
        }

        public Serializer getHeaderSerializer() {
            return this.headerSerializer;
        }

        public B setFooterSerializer(Serializer footerSerializer) {
            this.footerSerializer = footerSerializer;
            return (B)((Builder)this.asBuilder());
        }

        public B setHeaderSerializer(Serializer headerSerializer) {
            this.headerSerializer = headerSerializer;
            return (B)((Builder)this.asBuilder());
        }
    }
}

