/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.reproject;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.db.master.SQLiteMaster;
import mil.nga.geopackage.db.master.SQLiteMasterColumn;
import mil.nga.geopackage.db.master.SQLiteMasterQuery;
import mil.nga.geopackage.io.GeoPackageProgress;
import mil.nga.geopackage.srs.SpatialReferenceSystem;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.reproject.TileReprojectionOptimize;
import mil.nga.geopackage.tiles.reproject.TileReprojectionZoom;
import mil.nga.geopackage.tiles.user.TileColumn;
import mil.nga.geopackage.tiles.user.TileTable;
import mil.nga.geopackage.tiles.user.TileTableMetadata;
import mil.nga.geopackage.user.UserCoreDao;
import mil.nga.proj.Projection;
import mil.nga.sf.proj.GeometryTransform;

public abstract class TileReprojectionCore {
    private static final double PIXEL_SIZE_DELTA = 1.0E-11;
    protected TileReprojectionOptimize optimize;
    protected boolean overwrite = false;
    protected Long tileWidth;
    protected Long tileHeight;
    protected GeoPackageProgress progress;
    protected UserCoreDao<TileColumn, TileTable, ?, ?> tileDao;
    protected GeoPackageCore geoPackage;
    protected String table;
    protected Projection projection;
    protected UserCoreDao<TileColumn, TileTable, ?, ?> reprojectTileDao;
    protected boolean replace = false;
    protected Map<Long, TileReprojectionZoom> zoomConfigs = new HashMap<Long, TileReprojectionZoom>();
    protected TileGrid optimizeTileGrid;
    protected long optimizeZoom;

    protected TileReprojectionCore(UserCoreDao<TileColumn, TileTable, ?, ?> tileDao, GeoPackageCore geoPackage, String table, Projection projection) {
        this.tileDao = tileDao;
        this.geoPackage = geoPackage;
        this.table = table;
        this.projection = projection;
    }

    protected TileReprojectionCore(UserCoreDao<TileColumn, TileTable, ?, ?> tileDao, UserCoreDao<TileColumn, TileTable, ?, ?> reprojectTileDao) {
        this.tileDao = tileDao;
        this.reprojectTileDao = reprojectTileDao;
    }

    protected TileReprojectionCore(UserCoreDao<TileColumn, TileTable, ?, ?> tileDao, GeoPackageCore geoPackage, UserCoreDao<TileColumn, TileTable, ?, ?> reprojectTileDao) {
        this(tileDao, reprojectTileDao);
        this.geoPackage = geoPackage;
    }

    protected abstract long getOptimizeZoom();

    protected abstract UserCoreDao<TileColumn, TileTable, ?, ?> createReprojectTileDao(String var1);

    protected abstract TileMatrixSet getTileMatrixSet(boolean var1);

    protected abstract List<TileMatrix> getTileMatrices(boolean var1);

    protected abstract TileMatrix getTileMatrix(boolean var1, long var2);

    protected abstract void deleteTileMatrices(boolean var1, String var2);

    protected abstract long getMapZoom(boolean var1, TileMatrix var2);

    protected abstract void createTileMatrix(TileMatrix var1);

    protected abstract int reproject(long var1, long var3, BoundingBox var5, long var6, long var8, long var10, long var12);

    public TileReprojectionOptimize getOptimize() {
        return this.optimize;
    }

    public void setOptimize(TileReprojectionOptimize optimize) {
        this.optimize = optimize;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public Long getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(Long tileWidth) {
        this.tileWidth = tileWidth;
    }

    public Long getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(Long tileHeight) {
        this.tileHeight = tileHeight;
    }

    public GeoPackageProgress getProgress() {
        return this.progress;
    }

    public void setProgress(GeoPackageProgress progress) {
        this.progress = progress;
    }

    public Map<Long, TileReprojectionZoom> getZoomConfigs() {
        return this.zoomConfigs;
    }

    public TileReprojectionZoom getConfig(long zoom) {
        return this.zoomConfigs.get(zoom);
    }

    public TileReprojectionZoom getConfigOrCreate(long zoom) {
        TileReprojectionZoom config = this.getConfig(zoom);
        if (config == null) {
            config = new TileReprojectionZoom(zoom);
            this.setConfig(config);
        }
        return config;
    }

    public void setConfig(TileReprojectionZoom config) {
        this.zoomConfigs.put(config.getZoom(), config);
    }

    public void setToZoom(long zoom, long toZoom) {
        this.getConfigOrCreate(zoom).setToZoom(toZoom);
    }

    public long getToZoom(long zoom) {
        long toZoom = zoom;
        TileReprojectionZoom config = this.getConfig(zoom);
        if (config != null && config.hasToZoom()) {
            toZoom = config.getToZoom();
        }
        return toZoom;
    }

    public void setTileWidth(long zoom, long tileWidth) {
        this.getConfigOrCreate(zoom).setTileWidth(tileWidth);
    }

    public Long getTileWidth(long zoom) {
        Long tileWidth = this.tileWidth;
        TileReprojectionZoom config = this.getConfig(zoom);
        if (config != null && config.hasTileWidth()) {
            tileWidth = config.getTileWidth();
        }
        return tileWidth;
    }

    public void setTileHeight(long zoom, long tileHeight) {
        this.getConfigOrCreate(zoom).setTileHeight(tileHeight);
    }

    public Long getTileHeight(long zoom) {
        Long tileHeight = this.tileHeight;
        TileReprojectionZoom config = this.getConfig(zoom);
        if (config != null && config.hasTileHeight()) {
            tileHeight = config.getTileHeight();
        }
        return tileHeight;
    }

    public void setMatrixWidth(long zoom, long matrixWidth) {
        this.getConfigOrCreate(zoom).setMatrixWidth(matrixWidth);
    }

    public Long getMatrixWidth(long zoom) {
        Long matrixWidth = null;
        TileReprojectionZoom config = this.getConfig(zoom);
        if (config != null && config.hasMatrixWidth()) {
            matrixWidth = config.getMatrixWidth();
        }
        return matrixWidth;
    }

    public void setMatrixHeight(long zoom, long matrixHeight) {
        this.getConfigOrCreate(zoom).setMatrixHeight(matrixHeight);
    }

    public Long getMatrixHeight(long zoom) {
        Long matrixHeight = null;
        TileReprojectionZoom config = this.getConfig(zoom);
        if (config != null && config.hasMatrixHeight()) {
            matrixHeight = config.getMatrixHeight();
        }
        return matrixHeight;
    }

    protected void initialize() {
        if (this.reprojectTileDao == null) {
            SpatialReferenceSystem srs;
            BoundingBox boundingBox;
            BoundingBox contentsBoundingBox = boundingBox = this.tileDao.getBoundingBox(this.projection);
            try {
                srs = this.geoPackage.getSpatialReferenceSystemDao().getOrCreate(this.projection);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create Spatial Reference System for projection. Authority: " + this.projection.getAuthority() + ", Code: " + this.projection.getCode(), e);
            }
            if (this.tileDao.getDatabase().equals(this.geoPackage.getName()) && this.tileDao.getTableName().equalsIgnoreCase(this.table)) {
                int count = 1;
                String tempTable = this.table + "_" + ++count;
                while (SQLiteMaster.count(this.tileDao.getDb(), SQLiteMasterQuery.create(SQLiteMasterColumn.NAME, tempTable)) > 0) {
                    tempTable = this.table + "_" + ++count;
                }
                this.table = tempTable;
                this.replace = true;
            }
            if (this.optimize != null) {
                boundingBox = this.optimize(boundingBox);
            }
            TileTable tileTable = null;
            if (this.geoPackage.isTable(this.table)) {
                if (!this.geoPackage.isTileTable(this.table)) {
                    throw new GeoPackageException("Table exists and is not a tile table: " + this.table);
                }
                this.reprojectTileDao = this.createReprojectTileDao(this.table);
                if (!this.reprojectTileDao.getProjection().equals((Object)this.projection)) {
                    throw new GeoPackageException("Existing tile table projection differs from the reprojection. Table: " + this.table + ", Projection: " + this.projection + ", Reprojection: " + this.reprojectTileDao.getProjection());
                }
                TileMatrixSet tileMatrixSet = this.getTileMatrixSet(true);
                List<TileMatrix> tileMatrices = this.getTileMatrices(true);
                if (tileMatrices.size() > 0) {
                    TileMatrix tileMatrix = tileMatrices.get(0);
                    if (Math.abs(tileMatrixSet.getMinX() - boundingBox.getMinLongitude()) > tileMatrix.getPixelXSize() || Math.abs(tileMatrixSet.getMinY() - boundingBox.getMinLatitude()) > tileMatrix.getPixelYSize() || Math.abs(tileMatrixSet.getMaxX() - boundingBox.getMaxLongitude()) > tileMatrix.getPixelXSize() || Math.abs(tileMatrixSet.getMaxY() - boundingBox.getMaxLatitude()) > tileMatrix.getPixelYSize()) {
                        if (!this.overwrite) {
                            throw new GeoPackageException("Existing Tile Matrix Set Geographic Properties differ. Enable 'overwrite' to replace all tiles. GeoPackage: " + this.reprojectTileDao.getDatabase() + ", Tile Table: " + this.reprojectTileDao.getTableName());
                        }
                        this.deleteTileMatrices(true, this.table);
                        this.reprojectTileDao.deleteAll();
                    }
                }
                Contents contents = this.reprojectTileDao.getContents();
                contents.setSrs(srs);
                contents.setMinX(contentsBoundingBox.getMinLongitude());
                contents.setMinY(contentsBoundingBox.getMinLatitude());
                contents.setMaxX(contentsBoundingBox.getMaxLongitude());
                contents.setMaxY(contentsBoundingBox.getMaxLatitude());
                try {
                    this.geoPackage.getContentsDao().update(contents);
                }
                catch (SQLException e) {
                    throw new GeoPackageException("Failed to update reprojection tile table contents. GeoPackage: " + this.reprojectTileDao.getDatabase() + ", Table: " + this.reprojectTileDao.getTableName(), e);
                }
                tileMatrixSet.setSrs(srs);
                tileMatrixSet.setMinX(boundingBox.getMinLongitude());
                tileMatrixSet.setMinY(boundingBox.getMinLatitude());
                tileMatrixSet.setMaxX(boundingBox.getMaxLongitude());
                tileMatrixSet.setMaxY(boundingBox.getMaxLatitude());
                try {
                    this.geoPackage.getTileMatrixSetDao().update(tileMatrixSet);
                }
                catch (SQLException e) {
                    throw new GeoPackageException("Failed to update reprojection tile matrix set. GeoPackage: " + this.reprojectTileDao.getDatabase() + ", Table: " + this.reprojectTileDao.getTableName(), e);
                }
            }
            tileTable = this.geoPackage.createTileTable(TileTableMetadata.create(this.table, contentsBoundingBox, boundingBox, srs.getSrsId()));
            this.reprojectTileDao = this.createReprojectTileDao(tileTable.getTableName());
        }
    }

    protected void finish() {
        boolean active = this.isActive();
        if (this.replace) {
            if (active) {
                this.geoPackage.deleteTable(this.tileDao.getTableName());
                this.geoPackage.copyTable(this.reprojectTileDao.getTableName(), this.tileDao.getTableName());
                this.geoPackage.deleteTable(this.reprojectTileDao.getTableName());
                this.reprojectTileDao = null;
            }
            this.table = this.tileDao.getTableName();
            this.replace = false;
        }
        if (this.progress != null && !active && this.progress.cleanupOnCancel()) {
            if (this.geoPackage == null) {
                throw new GeoPackageException("Reprojeciton cleanup not supported when constructed without the GeoPackage. GeoPackage:" + this.reprojectTileDao.getDatabase() + ", Tile Table: " + this.reprojectTileDao.getTableName());
            }
            this.geoPackage.deleteTable(this.reprojectTileDao.getTableName());
        }
    }

    public int reproject() {
        this.initialize();
        int tiles = 0;
        for (TileMatrix tileMatrix : this.getTileMatrices(false)) {
            if (!this.isActive()) break;
            tiles += this.reprojectIfExists(tileMatrix.getZoomLevel());
        }
        this.finish();
        return tiles;
    }

    public int reproject(long minZoom, long maxZoom) {
        this.initialize();
        int tiles = 0;
        for (long zoom = minZoom; zoom <= maxZoom && this.isActive(); ++zoom) {
            tiles += this.reprojectIfExists(zoom);
        }
        this.finish();
        return tiles;
    }

    public int reproject(List<Long> zooms) {
        this.initialize();
        int tiles = 0;
        for (long zoom : zooms) {
            if (!this.isActive()) break;
            tiles += this.reprojectIfExists(zoom);
        }
        this.finish();
        return tiles;
    }

    public int reproject(long zoom) {
        this.initialize();
        int tiles = this.reprojectIfExists(zoom);
        this.finish();
        return tiles;
    }

    private int reprojectIfExists(long zoom) {
        int tiles = 0;
        TileMatrix tileMatrix = this.getTileMatrix(false, zoom);
        if (tileMatrix != null) {
            tiles = this.reproject(tileMatrix);
        }
        return tiles;
    }

    private int reproject(TileMatrix tileMatrix) {
        Long matrixHeight;
        Long matrixWidth;
        Long tileHeight;
        long zoom = tileMatrix.getZoomLevel();
        long toZoom = this.getToZoom(zoom);
        Long tileWidth = this.getTileWidth(zoom);
        if (tileWidth == null) {
            tileWidth = tileMatrix.getTileWidth();
        }
        if ((tileHeight = this.getTileHeight(zoom)) == null) {
            tileHeight = tileMatrix.getTileHeight();
        }
        if ((matrixWidth = this.getMatrixWidth(zoom)) == null) {
            matrixWidth = tileMatrix.getMatrixWidth();
        }
        if ((matrixHeight = this.getMatrixHeight(zoom)) == null) {
            matrixHeight = tileMatrix.getMatrixHeight();
        }
        BoundingBox boundingBox = this.reprojectTileDao.getBoundingBox();
        if (this.optimizeTileGrid != null) {
            toZoom = this.getMapZoom(false, tileMatrix);
            TileGrid tileGrid = TileBoundingBoxUtils.tileGridZoom(this.optimizeTileGrid, this.optimizeZoom, toZoom);
            matrixWidth = tileGrid.getWidth();
            matrixHeight = tileGrid.getHeight();
        }
        double pixelXSize = boundingBox.getLongitudeRange() / (double)matrixWidth.longValue() / (double)tileWidth.longValue();
        double pixelYSize = boundingBox.getLatitudeRange() / (double)matrixHeight.longValue() / (double)tileHeight.longValue();
        boolean saveTileMatrix = true;
        TileMatrix toTileMatrix = this.getTileMatrix(true, toZoom);
        if (toTileMatrix == null) {
            toTileMatrix = new TileMatrix();
            toTileMatrix.setContents(this.reprojectTileDao.getContents());
            toTileMatrix.setZoomLevel(toZoom);
        } else if (toTileMatrix.getMatrixHeight() != matrixHeight.longValue() || toTileMatrix.getMatrixWidth() != matrixWidth.longValue() || toTileMatrix.getTileHeight() != tileHeight.longValue() || toTileMatrix.getTileWidth() != tileWidth.longValue() || Math.abs(toTileMatrix.getPixelXSize() - pixelXSize) > 1.0E-11 || Math.abs(toTileMatrix.getPixelYSize() - pixelYSize) > 1.0E-11) {
            if (!this.overwrite) {
                throw new GeoPackageException("Existing Tile Matrix Geographic Properties differ. Enable 'overwrite' to replace existing tiles at zoom level " + toZoom + ". GeoPackage: " + this.reprojectTileDao.getDatabase() + ", Tile Table: " + this.reprojectTileDao.getTableName());
            }
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("zoom_level", toTileMatrix.getZoomLevel());
            this.reprojectTileDao.delete((Map<String, Object>)fieldValues);
        } else {
            saveTileMatrix = false;
        }
        if (saveTileMatrix) {
            toTileMatrix.setMatrixHeight(matrixHeight);
            toTileMatrix.setMatrixWidth(matrixWidth);
            toTileMatrix.setTileHeight(tileHeight);
            toTileMatrix.setTileWidth(tileWidth);
            toTileMatrix.setPixelXSize(pixelXSize);
            toTileMatrix.setPixelYSize(pixelYSize);
            this.createTileMatrix(toTileMatrix);
        }
        int tiles = this.reproject(zoom, toZoom, boundingBox, matrixWidth, matrixHeight, tileWidth, tileHeight);
        return tiles;
    }

    protected BoundingBox optimize(BoundingBox boundingBox) {
        if (this.optimize.isWorld()) {
            this.optimizeZoom = 0L;
            this.optimizeTileGrid = this.optimize.getTileGrid();
            boundingBox = this.optimize.getBoundingBox();
            GeometryTransform transform = GeometryTransform.create((Projection)this.optimize.getProjection(), (Projection)this.projection);
            if (!transform.isSameProjection()) {
                boundingBox = boundingBox.transform(transform);
            }
        } else {
            this.optimizeZoom = this.getOptimizeZoom();
            GeometryTransform transform = GeometryTransform.create((Projection)this.projection, (Projection)this.optimize.getProjection());
            if (!transform.isSameProjection()) {
                boundingBox = boundingBox.transform(transform);
            }
            this.optimizeTileGrid = this.optimize.getTileGrid(boundingBox, this.optimizeZoom);
            boundingBox = this.optimize.getBoundingBox(this.optimizeTileGrid, this.optimizeZoom);
            if (!transform.isSameProjection()) {
                boundingBox = boundingBox.transform(transform.getInverseTransformation());
            }
        }
        return boundingBox;
    }

    protected boolean isActive() {
        return this.progress == null || this.progress.isActive();
    }
}

