/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.metadata.reference;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.extension.metadata.reference.MetadataReference;

public class MetadataReferenceDao
extends GeoPackageDao<MetadataReference, Void> {
    public static MetadataReferenceDao create(GeoPackageCore geoPackage) {
        return MetadataReferenceDao.create(geoPackage.getDatabase());
    }

    public static MetadataReferenceDao create(GeoPackageCoreConnection db) {
        return (MetadataReferenceDao)((Object)GeoPackageDao.createDao(db, MetadataReference.class));
    }

    public MetadataReferenceDao(ConnectionSource connectionSource, Class<MetadataReference> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public int update(MetadataReference metadataReference) throws SQLException {
        UpdateBuilder ub = this.updateBuilder();
        ub.updateColumnValue("reference_scope", (Object)metadataReference.getReferenceScope().getValue());
        ub.updateColumnValue("table_name", (Object)metadataReference.getTableName());
        ub.updateColumnValue("column_name", (Object)metadataReference.getColumnName());
        ub.updateColumnValue("row_id_value", (Object)metadataReference.getRowIdValue());
        ub.updateColumnValue("timestamp", (Object)metadataReference.getTimestamp());
        this.setFkWhere((Where<MetadataReference, Void>)ub.where(), metadataReference.getFileId(), metadataReference.getParentId());
        PreparedUpdate update = ub.prepare();
        int updated = this.update(update);
        return updated;
    }

    public int delete(MetadataReference metadataReference) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        this.setFkWhere((Where<MetadataReference, Void>)db.where(), metadataReference.getFileId(), metadataReference.getParentId());
        int deleted = db.delete();
        return deleted;
    }

    public int deleteByMetadata(long fileId) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("md_file_id", (Object)fileId);
        int deleted = db.delete();
        return deleted;
    }

    public int removeMetadataParent(long parentId) throws SQLException {
        UpdateBuilder ub = this.updateBuilder();
        ub.updateColumnValue("md_parent_id", null);
        ub.where().eq("md_parent_id", (Object)parentId);
        PreparedUpdate update = ub.prepare();
        int updated = this.update(update);
        return updated;
    }

    public List<MetadataReference> queryByMetadata(long fileId, Long parentId) throws SQLException {
        QueryBuilder qb = this.queryBuilder();
        this.setFkWhere((Where<MetadataReference, Void>)qb.where(), fileId, parentId);
        List metadataReferences = qb.query();
        return metadataReferences;
    }

    public List<MetadataReference> queryByMetadata(long fileId) throws SQLException {
        QueryBuilder qb = this.queryBuilder();
        qb.where().eq("md_file_id", (Object)fileId);
        List metadataReferences = qb.query();
        return metadataReferences;
    }

    public List<MetadataReference> queryByMetadataParent(long parentId) throws SQLException {
        QueryBuilder qb = this.queryBuilder();
        qb.where().eq("md_parent_id", (Object)parentId);
        List metadataReferences = qb.query();
        return metadataReferences;
    }

    public List<MetadataReference> queryByTable(String tableName) throws SQLException {
        return this.queryForEq("table_name", tableName);
    }

    private void setFkWhere(Where<MetadataReference, Void> where, long fileId, Long parentId) throws SQLException {
        where.eq("md_file_id", (Object)fileId);
        if (parentId == null) {
            where.and().isNull("md_parent_id");
        } else {
            where.and().eq("md_parent_id", (Object)parentId);
        }
    }

    public int deleteByTableName(String tableName) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("table_name", (Object)tableName);
        PreparedDelete deleteQuery = db.prepare();
        int deleted = this.delete(deleteQuery);
        return deleted;
    }
}

