/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db.table;

import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.table.ConstraintType;

public abstract class Constraint
implements Comparable<Constraint> {
    public static final String CONSTRAINT = "CONSTRAINT";
    private String name;
    private ConstraintType type;
    private Integer order;

    protected Constraint(ConstraintType type) {
        this(type, null, null);
    }

    protected Constraint(ConstraintType type, String name) {
        this(type, name, null);
    }

    protected Constraint(ConstraintType type, Integer order) {
        this(type, null, order);
    }

    protected Constraint(ConstraintType type, String name, Integer order) {
        this.type = type;
        this.name = name;
        this.order = order;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConstraintType getType() {
        return this.type;
    }

    public void setType(ConstraintType type) {
        this.type = type;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    protected String buildNameSql() {
        Object sql = "";
        if (this.name != null) {
            sql = "CONSTRAINT " + CoreSQLUtils.quoteWrap(this.name) + " ";
        }
        return sql;
    }

    @Override
    public int compareTo(Constraint constraint) {
        return this.getOrder(this.order) - this.getOrder(constraint.order) <= 0 ? -1 : 1;
    }

    private int getOrder(Integer order) {
        return order != null ? order : Integer.MAX_VALUE;
    }

    public abstract String buildSql();

    public abstract Constraint copy();
}

