/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.rfc8032;

import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.Digest;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.digests.SHA512Digest;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.rfc7748.X25519;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.rfc7748.X25519Field;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.raw.Interleave;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.raw.Nat;

public abstract class Ed25519 {
    private static final byte[] DOM2_PREFIX = new byte[]{83, 105, 103, 69, 100, 50, 53, 53, 49, 57, 32, 110, 111, 32, 69, 100, 50, 53, 53, 49, 57, 32, 99, 111, 108, 108, 105, 115, 105, 111, 110, 115};
    private static final int[] P = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] L = new int[]{1559614445, 1477600026, -1560830762, 350157278, 0, 0, 0, 0x10000000};
    private static final int[] B_x = new int[]{52811034, 25909283, 8072341, 50637101, 13785486, 30858332, 20483199, 20966410, 43936626, 4379245};
    private static final int[] B_y = new int[]{40265304, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC, 0x2666666, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC};
    private static final int[] C_d = new int[]{56195235, 47411844, 25868126, 40503822, 57364, 58321048, 30416477, 31930572, 57760639, 10749657};
    private static final int[] C_d2 = new int[]{45281625, 27714825, 18181821, 0xD4141D, 114729, 49533232, 60832955, 30306712, 48412415, 4722099};
    private static final int[] C_d4 = new int[]{23454386, 55429651, 2809210, 27797563, 229458, 31957600, 54557047, 27058993, 29715967, 9444199};
    private static final Object precompLock = new Object();
    private static PointExt[] precompBaseTable = null;
    private static int[] precompBase = null;

    private static int checkPoint(int[] nArray, int[] nArray2) {
        int[] nArray3 = F.create();
        int[] nArray4 = F.create();
        int[] nArray5 = F.create();
        F.sqr(nArray, nArray4);
        F.sqr(nArray2, nArray5);
        F.mul(nArray4, nArray5, nArray3);
        F.sub(nArray5, nArray4, nArray5);
        F.mul(nArray3, C_d, nArray3);
        F.addOne(nArray3);
        F.sub(nArray3, nArray5, nArray3);
        F.normalize(nArray3);
        return F.isZero(nArray3);
    }

    private static int checkPoint(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = F.create();
        int[] nArray5 = F.create();
        int[] nArray6 = F.create();
        int[] nArray7 = F.create();
        F.sqr(nArray, nArray5);
        F.sqr(nArray2, nArray6);
        F.sqr(nArray3, nArray7);
        F.mul(nArray5, nArray6, nArray4);
        F.sub(nArray6, nArray5, nArray6);
        F.mul(nArray6, nArray7, nArray6);
        F.sqr(nArray7, nArray7);
        F.mul(nArray4, C_d, nArray4);
        F.add(nArray4, nArray7, nArray4);
        F.sub(nArray4, nArray6, nArray4);
        F.normalize(nArray4);
        return F.isZero(nArray4);
    }

    private static Digest createDigest() {
        return new SHA512Digest();
    }

    private static int decode32(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        n2 |= (byArray[++n] & 0xFF) << 8;
        n2 |= (byArray[++n] & 0xFF) << 16;
        return n2 |= byArray[++n] << 24;
    }

    private static void decode32(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            nArray[n2 + i] = Ed25519.decode32(byArray, n + i * 4);
        }
    }

    private static void decodeScalar(byte[] byArray, int n, int[] nArray) {
        Ed25519.decode32(byArray, n, nArray, 0, 8);
    }

    private static int encodePoint(PointAccum pointAccum, byte[] byArray, int n) {
        int[] nArray = F.create();
        int[] nArray2 = F.create();
        F.inv(pointAccum.z, nArray2);
        F.mul(pointAccum.x, nArray2, nArray);
        F.mul(pointAccum.y, nArray2, nArray2);
        F.normalize(nArray);
        F.normalize(nArray2);
        int n2 = Ed25519.checkPoint(nArray, nArray2);
        F.encode(nArray2, byArray, n);
        int n3 = n + 32 - 1;
        byArray[n3] = (byte)(byArray[n3] | (nArray[0] & 1) << 7);
        return n2;
    }

    public static void generatePublicKey(byte[] byArray, int n, byte[] byArray2, int n2) {
        Digest digest = Ed25519.createDigest();
        byte[] byArray3 = new byte[digest.getDigestSize()];
        digest.update(byArray, n, 32);
        digest.doFinal(byArray3, 0);
        byte[] byArray4 = new byte[32];
        Ed25519.pruneScalar(byArray3, 0, byArray4);
        Ed25519.scalarMultBaseEncoded(byArray4, byArray2, n2);
    }

    private static void pointAddVar(boolean bl, PointExt pointExt, PointExt pointExt2, PointExt pointExt3) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5 = F.create();
        int[] nArray6 = F.create();
        int[] nArray7 = F.create();
        int[] nArray8 = F.create();
        int[] nArray9 = F.create();
        int[] nArray10 = F.create();
        int[] nArray11 = F.create();
        int[] nArray12 = F.create();
        if (bl) {
            nArray4 = nArray8;
            nArray3 = nArray7;
            nArray2 = nArray11;
            nArray = nArray10;
        } else {
            nArray4 = nArray7;
            nArray3 = nArray8;
            nArray2 = nArray10;
            nArray = nArray11;
        }
        F.apm(pointExt.y, pointExt.x, nArray6, nArray5);
        F.apm(pointExt2.y, pointExt2.x, nArray3, nArray4);
        F.mul(nArray5, nArray7, nArray5);
        F.mul(nArray6, nArray8, nArray6);
        F.mul(pointExt.t, pointExt2.t, nArray7);
        F.mul(nArray7, C_d2, nArray7);
        F.mul(pointExt.z, pointExt2.z, nArray8);
        F.add(nArray8, nArray8, nArray8);
        F.apm(nArray6, nArray5, nArray12, nArray9);
        F.apm(nArray8, nArray7, nArray, nArray2);
        F.carry(nArray);
        F.mul(nArray9, nArray10, pointExt3.x);
        F.mul(nArray11, nArray12, pointExt3.y);
        F.mul(nArray10, nArray11, pointExt3.z);
        F.mul(nArray9, nArray12, pointExt3.t);
    }

    private static void pointAddPrecomp(PointPrecomp pointPrecomp, PointAccum pointAccum) {
        int[] nArray = F.create();
        int[] nArray2 = F.create();
        int[] nArray3 = F.create();
        int[] nArray4 = pointAccum.u;
        int[] nArray5 = F.create();
        int[] nArray6 = F.create();
        int[] nArray7 = pointAccum.v;
        F.apm(pointAccum.y, pointAccum.x, nArray2, nArray);
        F.mul(nArray, pointPrecomp.ymx_h, nArray);
        F.mul(nArray2, pointPrecomp.ypx_h, nArray2);
        F.mul(pointAccum.u, pointAccum.v, nArray3);
        F.mul(nArray3, pointPrecomp.xyd, nArray3);
        F.apm(nArray2, nArray, nArray7, nArray4);
        F.apm(pointAccum.z, nArray3, nArray6, nArray5);
        F.carry(nArray6);
        F.mul(nArray4, nArray5, pointAccum.x);
        F.mul(nArray6, nArray7, pointAccum.y);
        F.mul(nArray5, nArray6, pointAccum.z);
    }

    private static PointExt pointCopy(PointAccum pointAccum) {
        PointExt pointExt = new PointExt();
        F.copy(pointAccum.x, 0, pointExt.x, 0);
        F.copy(pointAccum.y, 0, pointExt.y, 0);
        F.copy(pointAccum.z, 0, pointExt.z, 0);
        F.mul(pointAccum.u, pointAccum.v, pointExt.t);
        return pointExt;
    }

    private static PointExt pointCopy(PointExt pointExt) {
        PointExt pointExt2 = new PointExt();
        Ed25519.pointCopy(pointExt, pointExt2);
        return pointExt2;
    }

    private static void pointCopy(PointExt pointExt, PointExt pointExt2) {
        F.copy(pointExt.x, 0, pointExt2.x, 0);
        F.copy(pointExt.y, 0, pointExt2.y, 0);
        F.copy(pointExt.z, 0, pointExt2.z, 0);
        F.copy(pointExt.t, 0, pointExt2.t, 0);
    }

    private static void pointDouble(PointAccum pointAccum) {
        int[] nArray = F.create();
        int[] nArray2 = F.create();
        int[] nArray3 = F.create();
        int[] nArray4 = pointAccum.u;
        int[] nArray5 = F.create();
        int[] nArray6 = F.create();
        int[] nArray7 = pointAccum.v;
        F.sqr(pointAccum.x, nArray);
        F.sqr(pointAccum.y, nArray2);
        F.sqr(pointAccum.z, nArray3);
        F.add(nArray3, nArray3, nArray3);
        F.apm(nArray, nArray2, nArray7, nArray6);
        F.add(pointAccum.x, pointAccum.y, nArray4);
        F.sqr(nArray4, nArray4);
        F.sub(nArray7, nArray4, nArray4);
        F.add(nArray3, nArray6, nArray5);
        F.carry(nArray5);
        F.mul(nArray4, nArray5, pointAccum.x);
        F.mul(nArray6, nArray7, pointAccum.y);
        F.mul(nArray5, nArray6, pointAccum.z);
    }

    private static void pointExtendXY(PointAccum pointAccum) {
        F.one(pointAccum.z);
        F.copy(pointAccum.x, 0, pointAccum.u, 0);
        F.copy(pointAccum.y, 0, pointAccum.v, 0);
    }

    private static void pointExtendXY(PointExt pointExt) {
        F.one(pointExt.z);
        F.mul(pointExt.x, pointExt.y, pointExt.t);
    }

    private static void pointLookup(int n, int n2, PointPrecomp pointPrecomp) {
        int n3 = n * 8 * 3 * 10;
        for (int i = 0; i < 8; ++i) {
            int n4 = (i ^ n2) - 1 >> 31;
            F.cmov(n4, precompBase, n3, pointPrecomp.ypx_h, 0);
            F.cmov(n4, precompBase, n3 += 10, pointPrecomp.ymx_h, 0);
            F.cmov(n4, precompBase, n3 += 10, pointPrecomp.xyd, 0);
            n3 += 10;
        }
    }

    private static PointExt[] pointPrecomputeVar(PointExt pointExt, int n) {
        PointExt pointExt2 = new PointExt();
        Ed25519.pointAddVar(false, pointExt, pointExt, pointExt2);
        PointExt[] pointExtArray = new PointExt[n];
        pointExtArray[0] = Ed25519.pointCopy(pointExt);
        for (int i = 1; i < n; ++i) {
            pointExtArray[i] = new PointExt();
            Ed25519.pointAddVar(false, pointExtArray[i - 1], pointExt2, pointExtArray[i]);
        }
        return pointExtArray;
    }

    private static void pointSetNeutral(PointAccum pointAccum) {
        F.zero(pointAccum.x);
        F.one(pointAccum.y);
        F.one(pointAccum.z);
        F.zero(pointAccum.u);
        F.one(pointAccum.v);
    }

    private static void pointSetNeutral(PointExt pointExt) {
        F.zero(pointExt.x);
        F.one(pointExt.y);
        F.one(pointExt.z);
        F.zero(pointExt.t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void precompute() {
        Object object = precompLock;
        synchronized (object) {
            if (precompBase != null) {
                return;
            }
            Object object2 = new PointExt();
            F.copy(B_x, 0, ((PointExt)object2).x, 0);
            F.copy(B_y, 0, ((PointExt)object2).y, 0);
            Ed25519.pointExtendXY((PointExt)object2);
            precompBaseTable = Ed25519.pointPrecomputeVar((PointExt)object2, 32);
            object2 = new PointAccum();
            F.copy(B_x, 0, ((PointAccum)object2).x, 0);
            F.copy(B_y, 0, ((PointAccum)object2).y, 0);
            Ed25519.pointExtendXY((PointAccum)object2);
            precompBase = F.createTable(192);
            int n = 0;
            for (int i = 0; i < 8; ++i) {
                int n2;
                int n3;
                int n4;
                PointExt[] pointExtArray = new PointExt[4];
                PointExt pointExt = new PointExt();
                Ed25519.pointSetNeutral(pointExt);
                for (int j = 0; j < 4; ++j) {
                    PointExt pointExt2 = Ed25519.pointCopy((PointAccum)object2);
                    Ed25519.pointAddVar(true, pointExt, pointExt2, pointExt);
                    Ed25519.pointDouble((PointAccum)object2);
                    pointExtArray[j] = Ed25519.pointCopy((PointAccum)object2);
                    if (i + j == 10) continue;
                    for (n4 = 1; n4 < 8; ++n4) {
                        Ed25519.pointDouble((PointAccum)object2);
                    }
                }
                PointExt[] pointExtArray2 = new PointExt[8];
                int n5 = 0;
                pointExtArray2[n5++] = pointExt;
                for (n4 = 0; n4 < 3; ++n4) {
                    n3 = 1 << n4;
                    n2 = 0;
                    while (n2 < n3) {
                        pointExtArray2[n5] = new PointExt();
                        Ed25519.pointAddVar(false, pointExtArray2[n5 - n3], pointExtArray[n4], pointExtArray2[n5]);
                        ++n2;
                        ++n5;
                    }
                }
                int[] nArray = F.createTable(8);
                int[] nArray2 = F.create();
                F.copy(pointExtArray2[0].z, 0, nArray2, 0);
                F.copy(nArray2, 0, nArray, 0);
                n2 = 0;
                while (++n2 < 8) {
                    F.mul(nArray2, pointExtArray2[n2].z, nArray2);
                    F.copy(nArray2, 0, nArray, n2 * 10);
                }
                F.add(nArray2, nArray2, nArray2);
                F.invVar(nArray2, nArray2);
                --n2;
                int[] nArray3 = F.create();
                while (n2 > 0) {
                    int n6 = n2--;
                    F.copy(nArray, n2 * 10, nArray3, 0);
                    F.mul(nArray3, nArray2, nArray3);
                    F.copy(nArray3, 0, nArray, n6 * 10);
                    F.mul(nArray2, pointExtArray2[n6].z, nArray2);
                }
                F.copy(nArray2, 0, nArray, 0);
                for (n3 = 0; n3 < 8; ++n3) {
                    PointExt pointExt3 = pointExtArray2[n3];
                    nArray3 = F.create();
                    int[] nArray4 = F.create();
                    F.copy(nArray, n3 * 10, nArray4, 0);
                    F.mul(pointExt3.x, nArray4, nArray3);
                    F.mul(pointExt3.y, nArray4, nArray4);
                    PointPrecomp pointPrecomp = new PointPrecomp();
                    F.apm(nArray4, nArray3, pointPrecomp.ypx_h, pointPrecomp.ymx_h);
                    F.mul(nArray3, nArray4, pointPrecomp.xyd);
                    F.mul(pointPrecomp.xyd, C_d4, pointPrecomp.xyd);
                    F.normalize(pointPrecomp.ypx_h);
                    F.normalize(pointPrecomp.ymx_h);
                    F.copy(pointPrecomp.ypx_h, 0, precompBase, n);
                    F.copy(pointPrecomp.ymx_h, 0, precompBase, n += 10);
                    F.copy(pointPrecomp.xyd, 0, precompBase, n += 10);
                    n += 10;
                }
            }
        }
    }

    private static void pruneScalar(byte[] byArray, int n, byte[] byArray2) {
        System.arraycopy(byArray, n, byArray2, 0, 32);
        byArray2[0] = (byte)(byArray2[0] & 0xF8);
        byArray2[31] = (byte)(byArray2[31] & 0x7F);
        byArray2[31] = (byte)(byArray2[31] | 0x40);
    }

    private static void scalarMultBase(byte[] byArray, PointAccum pointAccum) {
        Ed25519.precompute();
        int[] nArray = new int[8];
        Ed25519.decodeScalar(byArray, 0, nArray);
        Nat.cadd(8, ~nArray[0] & 1, nArray, L, nArray);
        Nat.shiftDownBit(8, nArray, 1);
        for (int i = 0; i < 8; ++i) {
            nArray[i] = Interleave.shuffle2(nArray[i]);
        }
        PointPrecomp pointPrecomp = new PointPrecomp();
        Ed25519.pointSetNeutral(pointAccum);
        int n = 28;
        while (true) {
            for (int i = 0; i < 8; ++i) {
                int n2 = nArray[i] >>> n;
                int n3 = n2 >>> 3 & 1;
                int n4 = (n2 ^ -n3) & 7;
                Ed25519.pointLookup(i, n4, pointPrecomp);
                F.cswap(n3, pointPrecomp.ypx_h, pointPrecomp.ymx_h);
                F.cnegate(n3, pointPrecomp.xyd);
                Ed25519.pointAddPrecomp(pointPrecomp, pointAccum);
            }
            if ((n -= 4) < 0) break;
            Ed25519.pointDouble(pointAccum);
        }
    }

    private static void scalarMultBaseEncoded(byte[] byArray, byte[] byArray2, int n) {
        PointAccum pointAccum = new PointAccum();
        Ed25519.scalarMultBase(byArray, pointAccum);
        if (0 == Ed25519.encodePoint(pointAccum, byArray2, n)) {
            throw new IllegalStateException();
        }
    }

    public static void scalarMultBaseYZ(X25519.Friend friend, byte[] byArray, int n, int[] nArray, int[] nArray2) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by X25519");
        }
        byte[] byArray2 = new byte[32];
        Ed25519.pruneScalar(byArray, n, byArray2);
        PointAccum pointAccum = new PointAccum();
        Ed25519.scalarMultBase(byArray2, pointAccum);
        if (0 == Ed25519.checkPoint(pointAccum.x, pointAccum.y, pointAccum.z)) {
            throw new IllegalStateException();
        }
        F.copy(pointAccum.y, 0, nArray, 0);
        F.copy(pointAccum.z, 0, nArray2, 0);
    }

    private static class F
    extends X25519Field {
    }

    private static class PointAccum {
        int[] x = F.create();
        int[] y = F.create();
        int[] z = F.create();
        int[] u = F.create();
        int[] v = F.create();

        private PointAccum() {
        }
    }

    private static class PointExt {
        int[] x = F.create();
        int[] y = F.create();
        int[] z = F.create();
        int[] t = F.create();

        private PointExt() {
        }
    }

    private static class PointPrecomp {
        int[] ypx_h = F.create();
        int[] ymx_h = F.create();
        int[] xyd = F.create();

        private PointPrecomp() {
        }
    }
}

