/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.websocket;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.websocket.CloseWebSocketFrame;
import com.linecorp.armeria.common.websocket.WebSocketCloseStatus;
import com.linecorp.armeria.common.websocket.WebSocketFrame;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.hash.Hashing;
import com.linecorp.armeria.server.websocket.WebSocketProtocolViolationException;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import java.util.Objects;

public final class WebSocketUtil {
    private static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final long DEFAULT_REQUEST_RESPONSE_TIMEOUT_MILLIS = 0L;
    public static final long DEFAULT_MAX_REQUEST_RESPONSE_LENGTH = 0L;
    public static final long DEFAULT_REQUEST_AUTO_ABORT_DELAY_MILLIS = 5000L;

    public static boolean isHttp1WebSocketUpgradeRequest(RequestHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return headers.method() == HttpMethod.GET && WebSocketUtil.containsValue(headers, (CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true) && WebSocketUtil.containsValue(headers, (CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
    }

    private static boolean containsValue(RequestHeaders headers, CharSequence name, CharSequence value, boolean ignoreCase) {
        Iterator<String> itr = headers.valueIterator(name);
        while (itr.hasNext()) {
            if (!WebSocketUtil.containsCommaSeparatedTrimmed(itr.next(), value, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCommaSeparatedTrimmed(CharSequence rawNext, CharSequence expected, boolean ignoreCase) {
        int begin = 0;
        if (ignoreCase) {
            int end = AsciiString.indexOf((CharSequence)rawNext, (char)',', (int)begin);
            if (end == -1) {
                if (AsciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.trim((CharSequence)rawNext), (CharSequence)expected)) {
                    return true;
                }
            } else {
                do {
                    if (!AsciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.trim((CharSequence)rawNext.subSequence(begin, end)), (CharSequence)expected)) continue;
                    return true;
                } while ((end = AsciiString.indexOf((CharSequence)rawNext, (char)',', (int)(begin = end + 1))) != -1);
                if (begin < rawNext.length() && AsciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.trim((CharSequence)rawNext.subSequence(begin, rawNext.length())), (CharSequence)expected)) {
                    return true;
                }
            }
        } else {
            int end = AsciiString.indexOf((CharSequence)rawNext, (char)',', (int)begin);
            if (end == -1) {
                if (AsciiString.contentEquals((CharSequence)AsciiString.trim((CharSequence)rawNext), (CharSequence)expected)) {
                    return true;
                }
            } else {
                do {
                    if (!AsciiString.contentEquals((CharSequence)AsciiString.trim((CharSequence)rawNext.subSequence(begin, end)), (CharSequence)expected)) continue;
                    return true;
                } while ((end = AsciiString.indexOf((CharSequence)rawNext, (char)',', (int)(begin = end + 1))) != -1);
                if (begin < rawNext.length() && AsciiString.contentEquals((CharSequence)AsciiString.trim((CharSequence)rawNext.subSequence(begin, rawNext.length())), (CharSequence)expected)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isHttp2WebSocketUpgradeRequest(RequestHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return headers.method() == HttpMethod.CONNECT && WebSocketUtil.containsValue(headers, (CharSequence)HttpHeaderNames.PROTOCOL, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
    }

    public static String generateSecWebSocketAccept(String webSocketKey) {
        String acceptSeed = webSocketKey + MAGIC_GUID;
        byte[] sha1 = Hashing.sha1().hashBytes(acceptSeed.getBytes(StandardCharsets.US_ASCII)).asBytes();
        return Base64.getEncoder().encodeToString(sha1);
    }

    static int byteAtIndex(int mask, int index) {
        return mask >> 8 * (3 - index) & 0xFF;
    }

    public static CloseWebSocketFrame newCloseWebSocketFrame(Throwable cause) {
        WebSocketCloseStatus closeStatus = cause instanceof WebSocketProtocolViolationException ? ((WebSocketProtocolViolationException)cause).closeStatus() : WebSocketCloseStatus.INTERNAL_SERVER_ERROR;
        String reasonPhrase = WebSocketUtil.maybeTruncate(cause.getMessage());
        if (reasonPhrase == null) {
            reasonPhrase = closeStatus.reasonPhrase();
        }
        return WebSocketFrame.ofClose(closeStatus, reasonPhrase);
    }

    @Nullable
    public static String maybeTruncate(@Nullable String message) {
        if (Strings.isNullOrEmpty(message)) {
            return null;
        }
        if (message.length() <= 125) {
            return message;
        }
        return message.substring(0, 111) + "...(truncated)";
    }

    private WebSocketUtil() {
    }
}

