/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.util.HttpTimestampSupplier;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.AsciiString;

public final class HttpHeadersUtil {
    public static final String CLOSE_STRING = HttpHeaderValues.CLOSE.toString();

    public static ResponseHeaders mergeResponseHeaders(ResponseHeaders headers, HttpHeaders additionalHeaders, HttpHeaders defaultHeaders, boolean serverHeaderEnabled, boolean dateHeaderEnabled) {
        if (additionalHeaders.isEmpty() && defaultHeaders.isEmpty() && !serverHeaderEnabled && !dateHeaderEnabled) {
            return headers;
        }
        ResponseHeadersBuilder builder = headers.toBuilder();
        for (AsciiString name : additionalHeaders.names()) {
            if (HttpHeadersUtil.isPseudoHeader(name)) continue;
            builder.remove((CharSequence)name);
            additionalHeaders.forEachValue((CharSequence)name, value -> builder.add((CharSequence)name, (String)value));
        }
        for (AsciiString name : defaultHeaders.names()) {
            if (HttpHeadersUtil.isPseudoHeader(name) || builder.contains((CharSequence)name)) continue;
            defaultHeaders.forEachValue((CharSequence)name, value -> builder.add((CharSequence)name, (String)value));
        }
        if (serverHeaderEnabled && !builder.contains((CharSequence)HttpHeaderNames.SERVER)) {
            builder.add((CharSequence)HttpHeaderNames.SERVER, ArmeriaHttpUtil.SERVER_HEADER);
        }
        if (dateHeaderEnabled && !builder.contains((CharSequence)HttpHeaderNames.DATE)) {
            builder.add((CharSequence)HttpHeaderNames.DATE, HttpTimestampSupplier.currentTime());
        }
        return builder.build();
    }

    public static RequestHeaders mergeRequestHeaders(RequestHeaders headers, HttpHeaders defaultHeaders, HttpHeaders additionalHeaders, HttpHeaders internalHeaders) {
        Object authority0;
        if (defaultHeaders.isEmpty() && additionalHeaders.isEmpty() && internalHeaders.isEmpty() && headers.contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
            return headers;
        }
        if (defaultHeaders.isEmpty() && additionalHeaders.isEmpty()) {
            boolean containAllInternalHeaders = true;
            for (AsciiString name : internalHeaders.names()) {
                if (headers.contains((CharSequence)name)) continue;
                containAllInternalHeaders = false;
                break;
            }
            if (containAllInternalHeaders) {
                return headers;
            }
        }
        RequestHeadersBuilder builder = headers.toBuilder();
        String authority = additionalHeaders.get((CharSequence)HttpHeaderNames.AUTHORITY);
        if (authority == null) {
            authority = additionalHeaders.get((CharSequence)HttpHeaderNames.HOST);
        }
        if (authority != null) {
            builder.authority(authority);
        }
        for (AsciiString name : additionalHeaders.names()) {
            if (name.equals((Object)HttpHeaderNames.AUTHORITY) || name.equals((Object)HttpHeaderNames.HOST) || ArmeriaHttpUtil.ADDITIONAL_REQUEST_HEADER_DISALLOWED_LIST.contains(name)) continue;
            builder.remove((CharSequence)name);
            additionalHeaders.forEachValue((CharSequence)name, value -> builder.add((CharSequence)name, (String)value));
        }
        if (builder.authority() == null) {
            authority0 = defaultHeaders.get((CharSequence)HttpHeaderNames.AUTHORITY);
            if (authority0 == null) {
                authority0 = defaultHeaders.get((CharSequence)HttpHeaderNames.HOST);
            }
            if (authority0 != null) {
                builder.authority((String)authority0);
            }
        }
        for (AsciiString name : defaultHeaders.names()) {
            if (name.equals((Object)HttpHeaderNames.AUTHORITY) || name.equals((Object)HttpHeaderNames.HOST) || ArmeriaHttpUtil.ADDITIONAL_REQUEST_HEADER_DISALLOWED_LIST.contains(name) || builder.contains((CharSequence)name)) continue;
            defaultHeaders.forEachValue((CharSequence)name, value -> builder.add((CharSequence)name, (String)value));
        }
        if (builder.authority() == null) {
            authority0 = internalHeaders.get((CharSequence)HttpHeaderNames.AUTHORITY);
            if (authority0 == null) {
                authority0 = internalHeaders.get((CharSequence)HttpHeaderNames.HOST);
            }
            if (authority0 != null) {
                builder.authority((String)authority0);
            }
        }
        for (AsciiString name : internalHeaders.names()) {
            if (name.equals((Object)HttpHeaderNames.AUTHORITY) || name.equals((Object)HttpHeaderNames.HOST) || ArmeriaHttpUtil.ADDITIONAL_REQUEST_HEADER_DISALLOWED_LIST.contains(name) || builder.contains((CharSequence)name)) continue;
            internalHeaders.forEachValue((CharSequence)name, value -> builder.add((CharSequence)name, (String)value));
        }
        return builder.build();
    }

    public static HttpHeaders mergeTrailers(HttpHeaders headers, HttpHeaders additionalTrailers) {
        if (additionalTrailers.isEmpty()) {
            return headers;
        }
        if (headers.isEmpty()) {
            return additionalTrailers;
        }
        HttpHeadersBuilder builder = headers.toBuilder();
        for (AsciiString name : additionalTrailers.names()) {
            if (HttpHeadersUtil.isPseudoHeader(name) || ArmeriaHttpUtil.isTrailerDisallowed(name)) continue;
            builder.remove((CharSequence)name);
            additionalTrailers.forEachValue((CharSequence)name, value -> builder.add((CharSequence)name, (String)value));
        }
        return builder.build();
    }

    public static String getScheme(SessionProtocol sessionProtocol) {
        if (sessionProtocol.isHttps()) {
            return "https";
        }
        if (sessionProtocol.isHttp()) {
            return "http";
        }
        throw new IllegalArgumentException("sessionProtocol: " + (Object)((Object)sessionProtocol) + " (expected: HTTPS, H2, H1, HTTP, H2C or H1C)");
    }

    public static boolean isPseudoHeader(AsciiString name) {
        return !name.isEmpty() && name.charAt(0) == ':';
    }

    private HttpHeadersUtil() {
    }
}

