/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.util.BlockingTaskExecutorBuilder;
import com.linecorp.armeria.common.util.DefaultBlockingTaskExecutor;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;

public interface BlockingTaskExecutor
extends ScheduledExecutorService {
    public static BlockingTaskExecutor of() {
        return CommonPools.blockingTaskExecutor();
    }

    public static BlockingTaskExecutor of(ScheduledExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof BlockingTaskExecutor) {
            return (BlockingTaskExecutor)executor;
        }
        return new DefaultBlockingTaskExecutor(executor);
    }

    public static BlockingTaskExecutorBuilder builder() {
        return new BlockingTaskExecutorBuilder();
    }

    default public ScheduledExecutorService unwrap() {
        return this;
    }
}

