/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.CacheControl;
import com.linecorp.armeria.common.ContentDisposition;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.StringUtil;
import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.ValueConverter;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

final class StringValueConverter
implements ValueConverter<String> {
    static final StringValueConverter INSTANCE = new StringValueConverter();

    private StringValueConverter() {
    }

    @Nullable
    public String convertObject(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence || value instanceof Number || value instanceof MediaType) {
            return value.toString();
        }
        if (value instanceof Instant) {
            return DateFormatter.format((Date)new Date(((Instant)value).toEpochMilli()));
        }
        if (value instanceof TemporalAccessor) {
            return DateFormatter.format((Date)new Date(Instant.from((TemporalAccessor)value).toEpochMilli()));
        }
        if (value instanceof CacheControl) {
            return ((CacheControl)value).asHeaderValue();
        }
        if (value instanceof ContentDisposition) {
            return ((ContentDisposition)value).asHeaderValue();
        }
        if (value instanceof Date) {
            return DateFormatter.format((Date)((Date)value));
        }
        if (value instanceof Calendar) {
            return DateFormatter.format((Date)((Calendar)value).getTime());
        }
        return value.toString();
    }

    public String convertInt(int value) {
        return StringUtil.toString(value);
    }

    public String convertLong(long value) {
        return StringUtil.toString(value);
    }

    public String convertDouble(double value) {
        return String.valueOf(value);
    }

    public String convertChar(char value) {
        return String.valueOf(value);
    }

    public String convertBoolean(boolean value) {
        return String.valueOf(value);
    }

    public String convertFloat(float value) {
        return String.valueOf(value);
    }

    public boolean convertToBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    public String convertByte(byte value) {
        return StringUtil.toString(value & 0xFF);
    }

    public byte convertToByte(String value) {
        if (!value.isEmpty()) {
            return (byte)value.charAt(0);
        }
        return Byte.parseByte(value);
    }

    public char convertToChar(String value) {
        return value.charAt(0);
    }

    public String convertShort(short value) {
        return StringUtil.toString(value);
    }

    public short convertToShort(String value) {
        return Short.valueOf(value);
    }

    public int convertToInt(String value) {
        return Integer.parseInt(value);
    }

    public long convertToLong(String value) {
        return Long.parseLong(value);
    }

    public String convertTimeMillis(long value) {
        return DateFormatter.format((Date)new Date(value));
    }

    public long convertToTimeMillis(String value) {
        Date date = null;
        try {
            date = DateFormatter.parseHttpDate((CharSequence)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            throw new IllegalArgumentException("not a date: " + value);
        }
        return date.getTime();
    }

    public float convertToFloat(String value) {
        return Float.valueOf(value).floatValue();
    }

    public double convertToDouble(String value) {
        return Double.valueOf(value);
    }
}

