/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.redirect;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.redirect.RedirectConfigBuilder;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Set;
import java.util.function.BiPredicate;

@UnstableApi
public final class RedirectConfig {
    private static final RedirectConfig defaultRedirectConfig = RedirectConfig.builder().build();
    private static final RedirectConfig disabledRedirectConfig = new RedirectConfig(null, (ctx, path) -> false, -1);
    @Nullable
    private final Set<SessionProtocol> allowedProtocols;
    @Nullable
    private final BiPredicate<ClientRequestContext, String> domainFilter;
    private final int maxRedirects;

    public static RedirectConfig of() {
        return defaultRedirectConfig;
    }

    public static RedirectConfig disabled() {
        return disabledRedirectConfig;
    }

    public static RedirectConfigBuilder builder() {
        return new RedirectConfigBuilder();
    }

    RedirectConfig(@Nullable Set<SessionProtocol> allowedProtocols, @Nullable BiPredicate<ClientRequestContext, String> domainFilter, int maxRedirects) {
        this.allowedProtocols = allowedProtocols;
        this.domainFilter = domainFilter;
        this.maxRedirects = maxRedirects;
    }

    @Nullable
    public Set<SessionProtocol> allowedProtocols() {
        return this.allowedProtocols;
    }

    @Nullable
    public BiPredicate<ClientRequestContext, String> domainFilter() {
        return this.domainFilter;
    }

    public int maxRedirects() {
        return this.maxRedirects;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("allowedProtocols", this.allowedProtocols).add("predicate", this.domainFilter).add("maxRedirects", this.maxRedirects).toString();
    }
}

