/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.io.IOException;
import org.apache.hadoop.yarn.nodelabels.AttributeExpressionOperation;
import org.apache.hadoop.yarn.nodelabels.AttributeValue;
import org.apache.hadoop.yarn.nodelabels.NodeLabelUtil;

public class StringAttributeValue
implements AttributeValue {
    private String value = "";

    @Override
    public boolean compareForOperation(AttributeValue other, AttributeExpressionOperation op) {
        if (other instanceof StringAttributeValue) {
            StringAttributeValue otherString = (StringAttributeValue)other;
            switch (op) {
                case IN: {
                    return this.value.equals(otherString.value);
                }
                case NOTIN: {
                    return !this.value.equals(otherString.value);
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void validateAndInitializeValue(String valueStr) throws IOException {
        NodeLabelUtil.checkAndThrowAttributeValue(valueStr);
        this.value = valueStr;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

