/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.internal.CheckedArrayList;
import org.apache.sis.util.internal.CodeLists;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.CodeList;

public class CodeListSet<E extends CodeList<E>>
extends AbstractSet<E>
implements CheckedContainer<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6328082298556260980L;
    private static final WeakHashSet<CodeList[]> POOL = new WeakHashSet<CodeList[]>(CodeList[].class);
    private final Class<E> elementType;
    private long values;
    private BitSet supplementary;
    private transient E[] codes;

    public CodeListSet(Class<E> elementType) throws IllegalArgumentException {
        if (!Modifier.isFinal(elementType.getModifiers())) {
            throw new IllegalArgumentException(Errors.format((short)19, elementType));
        }
        this.elementType = elementType;
    }

    public CodeListSet(Class<E> elementType, boolean fill) throws IllegalArgumentException {
        this(elementType);
        if (fill) {
            this.codes = POOL.unique(CodeLists.values(elementType));
            int n = this.codes.length;
            if (n < 64) {
                this.values = (1L << n) - 1L;
            } else {
                this.values = -1L;
                if ((n -= 64) != 0) {
                    this.supplementary = new BitSet(n);
                    this.supplementary.set(0, n);
                }
            }
        }
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }

    final E valueOf(int ordinal) {
        Object[] array = this.codes;
        if (array == null || ordinal >= array.length) {
            this.codes = array = POOL.unique(CodeLists.values(this.elementType));
        }
        return array[ordinal];
    }

    @Override
    public void clear() {
        this.values = 0L;
        BitSet s = this.supplementary;
        if (s != null) {
            s.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        BitSet s;
        return this.values == 0L && ((s = this.supplementary) == null || s.isEmpty());
    }

    @Override
    public int size() {
        int n = Long.bitCount(this.values);
        BitSet s = this.supplementary;
        if (s != null) {
            n += s.cardinality();
        }
        return n;
    }

    @Override
    public boolean add(E element) {
        if (element == null) {
            String message = CheckedArrayList.illegalElement(this, element, this.elementType);
            if (message == null) {
                return false;
            }
            throw new NullArgumentException(message);
        }
        int ordinal = element.ordinal();
        if (ordinal < 64) {
            return (this.values |= 1L << ordinal) != this.values;
        }
        BitSet s = this.supplementary;
        if (s == null) {
            this.supplementary = s = new BitSet();
        }
        if (s.get(ordinal -= 64)) {
            return false;
        }
        s.set(ordinal);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        if (this.elementType.isInstance(object)) {
            return this.clear(((CodeList)object).ordinal());
        }
        return false;
    }

    final boolean clear(int ordinal) {
        if (ordinal < 64) {
            return (this.values &= 1L << ordinal ^ 0xFFFFFFFFFFFFFFFFL) != this.values;
        }
        BitSet s = this.supplementary;
        if (s != null && s.get(ordinal -= 64)) {
            s.clear(ordinal);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        if (this.elementType.isInstance(object)) {
            int ordinal = ((CodeList)object).ordinal();
            if (ordinal < 64) {
                return (this.values & 1L << ordinal) != 0L;
            }
            BitSet s = this.supplementary;
            if (s != null) {
                return s.get(ordinal - 64);
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof CodeListSet) {
            CodeListSet o = (CodeListSet)c;
            if (this.elementType == o.elementType && this.values == (this.values | o.values)) {
                BitSet s = this.supplementary;
                BitSet os = o.supplementary;
                if ((s == null || s.isEmpty()) && (os == null || os.isEmpty())) {
                    return true;
                }
                if (s != null && os != null) {
                    BitSet tmp = (BitSet)os.clone();
                    tmp.andNot(s);
                    return tmp.isEmpty();
                }
            }
            return false;
        }
        return super.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) throws IllegalArgumentException {
        if (c instanceof CodeListSet) {
            CodeListSet o = (CodeListSet)c;
            assert (this.elementType.isAssignableFrom(o.elementType));
            boolean changed = (this.values |= o.values) != this.values;
            BitSet os = o.supplementary;
            if (os != null) {
                BitSet s = this.supplementary;
                if (s == null) {
                    if (!os.isEmpty()) {
                        this.supplementary = (BitSet)os.clone();
                        changed = true;
                    }
                } else if (changed) {
                    s.or(os);
                } else {
                    int cardinality = s.cardinality();
                    s.or(os);
                    changed = cardinality != s.cardinality();
                }
            }
            return changed;
        }
        return super.addAll(c);
    }

    private long mask(CodeListSet<?> other) {
        return this.elementType == other.elementType ? other.values : 0L;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof CodeListSet) {
            BitSet os;
            boolean changed = (this.values &= this.mask((CodeListSet)c) ^ 0xFFFFFFFFFFFFFFFFL) != this.values;
            BitSet s = this.supplementary;
            if (s != null && (os = ((CodeListSet)c).supplementary) != null) {
                if (changed) {
                    s.andNot(os);
                } else {
                    int cardinality = s.cardinality();
                    s.andNot(os);
                    changed = cardinality != s.cardinality();
                }
            }
            return changed;
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof CodeListSet) {
            boolean changed = (this.values &= this.mask((CodeListSet)c)) != this.values;
            BitSet s = this.supplementary;
            if (s != null) {
                BitSet os = ((CodeListSet)c).supplementary;
                if (os == null) {
                    changed |= !s.isEmpty();
                    s.clear();
                } else if (changed) {
                    s.and(os);
                } else {
                    int cardinality = s.cardinality();
                    s.and(os);
                    changed = cardinality != s.cardinality();
                }
            }
            return changed;
        }
        return super.retainAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter(this.values, this.supplementary);
    }

    public CodeListSet<E> clone() {
        CodeListSet clone;
        try {
            clone = (CodeListSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        BitSet s = this.supplementary;
        if (s != null) {
            clone.supplementary = (BitSet)s.clone();
        }
        return clone;
    }

    private final class Iter
    implements Iterator<E> {
        private long remaining;
        private final BitSet more;
        private int last;

        Iter(long values, BitSet supplementary) {
            this.remaining = values;
            this.more = supplementary != null ? (BitSet)supplementary.clone() : null;
            this.last = -1;
        }

        @Override
        public boolean hasNext() {
            return this.remaining != 0L || this.more != null && !this.more.isEmpty();
        }

        @Override
        public E next() {
            int ordinal = Long.numberOfTrailingZeros(this.remaining);
            if (ordinal >= 64) {
                if (this.more == null || (ordinal = this.more.nextSetBit(0)) < 0) {
                    throw new NoSuchElementException();
                }
                this.more.clear(ordinal);
                ordinal += 64;
            }
            this.last = ordinal;
            this.remaining &= 1L << ordinal ^ 0xFFFFFFFFFFFFFFFFL;
            return CodeListSet.this.valueOf(ordinal);
        }

        @Override
        public void remove() {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            CodeListSet.this.clear(this.last);
            this.last = -1;
        }
    }
}

