/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.rpsl;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.baremaps.rpsl.RpslObject;

public class RpslUtils {
    private RpslUtils() {
    }

    public static boolean isInetnum(RpslObject object) {
        return "inetnum".equals(object.type()) || "inet6num".equals(object.type());
    }

    public static void writeToFile(Path path, RpslObject object) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        String fileName = object.type() + "-" + object.id() + ".txt";
        FileOutputStream fileOutputStream = new FileOutputStream(path + "/" + fileName);
        try (DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));){
            outStream.writeUTF(object.toString());
        }
    }
}

