/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.utils;

import com.google.common.io.Resources;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;

public final class SqliteUtils {
    private SqliteUtils() {
    }

    public static DataSource createDataSource(Path path, boolean readOnly) {
        SQLiteConfig sqliteConfig = new SQLiteConfig();
        sqliteConfig.setReadOnly(readOnly);
        sqliteConfig.setCacheSize(-1000000);
        sqliteConfig.setPageSize(65536);
        sqliteConfig.setJournalMode(SQLiteConfig.JournalMode.OFF);
        sqliteConfig.setLockingMode(SQLiteConfig.LockingMode.EXCLUSIVE);
        sqliteConfig.setSynchronous(SQLiteConfig.SynchronousMode.OFF);
        sqliteConfig.setTempStore(SQLiteConfig.TempStore.MEMORY);
        SQLiteDataSource sqliteDataSource = new SQLiteDataSource();
        sqliteDataSource.setConfig(sqliteConfig);
        sqliteDataSource.setUrl("jdbc:sqlite:" + path.toAbsolutePath());
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDataSource((DataSource)sqliteDataSource);
        hikariConfig.setMaximumPoolSize(readOnly ? Runtime.getRuntime().availableProcessors() : 1);
        return new HikariDataSource(hikariConfig);
    }

    public static void executeResource(String databaseUrl, String resource) throws IOException, SQLException {
        try (Connection connection = DriverManager.getConnection(databaseUrl);){
            URL resourceURL = Resources.getResource((String)resource);
            String queries = Resources.toString((URL)resourceURL, (Charset)StandardCharsets.UTF_8);
            try (Statement stmt = connection.createStatement();){
                stmt.executeUpdate(queries);
            }
        }
    }
}

