/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.sql.DataSource;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.postgres.openstreetmap.NodeRepository;
import org.apache.baremaps.postgres.openstreetmap.RelationRepository;
import org.apache.baremaps.postgres.openstreetmap.Repository;
import org.apache.baremaps.postgres.openstreetmap.RepositoryException;
import org.apache.baremaps.postgres.openstreetmap.WayRepository;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportDaylightFeatures
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ImportDaylightFeatures.class);
    private Path file;
    private Object database;

    public ImportDaylightFeatures() {
    }

    public ImportDaylightFeatures(Path file, Object database) {
        this.file = file;
        this.database = database;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        DataSource datasource = context.getDataSource(this.database);
        NodeRepository nodeRepository = new NodeRepository(datasource);
        WayRepository wayRepository = new WayRepository(datasource);
        RelationRepository relationRepository = new RelationRepository(datasource);
        nodeRepository.create();
        wayRepository.create();
        relationRepository.create();
        ObjectMapper objectMapper = new ObjectMapper();
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{Feature.class});
        List features = (List)objectMapper.readValue(this.file.toFile(), javaType);
        block10: for (Feature feature : features) {
            switch (feature.type()) {
                case "node": {
                    this.save(feature, (Repository)nodeRepository);
                    continue block10;
                }
                case "way": {
                    this.save(feature, (Repository)wayRepository);
                    continue block10;
                }
                case "relation": {
                    this.save(feature, (Repository)relationRepository);
                    continue block10;
                }
            }
            logger.warn("Unknown type: {}", (Object)feature.type());
        }
    }

    private <T extends Element> void save(Feature feature, Repository<Long, T> repository) throws RepositoryException {
        Element entity = (Element)repository.get((Object)feature.id());
        if (entity != null) {
            HashMap<String, Object> tags = new HashMap<String, Object>(feature.tags());
            if (entity.getTags() != null) {
                tags.putAll(entity.getTags());
            }
            entity.setTags(tags);
            repository.put((Object)entity);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ImportDaylightFeatures.class.getSimpleName() + "[", "]").add("file=" + this.file).add("database=" + this.database).toString();
    }

    record Feature(@JsonProperty(value="osm_type") String type, @JsonProperty(value="osm_id") Long id, @JsonProperty(value="tags") Map<String, Object> tags, @JsonProperty(value="wkt") String wkt, @JsonProperty(value="category") String category) {
    }
}

