/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geoparquet;

import org.apache.baremaps.geoparquet.GeoParquetGroup;
import org.apache.baremaps.geoparquet.GeoParquetPrimitiveConverter;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

class GeoParquetGroupConverter
extends GroupConverter {
    private final GeoParquetGroupConverter parent;
    private final int index;
    protected GeoParquetGroup current;
    private final Converter[] converters;

    GeoParquetGroupConverter(GeoParquetGroupConverter parent, int index, GroupType schema) {
        this.parent = parent;
        this.index = index;
        this.converters = new Converter[schema.getFieldCount()];
        for (int i = 0; i < this.converters.length; ++i) {
            Type type = schema.getType(i);
            this.converters[i] = type.isPrimitive() ? new GeoParquetPrimitiveConverter(this, i) : new GeoParquetGroupConverter(this, i, type.asGroupType());
        }
    }

    public void start() {
        this.current = this.parent.getCurrentRecord().addGroup(this.index);
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void end() {
        this.current = null;
    }

    public GeoParquetGroup getCurrentRecord() {
        return this.current;
    }
}

