/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.StringInputStream;
import software.amazon.awssdk.utils.Validate;

@FunctionalInterface
@SdkPublicApi
public interface ContentStreamProvider {
    public static ContentStreamProvider fromByteArray(byte[] bytes) {
        Validate.paramNotNull((Object)bytes, (String)"bytes");
        byte[] copy = Arrays.copyOf(bytes, bytes.length);
        return () -> new ByteArrayInputStream(copy);
    }

    public static ContentStreamProvider fromByteArrayUnsafe(byte[] bytes) {
        Validate.paramNotNull((Object)bytes, (String)"bytes");
        return () -> new ByteArrayInputStream(bytes);
    }

    public static ContentStreamProvider fromString(String string, Charset charset) {
        Validate.paramNotNull((Object)string, (String)"string");
        Validate.paramNotNull((Object)charset, (String)"charset");
        return () -> new StringInputStream(string, charset);
    }

    public static ContentStreamProvider fromUtf8String(String string) {
        return ContentStreamProvider.fromString(string, StandardCharsets.UTF_8);
    }

    public static ContentStreamProvider fromInputStream(final InputStream inputStream) {
        Validate.paramNotNull((Object)inputStream, (String)"inputStream");
        IoUtils.markStreamWithMaxReadLimit((InputStream)inputStream);
        return new ContentStreamProvider(){
            private boolean first = true;

            @Override
            public InputStream newStream() {
                if (this.first) {
                    this.first = false;
                    return inputStream;
                }
                if (inputStream.markSupported()) {
                    FunctionalUtils.invokeSafely(inputStream::reset);
                    return inputStream;
                }
                throw new IllegalStateException("Content input stream does not support mark/reset, and was already read once.");
            }
        };
    }

    public static ContentStreamProvider fromInputStreamSupplier(final Supplier<InputStream> inputStreamSupplier) {
        Validate.paramNotNull(inputStreamSupplier, (String)"inputStreamSupplier");
        return new ContentStreamProvider(){
            private InputStream lastStream;

            @Override
            public InputStream newStream() {
                if (this.lastStream != null) {
                    FunctionalUtils.invokeSafely(this.lastStream::close);
                }
                this.lastStream = (InputStream)inputStreamSupplier.get();
                return this.lastStream;
            }
        };
    }

    public InputStream newStream();
}

