/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import org.apache.iceberg.avro.AvroWithPartnerByStructureVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.Pair;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public abstract class AvroWithSparkSchemaVisitor<T>
extends AvroWithPartnerByStructureVisitor<DataType, T> {
    protected boolean isStringType(DataType dataType) {
        return dataType instanceof StringType;
    }

    protected boolean isMapType(DataType dataType) {
        return dataType instanceof MapType;
    }

    protected DataType arrayElementType(DataType arrayType) {
        Preconditions.checkArgument((boolean)(arrayType instanceof ArrayType), (String)"Invalid array: %s is not an array", (Object)arrayType);
        return ((ArrayType)arrayType).elementType();
    }

    protected DataType mapKeyType(DataType mapType) {
        Preconditions.checkArgument((boolean)this.isMapType(mapType), (String)"Invalid map: %s is not a map", (Object)mapType);
        return ((MapType)mapType).keyType();
    }

    protected DataType mapValueType(DataType mapType) {
        Preconditions.checkArgument((boolean)this.isMapType(mapType), (String)"Invalid map: %s is not a map", (Object)mapType);
        return ((MapType)mapType).valueType();
    }

    protected Pair<String, DataType> fieldNameAndType(DataType structType, int pos) {
        Preconditions.checkArgument((boolean)(structType instanceof StructType), (String)"Invalid struct: %s is not a struct", (Object)structType);
        StructField field = ((StructType)structType).apply(pos);
        return Pair.of((Object)field.name(), (Object)field.dataType());
    }

    protected DataType nullType() {
        return DataTypes.NullType;
    }
}

