/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.terminal.kyuubi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.amoro.server.terminal.JDBCResultSet;
import org.apache.amoro.server.terminal.TerminalSession;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;

public class KyuubiSession
implements TerminalSession {
    final List<String> logs = Lists.newArrayList();
    final Connection connection;
    private volatile String currentCatalog;
    Map<String, String> sessionConf;

    public KyuubiSession(Connection connection, List<String> logs, Map<String, String> sessionConf) {
        this.logs.addAll(logs);
        this.connection = connection;
        this.sessionConf = sessionConf;
    }

    @Override
    public Map<String, String> configs() {
        return this.sessionConf;
    }

    @Override
    public TerminalSession.ResultSet executeStatement(String catalog, String statement) {
        if (this.currentCatalog == null || !this.currentCatalog.equalsIgnoreCase(catalog)) {
            String useCatalog;
            if (TerminalSession.canUseSparkSessionCatalog(this.sessionConf, catalog)) {
                this.logs.add(String.format("current catalog is %s, since it's a hive type catalog and can use spark session catalog, switch to spark_catalog before execution", this.currentCatalog));
                useCatalog = "spark_catalog";
            } else {
                this.logs.add(String.format("current catalog is %s, switch to %s before execution", this.currentCatalog, catalog));
                useCatalog = catalog;
            }
            try {
                this.connection.setCatalog(useCatalog);
            }
            catch (SQLException e) {
                throw new RuntimeException(String.format("Failed to set catalog %s on the connection", useCatalog), e);
            }
            this.currentCatalog = catalog;
        }
        ResultSet rs = null;
        Statement sts = null;
        try {
            sts = this.connection.createStatement();
            boolean withRs = sts.execute(statement);
            if (withRs) {
                rs = sts.getResultSet();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("error when execute sql:" + statement, e);
        }
        return new JDBCResultSet(rs, sts);
    }

    @Override
    public synchronized List<String> logs() {
        ArrayList logs = Lists.newArrayList(this.logs);
        this.logs.clear();
        return logs;
    }

    @Override
    public boolean active() {
        try {
            this.execute("SELECT 1");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public void release() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            this.logs.add("error when release connection." + e);
        }
    }

    private void execute(String sql) {
        try (Statement sts = this.connection.createStatement();){
            sts.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException("error when execute sql:" + sql, e);
        }
    }
}

