/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.terminal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.amoro.server.terminal.TerminalSession;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;

public class JDBCResultSet
implements TerminalSession.ResultSet {
    private final ResultSet rs;
    private final Statement statement;
    private final List<String> columns = Lists.newArrayList();

    public JDBCResultSet(ResultSet rs, Statement sts) {
        this.rs = rs;
        this.statement = sts;
        if (rs != null) {
            try {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    String col = rs.getMetaData().getColumnName(i + 1);
                    this.columns.add(col);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<String> columns() {
        return this.columns;
    }

    @Override
    public boolean next() {
        try {
            return this.rs != null && this.rs.next();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object[] rowData() {
        Object[] rows = new Object[this.columns.size()];
        for (int i = 0; i < rows.length; ++i) {
            try {
                rows[i] = this.rs.getObject(i + 1);
                continue;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return rows;
    }

    @Override
    public boolean empty() {
        return this.columns.isEmpty();
    }

    @Override
    public void close() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

