/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.internal;

import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.internal.IcebergInternalTableOperations;
import org.apache.amoro.server.table.internal.InternalTableHandler;
import org.apache.amoro.server.utils.InternalTableUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.io.FileIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalIcebergHandler
implements InternalTableHandler<TableOperations> {
    private static final Logger LOG = LoggerFactory.getLogger(InternalIcebergHandler.class);
    private boolean closed = false;
    protected final AuthenticatedFileIO io;
    private final TableMetadata tableMetadata;

    public InternalIcebergHandler(CatalogMeta catalogMeta, TableMetadata metadata) {
        this.tableMetadata = metadata;
        this.io = InternalTableUtil.newIcebergFileIo(catalogMeta);
    }

    @Override
    public TableMetadata tableMetadata() {
        return this.tableMetadata;
    }

    @Override
    public TableOperations newTableOperator() {
        this.checkClosed();
        return new IcebergInternalTableOperations(this.tableMetadata.getTableIdentifier(), this.tableMetadata, (FileIO)this.io);
    }

    @Override
    public void dropTable(boolean purge) {
        this.checkClosed();
        if (purge) {
            this.purgeIceberg(this.newTableOperator());
        }
        if (purge && this.io.supportPrefixOperations()) {
            this.io.asPrefixFileIO().deletePrefix(this.tableMetadata.getTableLocation());
        }
    }

    protected void purgeIceberg(TableOperations ops) {
        org.apache.iceberg.TableMetadata current = null;
        try {
            current = ops.current();
        }
        catch (Exception e) {
            LOG.warn("failed to load iceberg table metadata, metadata file maybe lost: " + e.getMessage());
        }
        if (current != null) {
            CatalogUtil.dropTableData((FileIO)this.io, (org.apache.iceberg.TableMetadata)current);
        }
    }

    @Override
    public void close() {
        this.io.close();
        this.closed = true;
    }

    protected void checkClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)(this.getClass().getSimpleName() + " for table [" + this.tableMetadata.getTableIdentifier() + "] is closed"));
    }
}

