/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import org.apache.amoro.AmoroTable;
import org.apache.amoro.config.TableConfiguration;
import org.apache.amoro.server.optimizing.maintainer.TableMaintainer;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.table.executor.BaseTableExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotsExpiringExecutor
extends BaseTableExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotsExpiringExecutor.class);
    private static final long INTERVAL = 3600000L;

    public SnapshotsExpiringExecutor(TableService tableService, int poolSize) {
        super(tableService, poolSize);
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return 3600000L;
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return tableRuntime.getTableConfiguration().isExpireSnapshotEnabled();
    }

    @Override
    public void handleConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
        this.scheduleIfNecessary(tableRuntime, this.getStartDelay());
    }

    @Override
    public void execute(TableRuntime tableRuntime) {
        try {
            AmoroTable<?> amoroTable = this.loadTable(tableRuntime);
            TableMaintainer tableMaintainer = TableMaintainer.ofTable(amoroTable);
            tableMaintainer.expireSnapshots(tableRuntime);
        }
        catch (Throwable t) {
            LOG.error("unexpected expire error of table {} ", (Object)tableRuntime.getTableIdentifier(), (Object)t);
        }
    }
}

