/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.metrics.Gauge;
import org.apache.amoro.metrics.Metric;
import org.apache.amoro.metrics.MetricDefine;
import org.apache.amoro.optimizing.plan.AbstractOptimizingEvaluator;
import org.apache.amoro.server.metrics.MetricRegistry;
import org.apache.amoro.server.table.AbstractTableMetrics;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.UnkeyedTable;

public class TableSummaryMetrics
extends AbstractTableMetrics {
    public static final MetricDefine TABLE_SUMMARY_TOTAL_FILES = MetricDefine.defineGauge((String)"table_summary_total_files").withDescription("Total number of files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_DATA_FILES = MetricDefine.defineGauge((String)"table_summary_data_files").withDescription("Number of data files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_EQUALITY_DELETE_FILES = MetricDefine.defineGauge((String)"table_summary_equality_delete_files").withDescription("Number of equality delete files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_POSITION_DELETE_FILES = MetricDefine.defineGauge((String)"table_summary_position_delete_files").withDescription("Number of position delete files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_DANGLING_DELETE_FILES = MetricDefine.defineGauge((String)"table_summary_dangling_delete_files").withDescription("Number of dangling delete files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_TOTAL_FILES_SIZE = MetricDefine.defineGauge((String)"table_summary_total_files_size").withDescription("Total size of files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_DATA_FILES_SIZE = MetricDefine.defineGauge((String)"table_summary_data_files_size").withDescription("Size of data files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_EQUALITY_DELETE_FILES_SIZE = MetricDefine.defineGauge((String)"table_summary_equality_delete_files_size").withDescription("Size of equality delete files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_POSITION_DELETE_FILES_SIZE = MetricDefine.defineGauge((String)"table_summary_position_delete_files_size").withDescription("Size of position delete files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_TOTAL_RECORDS = MetricDefine.defineGauge((String)"table_summary_total_records").withDescription("Total records in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_DATA_FILES_RECORDS = MetricDefine.defineGauge((String)"table_summary_data_files_records").withDescription("Records of data files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_EQUALITY_DELETE_FILES_RECORDS = MetricDefine.defineGauge((String)"table_summary_equality_delete_files_records").withDescription("Records of equality delete files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_POSITION_DELETE_FILES_RECORDS = MetricDefine.defineGauge((String)"table_summary_position_delete_files_records").withDescription("Records of position delete files in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_SNAPSHOTS = MetricDefine.defineGauge((String)"table_summary_snapshots").withDescription("Number of snapshots in the table").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_SUMMARY_HEALTH_SCORE = MetricDefine.defineGauge((String)"table_summary_health_score").withDescription("Health score of the table").withTags(new String[]{"catalog", "database", "table"}).build();
    private AbstractOptimizingEvaluator.PendingInput tableSummary = new AbstractOptimizingEvaluator.PendingInput();
    private long snapshots = 0L;

    public TableSummaryMetrics(ServerTableIdentifier identifier) {
        super(identifier);
    }

    @Override
    public void registerMetrics(MetricRegistry registry) {
        if (this.globalRegistry == null) {
            this.registerMetric(registry, TABLE_SUMMARY_TOTAL_FILES, (Metric)((Gauge)() -> this.tableSummary.getTotalFileCount()));
            this.registerMetric(registry, TABLE_SUMMARY_DATA_FILES, (Metric)((Gauge)() -> this.tableSummary.getDataFileCount()));
            this.registerMetric(registry, TABLE_SUMMARY_POSITION_DELETE_FILES, (Metric)((Gauge)() -> this.tableSummary.getPositionalDeleteFileCount()));
            this.registerMetric(registry, TABLE_SUMMARY_EQUALITY_DELETE_FILES, (Metric)((Gauge)() -> this.tableSummary.getEqualityDeleteFileCount()));
            this.registerMetric(registry, TABLE_SUMMARY_DANGLING_DELETE_FILES, (Metric)((Gauge)() -> this.tableSummary.getDanglingDeleteFileCount()));
            this.registerMetric(registry, TABLE_SUMMARY_TOTAL_FILES_SIZE, (Metric)((Gauge)() -> this.tableSummary.getTotalFileSize()));
            this.registerMetric(registry, TABLE_SUMMARY_DATA_FILES_SIZE, (Metric)((Gauge)() -> this.tableSummary.getDataFileSize()));
            this.registerMetric(registry, TABLE_SUMMARY_POSITION_DELETE_FILES_SIZE, (Metric)((Gauge)() -> this.tableSummary.getPositionalDeleteBytes()));
            this.registerMetric(registry, TABLE_SUMMARY_EQUALITY_DELETE_FILES_SIZE, (Metric)((Gauge)() -> this.tableSummary.getEqualityDeleteBytes()));
            this.registerMetric(registry, TABLE_SUMMARY_TOTAL_RECORDS, (Metric)((Gauge)() -> this.tableSummary.getTotalFileRecords()));
            this.registerMetric(registry, TABLE_SUMMARY_DATA_FILES_RECORDS, (Metric)((Gauge)() -> this.tableSummary.getDataFileRecords()));
            this.registerMetric(registry, TABLE_SUMMARY_POSITION_DELETE_FILES_RECORDS, (Metric)((Gauge)() -> this.tableSummary.getPositionalDeleteFileRecords()));
            this.registerMetric(registry, TABLE_SUMMARY_EQUALITY_DELETE_FILES_RECORDS, (Metric)((Gauge)() -> this.tableSummary.getEqualityDeleteFileRecords()));
            this.registerMetric(registry, TABLE_SUMMARY_HEALTH_SCORE, (Metric)((Gauge)() -> this.tableSummary.getHealthScore()));
            this.registerMetric(registry, TABLE_SUMMARY_SNAPSHOTS, (Metric)((Gauge)() -> this.snapshots));
            this.globalRegistry = registry;
        }
    }

    public void refresh(AbstractOptimizingEvaluator.PendingInput tableSummary) {
        if (tableSummary == null) {
            return;
        }
        this.tableSummary = tableSummary;
    }

    public void refreshSnapshots(MixedTable table) {
        UnkeyedTable unkeyedTable = table.isKeyedTable() ? table.asKeyedTable().baseTable() : table.asUnkeyedTable();
        this.snapshots = Lists.newArrayList(unkeyedTable.snapshots().iterator()).size();
    }
}

