/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.config.TableConfiguration;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuntimeHandlerChain {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeHandlerChain.class);
    private RuntimeHandlerChain next;
    private boolean initialized;

    protected void appendNext(RuntimeHandlerChain handler) {
        Preconditions.checkNotNull((Object)handler);
        Preconditions.checkArgument((!Objects.equals(handler, this) ? 1 : 0) != 0, (String)"Cannot add the same runtime handler:{} twice", (Object)handler.getClass().getSimpleName());
        if (this.next == null) {
            this.next = handler;
        } else {
            this.next.appendNext(handler);
        }
    }

    public final void initialize(List<TableRuntime> tableRuntimes) {
        List<TableRuntime> supportedtableRuntimeList = tableRuntimes.stream().filter(runtime -> this.formatSupported(runtime.getFormat())).collect(Collectors.toList());
        this.initHandler(supportedtableRuntimeList);
        this.initialized = true;
        if (this.next != null) {
            this.next.initialize(tableRuntimes);
        }
    }

    public final void fireStatusChanged(TableRuntime tableRuntime, OptimizingStatus originalStatus) {
        if (!this.initialized) {
            return;
        }
        if (this.formatSupported(tableRuntime.getFormat())) {
            this.doSilently(() -> this.handleStatusChanged(tableRuntime, originalStatus));
        }
        if (this.next != null) {
            this.next.fireStatusChanged(tableRuntime, originalStatus);
        }
    }

    public final void fireConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
        if (!this.initialized) {
            return;
        }
        if (this.formatSupported(tableRuntime.getFormat())) {
            this.doSilently(() -> this.handleConfigChanged(tableRuntime, originalConfig));
        }
        if (this.next != null) {
            this.next.fireConfigChanged(tableRuntime, originalConfig);
        }
    }

    public final void fireTableAdded(AmoroTable<?> table, TableRuntime tableRuntime) {
        if (!this.initialized) {
            return;
        }
        if (this.formatSupported(tableRuntime.getFormat())) {
            this.doSilently(() -> this.handleTableAdded(table, tableRuntime));
        }
        if (this.next != null) {
            this.next.fireTableAdded(table, tableRuntime);
        }
    }

    public final void fireTableRemoved(TableRuntime tableRuntime) {
        if (!this.initialized) {
            return;
        }
        if (this.next != null) {
            this.next.fireTableRemoved(tableRuntime);
        }
        if (this.formatSupported(tableRuntime.getFormat())) {
            this.doSilently(() -> this.handleTableRemoved(tableRuntime));
        }
    }

    public final void dispose() {
        if (this.next != null) {
            this.next.dispose();
        }
        this.doSilently(this::doDispose);
    }

    private void doSilently(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            LOG.error("failed to handle, ignore and continue", t);
        }
    }

    protected boolean formatSupported(TableFormat format) {
        return format.in(new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG, TableFormat.MIXED_HIVE});
    }

    protected abstract void handleStatusChanged(TableRuntime var1, OptimizingStatus var2);

    protected abstract void handleConfigChanged(TableRuntime var1, TableConfiguration var2);

    protected abstract void handleTableAdded(AmoroTable<?> var1, TableRuntime var2);

    protected abstract void handleTableRemoved(TableRuntime var1);

    protected abstract void initHandler(List<TableRuntime> var1);

    protected abstract void doDispose();
}

