/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence.converter;

import java.io.ByteArrayInputStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.amoro.server.utils.CompressUtil;
import org.apache.amoro.utils.SerializationUtil;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class Object2ByteArrayConvert<T>
implements TypeHandler<T> {
    public void setParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        String dbName = ps.getConnection().getMetaData().getDatabaseProductName().toLowerCase(Locale.ENGLISH);
        if (parameter == null) {
            if (dbName.startsWith("postgres")) {
                ps.setNull(i, -2);
            } else {
                ps.setNull(i, 2004);
            }
            return;
        }
        ps.setBinaryStream(i, new ByteArrayInputStream(CompressUtil.gzip(SerializationUtil.simpleSerialize(parameter).array())));
    }

    public T getResult(ResultSet rs, String columnName) throws SQLException {
        byte[] bytes = rs.getBytes(columnName);
        if (bytes == null) {
            return null;
        }
        return (T)SerializationUtil.simpleDeserialize((byte[])CompressUtil.unGzip(bytes));
    }

    public T getResult(ResultSet rs, int columnIndex) throws SQLException {
        byte[] bytes = rs.getBytes(columnIndex);
        if (bytes == null) {
            return null;
        }
        return (T)SerializationUtil.simpleDeserialize((byte[])CompressUtil.unGzip(bytes));
    }

    public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
        byte[] bytes = cs.getBytes(columnIndex);
        if (bytes == null) {
            return null;
        }
        return (T)SerializationUtil.simpleDeserialize((byte[])CompressUtil.unGzip(bytes));
    }
}

