/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.table.descriptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.descriptor.DDLInfo;
import org.apache.amoro.table.descriptor.MetadataChangeHandler;
import org.apache.amoro.table.descriptor.SparkMetadataChangeHandler;
import org.apache.amoro.table.descriptor.TableMetaExtract;

public class DDLReverser<T> {
    private final TableMetaExtract<T> tableMetaExtract;

    public DDLReverser(TableMetaExtract<T> tableMetaExtract) {
        this.tableMetaExtract = tableMetaExtract;
    }

    public List<DDLInfo> reverse(T table, TableIdentifier tableIdentifier) {
        SparkMetadataChangeHandler metadataChangeHandler = new SparkMetadataChangeHandler(tableIdentifier.getTableName());
        List<TableMetaExtract.InternalTableMeta> internalTableMetas = this.tableMetaExtract.extractTable(table);
        if (internalTableMetas.isEmpty() || internalTableMetas.size() == 1) {
            return Collections.emptyList();
        }
        ArrayList<DDLInfo> result = new ArrayList<DDLInfo>();
        for (int i = 1; i < internalTableMetas.size(); ++i) {
            TableMetaExtract.InternalTableMeta pre = internalTableMetas.get(i - 1);
            TableMetaExtract.InternalTableMeta current = internalTableMetas.get(i);
            this.compareProperties(pre.getProperties(), current.getProperties(), metadataChangeHandler).forEach(sql -> result.add(DDLInfo.of(tableIdentifier, sql, DDLInfo.DDLType.UPDATE_PROPERTIES, current.getTime())));
            this.compareSchemas(pre.getInternalSchema(), current.getInternalSchema(), metadataChangeHandler).forEach(sql -> result.add(DDLInfo.of(tableIdentifier, sql, DDLInfo.DDLType.UPDATE_SCHEMA, current.getTime())));
        }
        return result;
    }

    private List<String> compareProperties(Map<String, String> pre, Map<String, String> current, MetadataChangeHandler metadataChangeHandler) {
        ArrayList<String> result = new ArrayList<String>();
        Sets.SetView removeProperties = Sets.difference(pre.keySet(), current.keySet());
        if (!removeProperties.isEmpty()) {
            result.add(metadataChangeHandler.removeProperties((Set<String>)removeProperties));
        }
        HashMap changeAndAddProperties = Maps.newHashMap();
        for (Map.Entry<String, String> currentEntry : current.entrySet()) {
            String key = currentEntry.getKey();
            String value = currentEntry.getValue();
            if (pre.containsKey(key)) {
                if (pre.get(key).equals(value)) continue;
                changeAndAddProperties.put(key, value);
                continue;
            }
            changeAndAddProperties.put(key, value);
        }
        if (!changeAndAddProperties.isEmpty()) {
            result.add(metadataChangeHandler.changeAndAddProperties(changeAndAddProperties));
        }
        return result;
    }

    private List<String> compareSchemas(List<TableMetaExtract.InternalSchema> pre, List<TableMetaExtract.InternalSchema> current, MetadataChangeHandler metadataChangeHandler) {
        Sets.SetView newColumns;
        Set normalizedNewColumns;
        ArrayList<String> result = new ArrayList<String>();
        Map<Integer, TableMetaExtract.InternalSchema> preMap = pre.stream().collect(Collectors.toMap(TableMetaExtract.InternalSchema::getId, v -> v));
        Map<Integer, TableMetaExtract.InternalSchema> currentMap = current.stream().collect(Collectors.toMap(TableMetaExtract.InternalSchema::getId, v -> v));
        Sets.SetView removeColumns = Sets.difference(preMap.keySet(), currentMap.keySet());
        Set normalizedRemoveColumns = removeColumns.stream().filter(arg_0 -> DDLReverser.lambda$compareSchemas$4((Set)removeColumns, preMap, arg_0)).collect(Collectors.toSet());
        if (!normalizedRemoveColumns.isEmpty()) {
            result.add(metadataChangeHandler.dropColumns(normalizedRemoveColumns.stream().map(preMap::get).map(TableMetaExtract.InternalSchema::getName).collect(Collectors.toSet())));
        }
        if (!(normalizedNewColumns = (newColumns = Sets.difference(currentMap.keySet(), preMap.keySet())).stream().filter(arg_0 -> DDLReverser.lambda$compareSchemas$5((Set)newColumns, currentMap, arg_0)).collect(Collectors.toSet())).isEmpty()) {
            result.add(metadataChangeHandler.addNewColumns(normalizedNewColumns.stream().map(currentMap::get).collect(Collectors.toList())));
        }
        for (TableMetaExtract.InternalSchema currentSchema : current) {
            if (!preMap.containsKey(currentSchema.getId())) continue;
            TableMetaExtract.InternalSchema preSchema = preMap.get(currentSchema.getId());
            if (!Objects.equals(preSchema.getName(), currentSchema.getName())) {
                result.add(metadataChangeHandler.renameColumnName(preSchema.getName(), currentSchema.getName()));
            }
            if (!Objects.equals(preSchema.getType(), currentSchema.getType())) {
                result.add(metadataChangeHandler.changeColumnType(currentSchema.getName(), currentSchema.getType()));
            }
            if (!Objects.equals(preSchema.getComment(), currentSchema.getComment())) {
                result.add(metadataChangeHandler.changeColumnsComment(currentSchema.getName(), currentSchema.getComment()));
            }
            if (preSchema.isRequired() == currentSchema.isRequired()) continue;
            result.add(metadataChangeHandler.changeColumnsRequire(currentSchema.getName(), currentSchema.isRequired()));
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$compareSchemas$5(Set newColumns, Map currentMap, Integer s) {
        return !newColumns.contains(((TableMetaExtract.InternalSchema)currentMap.get(s)).getParentId());
    }

    private static /* synthetic */ boolean lambda$compareSchemas$4(Set removeColumns, Map preMap, Integer s) {
        return !removeColumns.contains(((TableMetaExtract.InternalSchema)preMap.get(s)).getParentId());
    }
}

