/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.table;

import java.util.Map;
import java.util.Set;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.mixed.MixedFormatCatalog;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableSet;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.spark.reader.SparkScanBuilder;
import org.apache.amoro.spark.table.SupportsExtendIdentColumns;
import org.apache.amoro.spark.table.SupportsRowLevelOperator;
import org.apache.amoro.spark.table.UnkeyedSparkTable;
import org.apache.amoro.spark.util.MixedFormatSparkUtils;
import org.apache.amoro.spark.writer.MixedFormatSparkWriteBuilder;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.PartitionAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.SupportsPartitionManagement;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class MixedSparkTable
implements Table,
SupportsRead,
SupportsWrite,
SupportsRowLevelOperator,
SupportsPartitionManagement {
    private static final Set<String> RESERVED_PROPERTIES = Sets.newHashSet((Object[])new String[]{"provider", "format", "current-snapshot-id"});
    private static final Set<TableCapability> CAPABILITIES = ImmutableSet.of((Object)TableCapability.BATCH_READ, (Object)TableCapability.BATCH_WRITE, (Object)TableCapability.STREAMING_WRITE, (Object)TableCapability.OVERWRITE_BY_FILTER, (Object)TableCapability.OVERWRITE_DYNAMIC);
    private final MixedTable mixedTable;
    private final String sparkCatalogName;
    private StructType lazyTableSchema = null;
    private SparkSession lazySpark = null;
    private final MixedFormatCatalog catalog;

    public static Table ofMixedTable(MixedTable table, MixedFormatCatalog catalog, String sparkCatalogName) {
        if (table.isUnkeyedTable() && !(table instanceof SupportHive)) {
            return new UnkeyedSparkTable(table.asUnkeyedTable(), false, sparkCatalogName);
        }
        return new MixedSparkTable(table, catalog, sparkCatalogName);
    }

    public MixedSparkTable(MixedTable mixedTable, MixedFormatCatalog catalog, String sparkCatalogName) {
        this.mixedTable = mixedTable;
        this.sparkCatalogName = sparkCatalogName;
        this.catalog = catalog;
    }

    private SparkSession sparkSession() {
        if (this.lazySpark == null) {
            this.lazySpark = SparkSession.active();
        }
        return this.lazySpark;
    }

    public MixedTable table() {
        return this.mixedTable;
    }

    public String name() {
        return this.sparkCatalogName + "." + this.mixedTable.id().getDatabase() + "." + this.mixedTable.id().getTableName();
    }

    public StructType schema() {
        if (this.lazyTableSchema == null) {
            Schema tableSchema = this.mixedTable.schema();
            this.lazyTableSchema = SparkSchemaUtil.convert((Schema)tableSchema);
        }
        return this.lazyTableSchema;
    }

    public Transform[] partitioning() {
        return Spark3Util.toTransforms((PartitionSpec)this.mixedTable.spec());
    }

    public Map<String, String> properties() {
        ImmutableMap.Builder propsBuilder = ImmutableMap.builder();
        if (!this.mixedTable.properties().containsKey("base.write.format")) {
            propsBuilder.put((Object)"base.write.format", (Object)"parquet");
        }
        if (!this.mixedTable.properties().containsKey("delta.write.format")) {
            propsBuilder.put((Object)"delta.write.format", (Object)this.mixedTable.properties().getOrDefault("change.write.format", "parquet"));
        }
        propsBuilder.put((Object)"provider", (Object)MixedFormatSparkUtils.mixedTableProvider(this.table()));
        this.mixedTable.properties().entrySet().stream().filter(entry -> !RESERVED_PROPERTIES.contains(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)propsBuilder).put(arg_0));
        return propsBuilder.build();
    }

    public Set<TableCapability> capabilities() {
        return CAPABILITIES;
    }

    public String toString() {
        return this.mixedTable.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MixedSparkTable that = (MixedSparkTable)other;
        return this.mixedTable.id().equals((Object)that.mixedTable.id());
    }

    public int hashCode() {
        return this.mixedTable.id().hashCode();
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        return new SparkScanBuilder(this.sparkSession(), this.mixedTable, options);
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        return new MixedFormatSparkWriteBuilder(this.mixedTable, info, this.catalog);
    }

    @Override
    public SupportsExtendIdentColumns newUpsertScanBuilder(CaseInsensitiveStringMap options) {
        return new SparkScanBuilder(this.sparkSession(), this.mixedTable, options);
    }

    @Override
    public boolean requireAdditionIdentifierColumns() {
        return true;
    }

    @Override
    public boolean appendAsUpsert() {
        return this.mixedTable.isKeyedTable() && Boolean.parseBoolean(this.mixedTable.properties().getOrDefault("write.upsert.enabled", "false"));
    }

    public StructType partitionSchema() {
        return SparkSchemaUtil.convert((Schema)new Schema(this.table().spec().partitionType().fields()));
    }

    public void createPartition(InternalRow ident, Map<String, String> properties) throws PartitionAlreadyExistsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("not supported create partition");
    }

    public boolean dropPartition(InternalRow ident) {
        return false;
    }

    public void replacePartitionMetadata(InternalRow ident, Map<String, String> properties) throws NoSuchPartitionException, UnsupportedOperationException {
        throw new UnsupportedOperationException("not supported replace partition");
    }

    public Map<String, String> loadPartitionMetadata(InternalRow ident) throws UnsupportedOperationException {
        return null;
    }

    public InternalRow[] listPartitionIdentifiers(String[] names, InternalRow ident) {
        return new InternalRow[0];
    }
}

