/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.table;

import java.util.HashMap;
import java.util.Map;
import org.apache.amoro.TableFormat;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.op.KeyedPartitionRewrite;
import org.apache.amoro.op.KeyedSchemaUpdate;
import org.apache.amoro.op.OverwriteBaseFiles;
import org.apache.amoro.op.RewritePartitions;
import org.apache.amoro.op.UpdateKeyedTableProperties;
import org.apache.amoro.scan.BasicKeyedTableScan;
import org.apache.amoro.scan.ChangeTableIncrementalScan;
import org.apache.amoro.scan.KeyedTableScan;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.BaseTable;
import org.apache.amoro.table.BasicUnkeyedTable;
import org.apache.amoro.table.ChangeTable;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.MixedChangeTableScan;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.events.CreateSnapshotEvent;

public class BasicKeyedTable
implements KeyedTable {
    private final String tableLocation;
    private final PrimaryKeySpec primaryKeySpec;
    protected final BaseTable baseTable;
    protected final ChangeTable changeTable;

    public BasicKeyedTable(String tableLocation, PrimaryKeySpec keySpec, BaseTable baseTable, ChangeTable changeTable) {
        this.tableLocation = tableLocation;
        this.primaryKeySpec = keySpec;
        this.baseTable = baseTable;
        this.changeTable = changeTable;
    }

    public BasicKeyedTable(PrimaryKeySpec keySpec, BaseTable baseTable, ChangeTable changeTable) {
        this.tableLocation = null;
        this.primaryKeySpec = keySpec;
        this.baseTable = baseTable;
        this.changeTable = changeTable;
    }

    @Override
    public Schema schema() {
        KeyedSchemaUpdate.syncSchema(this);
        return this.baseTable.schema();
    }

    @Override
    public PartitionSpec spec() {
        return this.baseTable.spec();
    }

    @Override
    public TableIdentifier id() {
        return this.baseTable.id();
    }

    @Override
    public TableFormat format() {
        return TableFormat.MIXED_ICEBERG;
    }

    @Override
    public PrimaryKeySpec primaryKeySpec() {
        return this.primaryKeySpec;
    }

    @Override
    public String location() {
        if (StringUtils.isEmpty((CharSequence)this.tableLocation)) {
            return this.baseTable.location();
        }
        return this.tableLocation;
    }

    @Override
    public String baseLocation() {
        return this.baseTable.location();
    }

    @Override
    public String changeLocation() {
        return this.changeTable.location();
    }

    @Override
    public Map<String, String> properties() {
        long changeWatermark = TablePropertyUtil.getTableWatermark(this.changeTable.properties());
        long baseWatermark = TablePropertyUtil.getTableWatermark(this.baseTable.properties());
        HashMap properties = Maps.newHashMap();
        if (changeWatermark > baseWatermark) {
            this.baseTable.properties().forEach((k, v) -> {
                if (!"watermark.table".equals(k)) {
                    properties.put(k, v);
                }
            });
            properties.put("watermark.table", String.valueOf(changeWatermark));
        } else {
            properties.putAll(this.baseTable.properties());
        }
        properties.put("watermark.base", String.valueOf(baseWatermark));
        return ImmutableMap.copyOf((Map)properties);
    }

    @Override
    public AuthenticatedFileIO io() {
        return this.baseTable.io();
    }

    @Override
    public void refresh() {
        this.baseTable.refresh();
        if (this.primaryKeySpec().primaryKeyExisted()) {
            this.changeTable.refresh();
        }
    }

    @Override
    public BaseTable baseTable() {
        return this.baseTable;
    }

    @Override
    public ChangeTable changeTable() {
        return this.changeTable;
    }

    @Override
    public KeyedTableScan newScan() {
        return new BasicKeyedTableScan(this);
    }

    @Override
    public UpdateSchema updateSchema() {
        if (PrimaryKeySpec.noPrimaryKey().equals(this.primaryKeySpec())) {
            return this.baseTable().updateSchema();
        }
        return new KeyedSchemaUpdate(this);
    }

    @Override
    public UpdateProperties updateProperties() {
        return new UpdateKeyedTableProperties(this);
    }

    @Override
    public long beginTransaction(String signature) {
        AppendFiles appendFiles = this.changeTable.newAppend();
        appendFiles.set("tx.begin.signature", signature == null ? "" : signature);
        appendFiles.commit();
        CreateSnapshotEvent createSnapshotEvent = (CreateSnapshotEvent)appendFiles.updateEvent();
        return createSnapshotEvent.sequenceNumber();
    }

    public String toString() {
        return this.name();
    }

    @Override
    public OverwriteBaseFiles newOverwriteBaseFiles() {
        return new OverwriteBaseFiles(this);
    }

    @Override
    public RewritePartitions newRewritePartitions() {
        return new KeyedPartitionRewrite(this);
    }

    public static class ChangeInternalTable
    extends BasicUnkeyedTable
    implements ChangeTable {
        public ChangeInternalTable(TableIdentifier tableIdentifier, Table changeIcebergTable, AuthenticatedFileIO authenticatedFileIO, Map<String, String> catalogProperties) {
            super(tableIdentifier, changeIcebergTable, authenticatedFileIO, catalogProperties);
        }

        @Override
        public ChangeTableIncrementalScan newScan() {
            return new MixedChangeTableScan(this, this.schema());
        }
    }

    public static class BaseInternalTable
    extends BasicUnkeyedTable
    implements BaseTable {
        public BaseInternalTable(TableIdentifier tableIdentifier, Table baseIcebergTable, AuthenticatedFileIO authenticatedFileIO, Map<String, String> catalogProperties) {
            super(tableIdentifier, baseIcebergTable, authenticatedFileIO, catalogProperties);
        }
    }
}

