/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import org.apache.amoro.io.AuthenticatedHadoopFileIO;
import org.apache.amoro.io.PathInfo;
import org.apache.amoro.io.TableTrashManager;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.utils.TableFileUtil;
import org.apache.iceberg.io.FileInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BasicTableTrashManager
implements TableTrashManager {
    private static final Logger LOG = LoggerFactory.getLogger(BasicTableTrashManager.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final TableIdentifier tableIdentifier;
    private final AuthenticatedHadoopFileIO fileIO;
    private final String tableRootLocation;
    private final String trashLocation;

    BasicTableTrashManager(TableIdentifier tableIdentifier, AuthenticatedHadoopFileIO fileIO, String tableRootLocation, String trashLocation) {
        this.tableIdentifier = tableIdentifier;
        this.fileIO = fileIO;
        this.tableRootLocation = tableRootLocation;
        this.trashLocation = trashLocation;
    }

    @VisibleForTesting
    static String generateFileLocationInTrash(String relativeFileLocation, String trashLocation, long deleteTime) {
        return trashLocation + "/" + BasicTableTrashManager.formatDate(deleteTime) + "/" + relativeFileLocation;
    }

    @VisibleForTesting
    static String getRelativeFileLocation(String tableRootLocation, String fileLocation) {
        tableRootLocation = TableFileUtil.getUriPath(tableRootLocation);
        fileLocation = TableFileUtil.getUriPath(fileLocation);
        if (!tableRootLocation.endsWith("/")) {
            tableRootLocation = tableRootLocation + "/";
        }
        Preconditions.checkArgument((boolean)fileLocation.startsWith(tableRootLocation), (Object)String.format("file %s is not in table location %s", fileLocation, tableRootLocation));
        return fileLocation.replaceFirst(tableRootLocation, "");
    }

    private static String formatDate(long time) {
        LocalDate localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()).toLocalDate();
        return localDate.format(DATE_FORMATTER);
    }

    private static LocalDate parseDate(String formattedDate) {
        return LocalDate.parse(formattedDate, DATE_FORMATTER);
    }

    @Override
    public TableIdentifier tableId() {
        return this.tableIdentifier;
    }

    @Override
    public void moveFileToTrash(String path) {
        try {
            Preconditions.checkArgument((!this.fileIO.supportFileSystemOperations() || !this.fileIO.asFileSystemIO().isDirectory(path) ? 1 : 0) != 0, (Object)("should not move a directory to trash " + path));
            String targetFileLocation = BasicTableTrashManager.generateFileLocationInTrash(BasicTableTrashManager.getRelativeFileLocation(this.tableRootLocation, path), this.trashLocation, System.currentTimeMillis());
            String targetFileDir = TableFileUtil.getFileDir(targetFileLocation);
            if (!this.fileIO.exists(targetFileDir)) {
                this.fileIO.makeDirectories(targetFileDir);
            }
            if (this.fileIO.exists(targetFileLocation)) {
                this.fileIO.deleteFile(targetFileLocation);
            }
            this.fileIO.rename(path, targetFileLocation);
        }
        catch (Exception e) {
            LOG.error("{} failed to move file to trash, {}", new Object[]{this.tableIdentifier, path, e});
            throw e;
        }
    }

    @Override
    public boolean fileExistInTrash(String path) {
        return this.findFileFromTrash(path).isPresent();
    }

    @Override
    public boolean restoreFileFromTrash(String path) {
        Optional<String> fileFromTrash = this.findFileFromTrash(path);
        if (!fileFromTrash.isPresent()) {
            return false;
        }
        try {
            this.fileIO.rename(fileFromTrash.get(), path);
            return true;
        }
        catch (Exception e) {
            LOG.info("{} failed to restore file, {}", new Object[]{this.tableIdentifier, path, e});
            return false;
        }
    }

    @Override
    public void cleanFiles(LocalDate expirationDate) {
        LOG.info("{} start clean files with expiration date {}", (Object)this.tableIdentifier, (Object)expirationDate);
        if (!this.fileIO.exists(this.trashLocation)) {
            return;
        }
        Iterable<PathInfo> datePaths = this.fileIO.listDirectory(this.trashLocation);
        for (FileInfo fileInfo : datePaths) {
            LocalDate localDate;
            String dateName = TableFileUtil.getFileName(fileInfo.location());
            try {
                localDate = BasicTableTrashManager.parseDate(dateName);
            }
            catch (Exception e) {
                LOG.warn("{} failed to parse path to date {}", new Object[]{this.tableIdentifier, fileInfo.location(), e});
                continue;
            }
            if (localDate.isBefore(expirationDate)) {
                this.fileIO.deletePrefix(fileInfo.location());
                LOG.info("{} delete files in trash for date {} success, {}", new Object[]{this.tableIdentifier, localDate, fileInfo.location()});
                continue;
            }
            LOG.info("{} should not delete files in trash for date {},  {}", new Object[]{this.tableIdentifier, localDate, fileInfo.location()});
        }
    }

    private Optional<String> findFileFromTrash(String path) {
        if (!this.fileIO.exists(this.trashLocation)) {
            return Optional.empty();
        }
        String targetRelationLocationInTable = BasicTableTrashManager.getRelativeFileLocation(this.tableRootLocation, path);
        Iterable<PathInfo> paths = this.fileIO.listDirectory(this.trashLocation);
        ArrayList targetLocationsInTrash = Lists.newArrayList();
        for (PathInfo p : paths) {
            String fullLocation = p.location() + "/" + targetRelationLocationInTable;
            if (!this.fileIO.exists(fullLocation) || this.fileIO.isDirectory(fullLocation)) continue;
            targetLocationsInTrash.add(fullLocation);
        }
        return targetLocationsInTrash.stream().max(Comparator.naturalOrder());
    }

    @Override
    public String getTrashLocation() {
        return this.trashLocation;
    }
}

