/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.mixed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.mixed.CatalogLoader;
import org.apache.amoro.mixed.MixedFormatCatalog;
import org.apache.amoro.shade.guava32.com.google.common.base.Joiner;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.spark.SupportAuthentication;
import org.apache.amoro.spark.mixed.MixedTableStoreType;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableMetaStore;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public abstract class MixedSparkCatalogBase
implements TableCatalog,
SupportsNamespaces,
SupportAuthentication {
    private String catalogName = null;
    private TableMetaStore tableMetaStore;
    protected MixedFormatCatalog catalog;
    private CaseInsensitiveStringMap options;

    @Override
    public void setAuthenticationContext(TableMetaStore tableMetaStore) {
        this.tableMetaStore = tableMetaStore;
    }

    public final void initialize(String name, CaseInsensitiveStringMap options) {
        this.catalogName = name;
        HashMap properties = Maps.newHashMap((Map)options);
        if (this.tableMetaStore == null) {
            String catalogUrl = options.get((Object)"url");
            if (StringUtils.isBlank((CharSequence)catalogUrl)) {
                catalogUrl = options.get((Object)"uri");
            }
            if (catalogUrl != null) {
                this.catalog = CatalogLoader.load((String)catalogUrl, (Map)properties);
            } else {
                Configuration localConfiguration = SparkUtil.hadoopConfCatalogOverrides((SparkSession)SparkSession.active(), (String)name);
                this.tableMetaStore = TableMetaStore.builder().withConfiguration(localConfiguration).build();
            }
        }
        if (this.catalog == null) {
            String metastoreType = options.get((Object)"type");
            String registerName = options.get((Object)"register-name");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)metastoreType), (Object)"Lack required property: type when initializing mixed spark catalog");
            Preconditions.checkNotNull((Object)this.tableMetaStore, (Object)"Lack authentication context when initializing mixed spark catalog");
            this.catalog = CatalogLoader.createCatalog((String)(registerName == null ? this.catalogName : registerName), (String)metastoreType, (Map)properties, (TableMetaStore)this.tableMetaStore);
        }
        this.options = options;
    }

    public String name() {
        return this.catalogName;
    }

    /*
     * Exception decompiling
     */
    public String[][] listNamespaces() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[][] listNamespaces(String[] namespace) {
        return new String[0][];
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        String database = namespace[0];
        return this.catalog.listDatabases().stream().filter(d -> StringUtils.equals((CharSequence)d, (CharSequence)database)).map(d -> new HashMap()).findFirst().orElseThrow(() -> new NoSuchNamespaceException(namespace));
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) {
        if (namespace.length > 1) {
            throw new UnsupportedOperationException("mixed-format does not support multi-level namespace.");
        }
        String database = namespace[0];
        this.catalog.createDatabase(database);
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) {
        throw new UnsupportedOperationException("Alter  namespace is not supported by catalog: " + this.catalogName);
    }

    public boolean dropNamespace(String[] namespace) {
        String database = namespace[0];
        this.catalog.dropDatabase(database);
        return true;
    }

    public boolean dropTable(Identifier ident) {
        TableIdentifier identifier = this.buildIdentifier(ident);
        return this.catalog.dropTable(identifier, true);
    }

    public boolean purgeTable(Identifier ident) throws UnsupportedOperationException {
        TableIdentifier identifier = this.buildIdentifier(ident);
        return this.catalog.dropTable(identifier, true);
    }

    public void renameTable(Identifier from, Identifier to) {
        throw new UnsupportedOperationException("Unsupported renameTable.");
    }

    public Identifier[] listTables(String[] namespace) {
        ArrayList<String> database;
        if (namespace == null || namespace.length == 0) {
            database = this.catalog.listDatabases();
        } else {
            database = new ArrayList<String>();
            database.add(namespace[0]);
        }
        List tableIdentifiers = database.stream().map(d -> this.catalog.listTables(d)).flatMap(Collection::stream).collect(Collectors.toList());
        return (Identifier[])tableIdentifiers.stream().map(i -> Identifier.of((String[])new String[]{i.getDatabase()}, (String)i.getTableName())).toArray(Identifier[]::new);
    }

    protected void checkAndRefreshCatalogMeta() {
        SparkSession sparkSession = SparkSession.active();
        if (Boolean.parseBoolean(sparkSession.conf().get("spark.sql.mixed-format.refresh-catalog-before-usage", "false"))) {
            this.initialize(this.catalogName, this.options);
        }
    }

    protected TableIdentifier buildIdentifier(Identifier identifier) {
        Preconditions.checkArgument((identifier.namespace() != null && identifier.namespace().length > 0 ? 1 : 0) != 0, (Object)("database is not specific, table identifier: " + identifier.name()));
        Preconditions.checkArgument((identifier.namespace() != null && identifier.namespace().length == 1 ? 1 : 0) != 0, (Object)("mixed-format does not support multi-level namespace: " + Joiner.on((String)".").join((Object[])identifier.namespace())));
        return TableIdentifier.of((String)this.catalog.name(), (String)identifier.namespace()[0].split("\\.")[0], (String)identifier.name());
    }

    protected TableIdentifier buildInnerTableIdentifier(Identifier identifier) {
        Preconditions.checkArgument((identifier.namespace() != null && identifier.namespace().length > 0 ? 1 : 0) != 0, (Object)("database is not specific, table identifier: " + identifier.name()));
        Preconditions.checkArgument((identifier.namespace().length == 2 ? 1 : 0) != 0, (Object)("mixed-format does not support multi-level namespace: " + Joiner.on((String)".").join((Object[])identifier.namespace())));
        return TableIdentifier.of((String)this.catalog.name(), (String)identifier.namespace()[0], (String)identifier.namespace()[1]);
    }

    protected boolean isIdentifierLocation(String location, Identifier identifier) {
        ArrayList nameParts = Lists.newArrayList();
        nameParts.add(this.name());
        nameParts.addAll(Arrays.asList(identifier.namespace()));
        nameParts.add(identifier.name());
        String ident = Joiner.on((char)'.').join((Iterable)nameParts);
        return ident.equalsIgnoreCase(location);
    }

    protected boolean isInnerTableIdentifier(Identifier identifier) {
        if (identifier.namespace().length != 2) {
            return false;
        }
        return MixedTableStoreType.from(identifier.name()) != null;
    }

    private static /* synthetic */ String[][] lambda$listNamespaces$1(int x$0) {
        return new String[x$0][];
    }
}

