/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.thrift;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kyuubi.shade.org.apache.thrift.TNonblockingMultiFetchStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TNonblockingMultiFetchClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TNonblockingMultiFetchClient.class.getName());
    private int maxRecvBufBytesPerServer;
    private int fetchTimeoutSeconds;
    private ByteBuffer requestBuf;
    private ByteBuffer requestBufDuplication;
    private List<InetSocketAddress> servers;
    private TNonblockingMultiFetchStats stats;
    private ByteBuffer[] recvBuf;

    public TNonblockingMultiFetchClient(int maxRecvBufBytesPerServer, int fetchTimeoutSeconds, ByteBuffer requestBuf, List<InetSocketAddress> servers) {
        this.maxRecvBufBytesPerServer = maxRecvBufBytesPerServer;
        this.fetchTimeoutSeconds = fetchTimeoutSeconds;
        this.requestBuf = requestBuf;
        this.servers = servers;
        this.stats = new TNonblockingMultiFetchStats();
        this.recvBuf = null;
    }

    public synchronized int getMaxRecvBufBytesPerServer() {
        return this.maxRecvBufBytesPerServer;
    }

    public synchronized int getFetchTimeoutSeconds() {
        return this.fetchTimeoutSeconds;
    }

    public synchronized ByteBuffer getRequestBuf() {
        if (this.requestBuf == null) {
            return null;
        }
        if (this.requestBufDuplication == null) {
            this.requestBufDuplication = this.requestBuf.duplicate();
        }
        return this.requestBufDuplication;
    }

    public synchronized List<InetSocketAddress> getServerList() {
        if (this.servers == null) {
            return null;
        }
        return Collections.unmodifiableList(this.servers);
    }

    public synchronized TNonblockingMultiFetchStats getFetchStats() {
        return this.stats;
    }

    public synchronized ByteBuffer[] fetch() {
        this.recvBuf = null;
        this.stats.clear();
        if (this.servers == null || this.servers.size() == 0 || this.requestBuf == null || this.fetchTimeoutSeconds <= 0) {
            return this.recvBuf;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        MultiFetch multiFetch = new MultiFetch();
        FutureTask<Object> task = new FutureTask<Object>(multiFetch, null);
        executor.execute(task);
        try {
            task.get(this.fetchTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            task.cancel(true);
            LOGGER.error("interrupted during fetch: " + ie.toString());
        }
        catch (ExecutionException ee) {
            task.cancel(true);
            LOGGER.error("exception during fetch: " + ee.toString());
        }
        catch (TimeoutException te) {
            task.cancel(true);
            LOGGER.error("timeout for fetch: " + te.toString());
        }
        executor.shutdownNow();
        multiFetch.close();
        return this.recvBuf;
    }

    static /* synthetic */ ByteBuffer[] access$302(TNonblockingMultiFetchClient x0, ByteBuffer[] x1) {
        x0.recvBuf = x1;
        return x1;
    }

    private class MultiFetch
    implements Runnable {
        private Selector selector;

        private MultiFetch() {
        }

        public void run() {
            long t1 = System.currentTimeMillis();
            int numTotalServers = TNonblockingMultiFetchClient.this.servers.size();
            TNonblockingMultiFetchClient.this.stats.setNumTotalServers(numTotalServers);
            TNonblockingMultiFetchClient.access$302(TNonblockingMultiFetchClient.this, new ByteBuffer[numTotalServers]);
            ByteBuffer[] sendBuf = new ByteBuffer[numTotalServers];
            long[] numBytesRead = new long[numTotalServers];
            int[] frameSize = new int[numTotalServers];
            boolean[] hasReadFrameSize = new boolean[numTotalServers];
            try {
                this.selector = Selector.open();
            }
            catch (IOException e) {
                LOGGER.error("selector opens error: " + e.toString());
                return;
            }
            for (int i = 0; i < numTotalServers; ++i) {
                sendBuf[i] = TNonblockingMultiFetchClient.this.requestBuf.duplicate();
                ((TNonblockingMultiFetchClient)TNonblockingMultiFetchClient.this).recvBuf[i] = ByteBuffer.allocate(4);
                TNonblockingMultiFetchClient.this.stats.incTotalRecvBufBytes(4);
                InetSocketAddress server = (InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(i);
                SocketChannel s = null;
                SelectionKey key = null;
                try {
                    s = SocketChannel.open();
                    s.configureBlocking(false);
                    s.connect(server);
                    key = s.register(this.selector, s.validOps());
                    key.attach(i);
                    continue;
                }
                catch (Exception e) {
                    TNonblockingMultiFetchClient.this.stats.incNumConnectErrorServers();
                    String err = String.format("set up socket to server %s error: %s", server.toString(), e.toString());
                    LOGGER.error(err);
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (key == null) continue;
                    key.cancel();
                }
            }
            while (TNonblockingMultiFetchClient.this.stats.getNumReadCompletedServers() + TNonblockingMultiFetchClient.this.stats.getNumConnectErrorServers() < TNonblockingMultiFetchClient.this.stats.getNumTotalServers()) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                try {
                    this.selector.select();
                }
                catch (Exception e) {
                    LOGGER.error("selector selects error: " + e.toString());
                    continue;
                }
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SocketChannel sChannel;
                    SelectionKey selKey = it.next();
                    it.remove();
                    int index = (Integer)selKey.attachment();
                    if (selKey.isValid() && selKey.isConnectable()) {
                        try {
                            sChannel = (SocketChannel)selKey.channel();
                            sChannel.finishConnect();
                        }
                        catch (Exception e) {
                            TNonblockingMultiFetchClient.this.stats.incNumConnectErrorServers();
                            String err = String.format("socket %d connects to server %s error: %s", index, ((InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(index)).toString(), e.toString());
                            LOGGER.error(err);
                        }
                    }
                    if (selKey.isValid() && selKey.isWritable() && sendBuf[index].hasRemaining()) {
                        try {
                            sChannel = (SocketChannel)selKey.channel();
                            sChannel.write(sendBuf[index]);
                        }
                        catch (Exception e) {
                            String err = String.format("socket %d writes to server %s error: %s", index, ((InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(index)).toString(), e.toString());
                            LOGGER.error(err);
                        }
                    }
                    if (!selKey.isValid() || !selKey.isReadable()) continue;
                    try {
                        sChannel = (SocketChannel)selKey.channel();
                        int bytesRead = sChannel.read(TNonblockingMultiFetchClient.this.recvBuf[index]);
                        if (bytesRead <= 0) continue;
                        int n = index;
                        numBytesRead[n] = numBytesRead[n] + (long)bytesRead;
                        if (!hasReadFrameSize[index] && TNonblockingMultiFetchClient.this.recvBuf[index].remaining() == 0) {
                            frameSize[index] = TNonblockingMultiFetchClient.this.recvBuf[index].getInt(0);
                            if (frameSize[index] <= 0) {
                                TNonblockingMultiFetchClient.this.stats.incNumInvalidFrameSize();
                                String err = String.format("Read an invalid frame size %d from %s. Does the server use TFramedTransport? ", frameSize[index], ((InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(index)).toString());
                                LOGGER.error(err);
                                sChannel.close();
                                continue;
                            }
                            if (frameSize[index] + 4 > TNonblockingMultiFetchClient.this.stats.getMaxResponseBytes()) {
                                TNonblockingMultiFetchClient.this.stats.setMaxResponseBytes(frameSize[index] + 4);
                            }
                            if (frameSize[index] + 4 > TNonblockingMultiFetchClient.this.maxRecvBufBytesPerServer) {
                                TNonblockingMultiFetchClient.this.stats.incNumOverflowedRecvBuf();
                                String err = String.format("Read frame size %d from %s, total buffer size would exceed limit %d", frameSize[index], ((InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(index)).toString(), TNonblockingMultiFetchClient.this.maxRecvBufBytesPerServer);
                                LOGGER.error(err);
                                sChannel.close();
                                continue;
                            }
                            ((TNonblockingMultiFetchClient)TNonblockingMultiFetchClient.this).recvBuf[index] = ByteBuffer.allocate(frameSize[index] + 4);
                            TNonblockingMultiFetchClient.this.recvBuf[index].putInt(frameSize[index]);
                            TNonblockingMultiFetchClient.this.stats.incTotalRecvBufBytes(frameSize[index]);
                            hasReadFrameSize[index] = true;
                        }
                        if (!hasReadFrameSize[index] || numBytesRead[index] < (long)(frameSize[index] + 4)) continue;
                        sChannel.close();
                        TNonblockingMultiFetchClient.this.stats.incNumReadCompletedServers();
                        long t2 = System.currentTimeMillis();
                        TNonblockingMultiFetchClient.this.stats.setReadTime(t2 - t1);
                    }
                    catch (Exception e) {
                        String err = String.format("socket %d reads from server %s error: %s", index, ((InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(index)).toString(), e.toString());
                        LOGGER.error(err);
                    }
                }
            }
        }

        public void close() {
            try {
                if (this.selector.isOpen()) {
                    for (SelectionKey selKey : this.selector.keys()) {
                        SocketChannel sChannel = (SocketChannel)selKey.channel();
                        sChannel.close();
                    }
                    this.selector.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("free resource error: " + e.toString());
            }
        }
    }
}

