/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.utils.HiveSchemaUtil;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.utils.IdGenerator;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableUtil.class);

    public static Table loadHmsTable(HMSClientPool hiveClient, TableIdentifier tableIdentifier) {
        try {
            return (Table)hiveClient.run(client -> client.getTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName()));
        }
        catch (NoSuchObjectException nte) {
            LOG.trace("Table not found {}", (Object)tableIdentifier.toString(), (Object)nte);
            return null;
        }
        catch (TException e) {
            throw new RuntimeException(String.format("Metastore operation failed for %s", tableIdentifier.toString()), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during commit", e);
        }
    }

    public static void persistTable(HMSClientPool hiveClient, Table tbl) {
        try {
            hiveClient.run(client -> {
                client.alterTable(tbl.getDbName(), tbl.getTableName(), tbl);
                return null;
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> generateTableProperties(int accessTimeInSeconds, List<DataFile> files) {
        HashMap properties = Maps.newHashMap();
        long totalSize = files.stream().map(ContentFile::fileSizeInBytes).reduce(0L, Long::sum);
        long numRows = files.stream().map(ContentFile::recordCount).reduce(0L, Long::sum);
        properties.put("transient_lastDdlTime", accessTimeInSeconds + "");
        properties.put("totalSize", totalSize + "");
        properties.put("numRows", numRows + "");
        properties.put("numFiles", files.size() + "");
        properties.put("arctic.enabled", "true");
        return properties;
    }

    public static String hiveRootLocation(String tableLocation) {
        return tableLocation + "/hive";
    }

    public static String newHiveDataLocation(String hiveLocation, PartitionSpec partitionSpec, StructLike partitionData, String hiveSubdirectory) {
        if (partitionSpec.isUnpartitioned()) {
            return String.format("%s/%s", hiveLocation, hiveSubdirectory);
        }
        return String.format("%s/%s/%s", hiveLocation, partitionSpec.partitionToPath(partitionData), hiveSubdirectory);
    }

    public static String newHiveSubdirectory(long transactionId) {
        return System.currentTimeMillis() + "_" + transactionId;
    }

    public static String newHiveSubdirectory() {
        return System.currentTimeMillis() + "_" + IdGenerator.randomId();
    }

    public static StorageDescriptor storageDescriptor(Schema schema, PartitionSpec partitionSpec, String location, FileFormat format) {
        StorageDescriptor storageDescriptor = new StorageDescriptor();
        storageDescriptor.setCols(HiveSchemaUtil.hiveTableFields(schema, partitionSpec));
        storageDescriptor.setLocation(location);
        SerDeInfo serDeInfo = new SerDeInfo();
        switch (format) {
            case PARQUET: {
                storageDescriptor.setOutputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat");
                storageDescriptor.setInputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat");
                serDeInfo.setSerializationLib("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
                break;
            }
            case ORC: {
                storageDescriptor.setOutputFormat("org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat");
                storageDescriptor.setInputFormat("org.apache.hadoop.hive.ql.io.orc.OrcInputFormat");
                serDeInfo.setSerializationLib("org.apache.hadoop.hive.ql.io.orc.OrcSerde");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported hive table file format:" + format);
            }
        }
        storageDescriptor.setSerdeInfo(serDeInfo);
        return storageDescriptor;
    }

    public static boolean checkExist(HMSClientPool hiveClient, TableIdentifier tableIdentifier) {
        String database = tableIdentifier.getDatabase();
        String name = tableIdentifier.getTableName();
        try {
            hiveClient.run(client -> client.getTable(database, name));
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to get table " + name, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to rename", e);
        }
    }

    public static List<String> getAllHiveTables(HMSClientPool hiveClient, String database) {
        try {
            return (List)hiveClient.run(client -> client.getAllTables(database));
        }
        catch (TException e) {
            throw new RuntimeException("Failed to get tables of database " + database, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getAllTables", e);
        }
    }

    public static void alterTableLocation(HMSClientPool hiveClient, TableIdentifier tableIdentifier, String newPath) throws IOException {
        try {
            hiveClient.run(client -> {
                Table newTable = HiveTableUtil.loadHmsTable(hiveClient, tableIdentifier);
                newTable.getSd().setLocation(newPath);
                client.alterTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName(), newTable);
                return null;
            });
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

