/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Message;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.utils.base64;

public final class DohResolver
implements Resolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DohResolver.class);
    private static final boolean useHttpClient;
    private final SSLSocketFactory sslSocketFactory;
    private static Object defaultHttpRequestBuilder;
    private static Method publisherOfByteArrayMethod;
    private static Method requestBuilderTimeoutMethod;
    private static Method requestBuilderCopyMethod;
    private static Method requestBuilderUriMethod;
    private static Method requestBuilderBuildMethod;
    private static Method requestBuilderPostMethod;
    private static Method httpClientNewBuilderMethod;
    private static Method httpClientBuilderTimeoutMethod;
    private static Method httpClientBuilderExecutorMethod;
    private static Method httpClientBuilderBuildMethod;
    private static Method httpClientSendAsyncMethod;
    private static Method byteArrayBodyPublisherMethod;
    private static Method httpResponseBodyMethod;
    private static Method httpResponseStatusCodeMethod;
    private boolean usePost = false;
    private Duration timeout = Duration.ofSeconds(5L);
    private String uriTemplate;
    private final Duration idleConnectionTimeout;
    private OPTRecord queryOPT = new OPTRecord(0, 0, 0);
    private TSIG tsig;
    private Object httpClient;
    private Executor executor = ForkJoinPool.commonPool();
    private final Semaphore maxConcurrentRequests;
    private final AtomicLong lastRequest = new AtomicLong(0L);
    private final Semaphore initialRequestLock = new Semaphore(1);

    public DohResolver(String uriTemplate) {
        this(uriTemplate, 100, Duration.ofMinutes(2L));
    }

    public DohResolver(String uriTemplate, int maxConcurrentRequests, Duration idleConnectionTimeout) {
        this.uriTemplate = uriTemplate;
        this.idleConnectionTimeout = idleConnectionTimeout;
        if (maxConcurrentRequests <= 0) {
            throw new IllegalArgumentException("maxConcurrentRequests must be > 0");
        }
        if (!useHttpClient) {
            try {
                int javaMaxConn = Integer.parseInt(System.getProperty("http.maxConnections", "5"));
                if (maxConcurrentRequests > javaMaxConn) {
                    maxConcurrentRequests = javaMaxConn;
                }
            }
            catch (NumberFormatException javaMaxConn) {
                // empty catch block
            }
        }
        this.maxConcurrentRequests = new Semaphore(maxConcurrentRequests);
        try {
            this.sslSocketFactory = SSLContext.getDefault().getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.buildHttpClient();
    }

    private void buildHttpClient() {
        if (useHttpClient) {
            Object httpClientBuilder = httpClientNewBuilderMethod.invoke(null, new Object[0]);
            httpClientBuilderTimeoutMethod.invoke(httpClientBuilder, this.timeout);
            if (this.executor != null) {
                httpClientBuilderExecutorMethod.invoke(httpClientBuilder, this.executor);
            }
            this.httpClient = httpClientBuilderBuildMethod.invoke(httpClientBuilder, new Object[0]);
            requestBuilderTimeoutMethod.invoke(defaultHttpRequestBuilder, this.timeout);
        }
    }

    @Override
    public void setPort(int port) {
    }

    @Override
    public void setTCP(boolean flag) {
    }

    @Override
    public void setIgnoreTruncation(boolean flag) {
    }

    @Override
    public void setEDNS(int version, int payloadSize, int flags, List<EDNSOption> options) {
        switch (version) {
            case -1: {
                this.queryOPT = null;
                break;
            }
            case 0: {
                this.queryOPT = new OPTRecord(0, 0, version, flags, options);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid EDNS version - must be 0 or -1 to disable");
            }
        }
    }

    @Override
    public void setTSIGKey(TSIG key) {
        this.tsig = key;
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
        this.buildHttpClient();
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public CompletionStage<Message> sendAsync(Message query) {
        if (useHttpClient) {
            return this.sendAsync11(query);
        }
        return this.sendAsync8(query);
    }

    private CompletionStage<Message> sendAsync8(Message query) {
        CompletableFuture<Message> f = new CompletableFuture<Message>();
        ForkJoinPool.commonPool().execute(() -> {
            try {
                byte[] responseBytes;
                byte[] queryBytes = this.prepareQuery(query).toWire();
                String url = this.getUrl(queryBytes);
                if (!this.maxConcurrentRequests.tryAcquire(this.timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                    this.failedFuture(new IOException("Query timed out"));
                    return;
                }
                try {
                    responseBytes = this.sendAndGetMessageBytes(url, queryBytes);
                }
                finally {
                    this.maxConcurrentRequests.release();
                }
                Message response = new Message(responseBytes);
                this.verifyTSIG(query, response, responseBytes, this.tsig);
                response.setResolver(this);
                f.complete(response);
            }
            catch (IOException | InterruptedException e) {
                f.completeExceptionally(e);
                Thread.currentThread().interrupt();
            }
        });
        return f;
    }

    /*
     * Exception decompiling
     */
    private byte[] sendAndGetMessageBytes(String url, byte[] queryBytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CompletionStage<Message> sendAsync11(Message query) {
        long startTime = System.nanoTime();
        byte[] queryBytes = this.prepareQuery(query).toWire();
        String url = this.getUrl(queryBytes);
        try {
            Duration remainingTimeout;
            boolean isInitialRequest;
            Object builder = requestBuilderCopyMethod.invoke(defaultHttpRequestBuilder, new Object[0]);
            requestBuilderUriMethod.invoke(builder, URI.create(url));
            if (this.usePost) {
                requestBuilderPostMethod.invoke(builder, publisherOfByteArrayMethod.invoke(null, new Object[]{queryBytes}));
            }
            try {
                if (!this.initialRequestLock.tryAcquire(this.timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                    return this.failedFuture(new IOException("Query timed out"));
                }
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
                return this.failedFuture(iex);
            }
            long lastRequestTime = this.lastRequest.get();
            long now = System.nanoTime();
            boolean bl = isInitialRequest = lastRequestTime < now - this.idleConnectionTimeout.toNanos();
            if (!isInitialRequest) {
                this.initialRequestLock.release();
            }
            if ((remainingTimeout = this.timeout.minus(System.nanoTime() - startTime, ChronoUnit.NANOS)).isNegative()) {
                if (isInitialRequest) {
                    this.initialRequestLock.release();
                }
                return this.failedFuture(new IOException("Query timed out"));
            }
            try {
                if (!this.maxConcurrentRequests.tryAcquire(this.timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                    if (isInitialRequest) {
                        this.initialRequestLock.release();
                    }
                    return this.failedFuture(new IOException("Query timed out"));
                }
            }
            catch (InterruptedException iex) {
                if (isInitialRequest) {
                    this.initialRequestLock.release();
                }
                Thread.currentThread().interrupt();
                return this.failedFuture(iex);
            }
            remainingTimeout = this.timeout.minus(System.nanoTime() - startTime, ChronoUnit.NANOS);
            if (remainingTimeout.isNegative()) {
                if (isInitialRequest) {
                    this.initialRequestLock.release();
                }
                return this.failedFuture(new IOException("Query timed out"));
            }
            Object httpRequest = requestBuilderBuildMethod.invoke(builder, new Object[0]);
            Object bodyHandler = byteArrayBodyPublisherMethod.invoke(null, new Object[0]);
            return ((CompletionStage)httpClientSendAsyncMethod.invoke(this.httpClient, httpRequest, bodyHandler)).whenComplete((result, ex) -> {
                this.maxConcurrentRequests.release();
                if (isInitialRequest && ex == null) {
                    this.lastRequest.set(now);
                    this.initialRequestLock.release();
                }
            }).thenComposeAsync(response -> {
                try {
                    Message responseMessage;
                    if ((Integer)httpResponseStatusCodeMethod.invoke(response, new Object[0]) == 200) {
                        byte[] responseBytes = (byte[])httpResponseBodyMethod.invoke(response, new Object[0]);
                        responseMessage = new Message(responseBytes);
                        this.verifyTSIG(query, responseMessage, responseBytes, this.tsig);
                    } else {
                        responseMessage = new Message();
                        responseMessage.getHeader().setRcode(2);
                    }
                    responseMessage.setResolver(this);
                    return CompletableFuture.completedFuture(responseMessage);
                }
                catch (IOException | IllegalAccessException | InvocationTargetException e) {
                    return this.failedFuture(e);
                }
            });
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return this.failedFuture(e);
        }
    }

    private <T> CompletionStage<T> failedFuture(Throwable e) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(e);
        return f;
    }

    private String getUrl(byte[] queryBytes) {
        String url = this.uriTemplate;
        if (!this.usePost) {
            url = url + "?dns=" + base64.toString(queryBytes, true);
        }
        return url;
    }

    private Message prepareQuery(Message query) {
        Message preparedQuery = query.clone();
        preparedQuery.getHeader().setID(0);
        if (this.queryOPT != null && preparedQuery.getOPT() == null) {
            preparedQuery.addRecord(this.queryOPT, 3);
        }
        if (this.tsig != null) {
            this.tsig.apply(preparedQuery, null);
        }
        return preparedQuery;
    }

    private void verifyTSIG(Message query, Message response, byte[] b, TSIG tsig) {
        if (tsig == null) {
            return;
        }
        int error = tsig.verify(response, b, query.getTSIG());
        log.debug("TSIG verify: {}", (Object)Rcode.TSIGstring(error));
    }

    public boolean isUsePost() {
        return this.usePost;
    }

    public void setUsePost(boolean usePost) {
        this.usePost = usePost;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.buildHttpClient();
    }

    public String toString() {
        return "DohResolver {" + (this.usePost ? "POST " : "GET ") + this.uriTemplate + "}";
    }

    static {
        boolean initSuccess = false;
        if (!System.getProperty("java.version").startsWith("1.")) {
            try {
                Class<?> httpClientBuilderClass = Class.forName("java.net.http.HttpClient$Builder");
                Class<?> httpClientClass = Class.forName("java.net.http.HttpClient");
                Class<?> httpVersionEnum = Class.forName("java.net.http.HttpClient$Version");
                Class<?> httpRequestBuilderClass = Class.forName("java.net.http.HttpRequest$Builder");
                Class<?> httpRequestClass = Class.forName("java.net.http.HttpRequest");
                Class<?> bodyPublishersClass = Class.forName("java.net.http.HttpRequest$BodyPublishers");
                Class<?> bodyPublisherClass = Class.forName("java.net.http.HttpRequest$BodyPublisher");
                Class<?> httpResponseClass = Class.forName("java.net.http.HttpResponse");
                Class<?> bodyHandlersClass = Class.forName("java.net.http.HttpResponse$BodyHandlers");
                Class<?> bodyHandlerClass = Class.forName("java.net.http.HttpResponse$BodyHandler");
                httpClientBuilderTimeoutMethod = httpClientBuilderClass.getDeclaredMethod("connectTimeout", Duration.class);
                httpClientBuilderExecutorMethod = httpClientBuilderClass.getDeclaredMethod("executor", Executor.class);
                httpClientBuilderBuildMethod = httpClientBuilderClass.getDeclaredMethod("build", new Class[0]);
                httpClientNewBuilderMethod = httpClientClass.getDeclaredMethod("newBuilder", new Class[0]);
                httpClientSendAsyncMethod = httpClientClass.getDeclaredMethod("sendAsync", httpRequestClass, bodyHandlerClass);
                Method requestBuilderHeaderMethod = httpRequestBuilderClass.getDeclaredMethod("header", String.class, String.class);
                Method requestBuilderVersionMethod = httpRequestBuilderClass.getDeclaredMethod("version", httpVersionEnum);
                requestBuilderTimeoutMethod = httpRequestBuilderClass.getDeclaredMethod("timeout", Duration.class);
                requestBuilderUriMethod = httpRequestBuilderClass.getDeclaredMethod("uri", URI.class);
                requestBuilderCopyMethod = httpRequestBuilderClass.getDeclaredMethod("copy", new Class[0]);
                requestBuilderBuildMethod = httpRequestBuilderClass.getDeclaredMethod("build", new Class[0]);
                requestBuilderPostMethod = httpRequestBuilderClass.getDeclaredMethod("POST", bodyPublisherClass);
                Method requestBuilderNewBuilderMethod = httpRequestClass.getDeclaredMethod("newBuilder", new Class[0]);
                publisherOfByteArrayMethod = bodyPublishersClass.getDeclaredMethod("ofByteArray", byte[].class);
                byteArrayBodyPublisherMethod = bodyHandlersClass.getDeclaredMethod("ofByteArray", new Class[0]);
                httpResponseBodyMethod = httpResponseClass.getDeclaredMethod("body", new Class[0]);
                httpResponseStatusCodeMethod = httpResponseClass.getDeclaredMethod("statusCode", new Class[0]);
                defaultHttpRequestBuilder = requestBuilderNewBuilderMethod.invoke(null, new Object[0]);
                Object http2Version = Enum.valueOf(httpVersionEnum, "HTTP_2");
                requestBuilderVersionMethod.invoke(defaultHttpRequestBuilder, http2Version);
                requestBuilderHeaderMethod.invoke(defaultHttpRequestBuilder, "Content-Type", "application/dns-message");
                requestBuilderHeaderMethod.invoke(defaultHttpRequestBuilder, "Accept", "application/dns-message");
                initSuccess = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Java >= 11 detected, but HttpRequest not available");
            }
        }
        useHttpClient = initSuccess;
    }
}

