/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.audit;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class AuditEvent {
    private static final char PAIR_SEPARATOR = '\t';
    private static final String KEY_VAL_SEPARATOR = "=";
    private Map<String, String> logEntries = new LinkedHashMap<String, String>();
    private Result result;

    AuditEvent(Result result) {
        this.result = result;
    }

    public Set<Map.Entry<String, String>> getLogEntries() {
        return this.logEntries.entrySet();
    }

    void addEntry(FieldName fieldName, String value) {
        if (value != null) {
            this.logEntries.put(fieldName.name().toLowerCase(), value);
        }
    }

    public String getValue(FieldName fieldName) {
        return this.logEntries.get(fieldName.name().toLowerCase());
    }

    public Result getResult() {
        return this.result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.logEntries.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (null == value) continue;
            if (first) {
                first = false;
            } else {
                buffer.append('\t');
            }
            buffer.append(key).append(KEY_VAL_SEPARATOR).append(value);
        }
        if (buffer.length() > 0) {
            buffer.append('\t');
        }
        buffer.append("result").append(KEY_VAL_SEPARATOR).append(this.result.name().toLowerCase());
        return buffer.toString();
    }

    public static enum Result {
        SUCCESS,
        FAILURE,
        INVOKED;

    }

    public static enum FieldName {
        USER,
        OPERATION,
        IP,
        ACL,
        ZNODE,
        SESSION,
        ZNODE_TYPE;

    }
}

