/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.table;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableSet;
import org.apache.amoro.spark.reader.SparkScanBuilder;
import org.apache.amoro.table.BasicUnkeyedTable;
import org.apache.amoro.table.MetadataColumns;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkChangeTable
extends SparkTable {
    private final BasicUnkeyedTable basicUnkeyedTable;
    private SparkSession lazySpark = null;
    private static final Set<TableCapability> CAPABILITIES = ImmutableSet.of((Object)TableCapability.BATCH_READ);

    public SparkChangeTable(BasicUnkeyedTable basicUnkeyedTable, boolean refreshEagerly) {
        super((Table)basicUnkeyedTable, refreshEagerly);
        this.basicUnkeyedTable = basicUnkeyedTable;
    }

    private SparkSession sparkSession() {
        if (this.lazySpark == null) {
            this.lazySpark = SparkSession.active();
        }
        return this.lazySpark;
    }

    public Set<TableCapability> capabilities() {
        return CAPABILITIES;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        return new SparkScanBuilder(this.sparkSession(), (MixedTable)this.basicUnkeyedTable, options, this.buildSchema(this.basicUnkeyedTable));
    }

    public Schema buildSchema(BasicUnkeyedTable table) {
        Schema schema = table.schema();
        List columns = schema.columns().stream().collect(Collectors.toList());
        columns.add(MetadataColumns.TRANSACTION_ID_FILED);
        columns.add(MetadataColumns.FILE_OFFSET_FILED);
        columns.add(MetadataColumns.CHANGE_ACTION_FIELD);
        return new Schema(columns);
    }

    public StructType schema() {
        return SparkSchemaUtil.convert((Schema)this.buildSchema(this.basicUnkeyedTable));
    }
}

