/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.sql.connector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.amoro.data.PrimaryKeyData;
import org.apache.amoro.shade.guava32.com.google.common.base.Joiner;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.iceberg.Schema;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;

public class FileIndexBucket
implements Transform {
    private final Schema schema;
    private final PrimaryKeyData primaryKeyData;
    private final int mask;
    private final String[] primaryKeyColumns;

    public FileIndexBucket(Schema schema, PrimaryKeySpec keySpec, int mask) {
        this.primaryKeyData = new PrimaryKeyData(keySpec, schema);
        this.mask = mask;
        this.primaryKeyColumns = (String[])keySpec.fields().stream().map(PrimaryKeySpec.PrimaryKeyField::fieldName).toArray(String[]::new);
        this.schema = schema;
    }

    public Schema schema() {
        return this.schema;
    }

    public PrimaryKeyData primaryKeyData() {
        return this.primaryKeyData;
    }

    public int mask() {
        return this.mask;
    }

    public String name() {
        return "FileIndexBucket";
    }

    public NamedReference[] references() {
        return (NamedReference[])Arrays.stream(this.primaryKeyColumns).map(Expressions::column).toArray(NamedReference[]::new);
    }

    public Expression[] arguments() {
        ArrayList arguments = Lists.newArrayList();
        arguments.add(Expressions.literal((Object)this.mask));
        arguments.addAll(Arrays.asList(this.references()));
        return arguments.toArray(new Expression[0]);
    }

    public String describe() {
        String columns = Joiner.on((String)", ").join((Object[])this.primaryKeyColumns);
        return "FileIndexBucket(" + this.mask + ", " + columns + ")";
    }
}

